/**
 * Copyright djakarta_trap ( http://wonderfl.net/user/djakarta_trap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Onl
 */

// Tweener で100個の画像（50*50）を動かしてみる。
// フレームレートが落ちるかどうかを見るためのテスト。
package {
    import flash.display.Sprite;
	import flash.events.MouseEvent;
	import jp.progression.casts.CastSprite;
	import jp.progression.casts.getInstanceById;
	import jp.progression.commands.CommandInterruptType;
	import jp.progression.commands.lists.ParallelList;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.Prop;
	import jp.progression.commands.tweens.DoTweener;
	import net.hires.debug.Stats;
	
	[SWF(width="465", height="465", frameRate="60")]
	
    public class FlashTest extends Sprite {
		private var _instances:Array;
        public function FlashTest() {
            this.addChild(new CastSprite( { id:"container" } ));
			this.addChild(new Stats());
			_instances = [];
			createInstances(200);
			stage.addEventListener(MouseEvent.CLICK, animateInstances);
			
        }
		
		private function animateInstances(e:MouseEvent):void 
		{
			var comm:ParallelList = new ParallelList();
			for (var i:int = 0; i < _instances.length; i++)
			{
				comm.addCommand( 
					[
						new DoTweener(_instances[i], { x:0, y:0, time:1, transition:"easeOutExpo" }, { interruptType:CommandInterruptType.SKIP } ),
						new Prop(_instances[i], { x:_instances[i].x, y:_instances[i].y } )
					]
				)
			}
			comm.execute();
		}
		
		private function createInstances(num:int):void
		{
			for (var i:int = 0; i < num; i++)
			{
				var cast:CastSprite = new CastSprite({x:Math.random()*stage.stageWidth, y:Math.random()*stage.stageHeight});
				cast.graphics.beginFill(Math.random() * 0xffffff);
				cast.graphics.drawRect( -25, -25, 50, 50);
				cast.graphics.endFill();
				_instances.push(cast);
				(getInstanceById("container") as CastSprite).addChild(cast);
			}
		}
    }
}