/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5O7j
 */

package {

    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.text.engine.ContentElement;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextElement;
    import flash.text.engine.GraphicElement;
    import flash.text.engine.GroupElement;
    import flash.text.engine.TextLine;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    
    public class GroupElementExample extends Sprite {
        
        public function GroupElementExample():void {
            
            var redBox:MovieClip = new MovieClip();
            redBox.graphics.beginFill(0xCC0000, 1.0);
            redBox.graphics.drawRect(0, 0, 20, 20);
            redBox.graphics.endFill(); 
            
            var format:ElementFormat = new ElementFormat();
            var fontDescription:FontDescription = new FontDescription("Arial");
            format.fontSize = 16;
            format.fontDescription = fontDescription;
            
            var str1:String = "This red box is a GraphicElement ";
            var str2:String = " in the middle of two TextElements, " +
            " which together\n make " +
            "up a GroupElement in a TextBlock that is broken into three lines.";
            
            trace(str1);
            
            var textElement1:TextElement = new TextElement(str1,format);
            var graphicElement:GraphicElement = new GraphicElement(redBox,redBox.width,redBox.height, format);
            var textElement2:TextElement = new TextElement(str2, format);
            var groupVector:Vector.<ContentElement> = new Vector.<ContentElement>();
            groupVector.push(textElement1, graphicElement, textElement2);
            var groupElement:GroupElement = new GroupElement(groupVector);
            var textBlock:TextBlock = new TextBlock();
            textBlock.content = groupElement;
            createTextLines(textBlock);
        }
        
        private function createTextLines(textBlock:TextBlock):void 
        {
            var yPos:int = 20;
            var line_length:Number = 450;
            var textLine:TextLine = textBlock.createTextLine (null, line_length);
 
            while (textLine)
            {
                addChild(textLine);
                textLine.x = 15;
                yPos += textLine.height+8;
                textLine.y = yPos;
                textLine = textBlock.createTextLine(textLine, line_length);
            }
        }
    }    
}