/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5NnV
 */

package {
	// 女王バチを追う雄バチの群れを表現
	// Queen クラスの move() メソッドと
	// Drone クラスの chase(Queen) メソッドを
	// 書き換えれば動きに変化が現れるはず...
	import flash.display.*;
	import flash.events.*;

	public class Main extends Sprite {
		private const _numDrones:int = 30; // 雄バチの数
		private var drone:Array; // 雄バチの配列
		private var queen:Queen; // 女王バチ
		public function Main():void {
			var i:int;
			stage.align = StageAlign.TOP_LEFT; // 左上隅に追く
			stage.scaleMode = StageScaleMode.NO_SCALE; // 縮尺しない
			// ステージを背景色で塗りつぶす
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			this.graphics.endFill();
			// 女王さま登場
			queen = new Queen();
			this.addChild(queen);
			// 雄バチの群れが出現
			drone = new Array;
			for (i = 0; i < _numDrones ; ++i ) {
				drone[i] = new Drone();
				this.addChild(drone[i]);
			}
			stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
		} // end of function Main
		private function atEveryFrame(e:Event):void {
			var i:int;
			queen.move(); // 女王が動き...
			for ( i = 0 ; i < _numDrones ; ++i ) {
				drone[i].chase(queen); // 雄バチたちが追う
			}
		} // end of function atEveryFrame
	} // end of class Main
}// end of package


// 女王バチを追う雄バチのクラス
class Drone extends flash.display.Sprite {
	static private const dt:Number = 1.0e-01;
	static private const degr:Number = 84;
	public function Drone():void {
		// 雄バチには微妙な色の違いと初期位置の他には個性がない
		var c:uint = Math.floor(128+Math.random()*127.999);
		this.graphics.beginFill((c<<16)|(c<<8));
		this.graphics.drawCircle(0,0,2);
		this.graphics.endFill();
		this.x = Math.random()*465;
		this.y = Math.random()*465;
	}
	public function chase(Q:Queen):void {
	// 雄バチが女王を追う.
	// 進む方向は女王のいる方向を中心とした ±degr 度 の開きから乱数で選ばれる
	// 方向が正規分布したほうが面白い気もするが今回はサボって一様乱数を使う
		var theta:Number = (Math.random()*2-1)*Math.PI/180*degr;
		x += ((Q.x-x)*Math.cos(theta)-(Q.y-y)*Math.sin(theta))*dt;
		y += ((Q.x-x)*Math.sin(theta)+(Q.y-y)*Math.cos(theta))*dt;
	}
}

// 女王バチのクラス
class Queen extends flash.display.Sprite {
	private var clock:Number;
	public function Queen():void {
		this.graphics.beginFill(0xff00cc);
		this.graphics.drawCircle(0,0,4);
		this.graphics.endFill();
		this.x = 0;
		this.y = 0;
		clock = 0;
	}
	public function move():void {
		const R:Number = 0.45; // とりあえず単純な円運動をさせてみる
		clock = (++clock)%200;
		this.x = (0.5 + R*Math.cos(clock*Math.PI/100))*stage.stageWidth;
		this.y = (0.5 - R*Math.sin(clock*Math.PI/100))*stage.stageHeight;
	}
}