/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5McB
 */

// forked from ProjectNya's Twinkle [Happy Birthday for SIHO]
////////////////////////////////////////////////////////////////////////////////
// Twinkle [Happy Birthday for SIHO]
//
// [AS3.0] Twinkleクラスに挑戦！ (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1542
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.utils.escapeMultiByte;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var detection:DetectPixels;
        private static var accuracy:uint = 1;
        private var threshold:uint = 0x80FFFFFF;
        private var twinkle:Twinkle;
        private var container:Sprite;
        private var loader:ImageLoader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var filePath:String = "0/0b/0ba8/0ba8d578e58e6e0669f70ff6efc72b29d1e32493";
        private var itween:ITween;
        private var playing:Boolean = false;
        private var playBtn:Btn;
        private var stopBtn:Btn;
        private var se:SoundEffect;
        private static var soundPath:String = "http://www.project-nya.jp/images/wonderfl/happy.mp3";
        private var initialized:uint = 0;
        private static var twitterPath:String = "http://twitter.com/intent/tweet?text=";

        public function Main() {
            //Wonderfl.capture_delay(1);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            container = new Sprite();
            addChild(container);
            container.x = 0;
            container.y = 72;
            container.alpha = 0.2;
            //
            playBtn = new Btn();
            addChild(playBtn);
            playBtn.x = 192;
            playBtn.y = 440;
            playBtn.init({label: "play", type: 2});
            playBtn.addEventListener(MouseEvent.CLICK, play, false, 0, true);
            playBtn.enabled = false;
            stopBtn = new Btn();
            addChild(stopBtn);
            stopBtn.x = 272;
            stopBtn.y = 440;
            stopBtn.init({label: "stop", type: 2});
            stopBtn.addEventListener(MouseEvent.CLICK, stop, false, 0, true);
            stopBtn.enabled = false;
            //
            loader = new ImageLoader();
            loader.x = 32;
            loader.y = 0;
            loader.alpha = 0.2;
            loader.addEventListener(ImageLoader.COMPLETE, loaded, false, 0, true);
            loader.load(basePath + filePath, true);
            //
            se = new SoundEffect();
            se.addEventListener(Event.COMPLETE, initialize, false, 0, true);
            se.load(soundPath, 0.8);
        }
        private function loaded(evt:Event):void {
            loader.removeEventListener(ImageLoader.COMPLETE, loaded);
            //
            var bitmap:Bitmap = loader.content;
            container.addChild(bitmap);
            bitmap.x = 32;
            bitmap.y = 0;
            //
            var label:Label = new Label(400, 120, 60, Label.CENTER);
            container.addChild(label);
            label.x = 32;
            label.y = 200;
            label.textColor = 0xFFFFFF;
            label.text = "SIHO";
            //
            var area:Rectangle = new Rectangle(0, 0, 465, 320);
            detection = new DetectPixels(accuracy);
            detection.search(container, area, threshold);
            var map:Array = detection.pixels();
            //
            var rect:Rectangle = new Rectangle(0, 0, 465, 320);
            twinkle = new Twinkle(rect, map);
            addChild(twinkle);
            twinkle.x = 0;
            twinkle.y = 72;
            twinkle.addEventListener(Event.COMPLETE, complete, false, 0, true);
            //twinkle.start();
            //
            initialized ++; 
            setup();
        }
        private function initialize(evt:Event):void {
            se.removeEventListener(Event.COMPLETE, initialize);
            initialized ++; 
            setup();
        }
        private function setup():void {
            if (initialized > 1) {
                playBtn.enabled = true;
            }
        }
        private function play(evt:MouseEvent):void {
            playing = true;
            playBtn.selected = true;
            stopBtn.enabled = true;
            twinkle.start();
            start();
            se.play(true);
            //
            var msg:String = "SIHOさん、お誕生日おめでとう！ #HappyBirthdayForSIHO";
            navigateToURL(new URLRequest(twitterPath + escapeMultiByte(msg)), "_blank");
        }
        private function stop(evt:MouseEvent):void {
            playing = false;
            stopBtn.enabled = false;
            twinkle.stop();
            reset();
            se.stop();
        }
        private function complete(evt:Event):void {
            playBtn.selected = false;
        }
        private function start():void {
            itween = BetweenAS3.serial(
                BetweenAS3.to(container, {alpha: 0.5}, 3, Linear.easeNone), 
                BetweenAS3.to(container, {alpha: 0.2}, 3, Linear.easeNone)
            );
            itween.addEventListener(TweenEvent.COMPLETE, repeat, false, 0, true);
            itween.play();
        }
        private function reset():void {
            if (itween) {
                itween.stop();
                itween = null;
            }
            itween = BetweenAS3.to(container, {alpha: 0.2}, 0.4, Linear.easeNone);
            itween.play();
        }
        private function repeat(evt:TweenEvent):void {
            evt.target.removeEventListener(TweenEvent.COMPLETE, repeat);
            if (playing) start();
        }
        
    }

}


//////////////////////////////////////////////////
// Twinkleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.utils.Dictionary;
import flash.utils.Timer;
import flash.events.TimerEvent;

class Twinkle extends Sprite {
    private var rect:Rectangle;
    private var map:Array;
    private var id:uint = 0;
    private var particles:Dictionary;
    private var timer:Timer;
    private static var interval:uint = 20;

    public function Twinkle(r:Rectangle, m:Array) {
        rect = r;
        map = m;
    }

    public function start():void {
        id = 0;
        particles = new Dictionary(true);
        create();
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, create, false, 0, true);
        timer.start();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        if (timer) {
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER, create);
            timer = null;
        }
    }
    private function create(evt:TimerEvent = null):void {
        var radius:Number = 15 + Math.random()*15;
        var particle:ParticleLight = new ParticleLight(6, radius);
        addChild(particle);
        particle.id = id;
        var mid:uint = uint(Math.random()*map.length);
        var px:Number = map[mid].x;
        var py:Number = map[mid].y;
        particle.x = px;
        particle.y = py;
        particle.rotation = Math.random()*360;
        particles[id] = particle;
        particle.addEventListener(Event.COMPLETE, complete, false, 0, true);
        particle.start();
        id ++;
    }
    private function complete(evt:Event):void {
        var particle:ParticleLight = ParticleLight(evt.target);
        particle.removeEventListener(Event.COMPLETE, complete);
        removeChild(particle);
        delete particles[particle.id];
        particle = null;
    }
    private function update(evt:Event):void {
        var count:uint = 0;
        for (var n:String in particles) {
            if (particles[n]) count++;
        }
        if (count < 1) {
            removeEventListener(Event.ENTER_FRAME, update);
            dispatchEvent(new Event(Event.COMPLETE));
        }
    }

}


//////////////////////////////////////////////////
// ParticleLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.display.BlendMode;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;
import frocessing.color.ColorHSV;

class ParticleLight extends Sprite {
    public var id:uint;
    private static var unit:uint = 6;
    private static var radius:uint = 25;
    private static var blur:Number = 16;
    private var color:ColorHSV;
    private var itween:ITween;

    public function ParticleLight(u:uint = 6, r:uint = 25) {
        unit = u;
        radius = r;
        blur = radius*0.64;
        init();
    }

    private function init():void {
        var hue:Number = Math.random()*360;
        color = new ColorHSV(hue, 0.5);
        draw();
        alpha = 0;
        visible = false;
        scaleX = scaleY = 0;
        blendMode = BlendMode.ADD;
    }
    public function start():void {
        itween = BetweenAS3.serial(
            BetweenAS3.to(this, {scaleX: 1, scaleY: 1, alpha: 1, visible: 1}, 0.3, Expo.easeOut), 
            BetweenAS3.to(this, {scaleX: 0, scaleY: 0, alpha: 0, visible: 0}, 1.2, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, complete, false, 0, true);
        itween.play();
    }
    private function complete(evt:TweenEvent):void {
        itween.removeEventListener(TweenEvent.COMPLETE, complete);
        dispatchEvent(new Event(Event.COMPLETE));
    }
    private function draw():void {
        for (var n:uint = 0; n < unit; n++) {
            var shape:Shape = new Shape();
            addChild(shape);
            shape.graphics.beginFill(color.value);
            shape.graphics.moveTo(0, -radius*0.1);
            shape.graphics.curveTo(0, 0, radius, 0);
            shape.graphics.curveTo(0, 0, 0, radius*0.1);
            shape.graphics.endFill();
            shape.rotation = 360/unit*n;
        }
        filters = [new GlowFilter(color.value, 1, blur, blur, 4, 3, false, false)];
    }

}


//////////////////////////////////////////////////
// DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;
    private var offset:Object = {x: 0, y: 0};

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF, o:Object = null):void {
        bd = t;
        rect = r;
        threshold = th;
        if (o) offset = o;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x + offset.x;
                    var py:int = y*accuracy + rect.y + offset.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}


//////////////////////////////////////////////////
// ImageLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class ImageLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:*;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function ImageLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(ImageLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(ImageLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(ImageLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        dispatchEvent(new Event(ImageLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(ImageLoader.COMPLETE));
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;
import flash.events.IOErrorEvent;
import flash.media.SoundLoaderContext;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var _volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;

    public function SoundEffect() {
    }

    public function init(Snd:Class, lv:Number = 1):void {
        sound = new Snd();
        level = lv;
    }
    public function load(filePath:String, lv:Number = 1):void {
        sound = new Sound();
        sound.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
        try {
            sound.load(new URLRequest(filePath), new SoundLoaderContext(10, true));
        } catch (err:Error) {
            trace(err.message);
        }
        level = lv;
    }
    private function ioerror(evt:IOErrorEvent):void {
        trace(evt.text);
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(loop:Boolean = false):void {
        playing = true;
        if (channel) channel.stop();
        looping = loop;
        channel = sound.play();
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
        if (looping) {
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
        }
    }
    public function stop():void {
        playing = false;
        if (channel) {
            channel.stop();
            channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        }
    }
    public function get volume():Number {
        return _volume;
    }
    public function set volume(value:Number):void {
        _volume = value;
        if (channel) {
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*_volume;
        channel.soundTransform = transform;
        }
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
