/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5MYd
 */

// forked from hiddemeulenbeek's forked from: Tracing outline text
// forked from Daan.Meijer's Tracing outline text
// forked from Kay's Outline Text
// forked from Kay's Shining Text
/* 
 * Made for a friend :)
 *
 * original comments:
 * テキストをアウトライン化してVector.<Point>に保存し
 * テキストの外周から線を引いて光を表現する
 * 先々を考えて、とっ散らかった処理を修正
 * -----------------------------------------------------
 * …結果的にfontSizeが小さいと、思ったラインが引けていないことを露呈
 * が、この座標データを拡大してオリジナルのサイズとラインか面でつなげば
 * fork元のShining Textより軽く、しかも美しくなりそうな予感がする
 */
package {
    import flash.utils.Proxy;
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.Event;
    
    [SWF(framerate=30, backgroundColor=0x000000)]
    public class Main extends Sprite {
     
        public function colorDiff(color1:uint, color2:uint):uint{
            var rPart:uint = Math.abs(((color1 & 0xff0000) >> 16) - ((color2 & 0xff0000) >> 16));
            var gPart:uint = Math.abs(((color1 & 0x00ff00) >> 8)  - ((color2 & 0x00ff00) >> 8));
            var bPart:uint = Math.abs(((color1 & 0x0000ff) >> 0)  - ((color2 & 0x0000ff) >> 0));
            
            //trace(color1, color2, rPart, gPart, bPart);
            return rPart + gPart + bPart ;
        }

        
        
        public const SW:Number = stage.stageWidth;
        public const SH:Number = stage.stageHeight;
        public const CX:Number = SW/2;
        public const CY:Number = SH/2;
        public var vOutline:Vector.<Point> = new Vector.<Point>();
        public var lx:Number = 0;
        public var myStage:Sprite = new Sprite();
        public var textColor:uint = 0xff5800;
        
        private var outline:BitmapData = null;
        
        private function colorIsLike(color1:uint, color2:uint):Boolean{
            var result:uint = colorDiff(color1, color2);
            return result <= 256;
        }

        public var glyphs:Vector.<Vector.<Point>> = new Vector.<Vector.<Point>>();

        private function arePointsCloseEnough(point1:Point, point2:Point):Boolean{
            var xdiff:uint = Math.abs(point1.x - point2.x);
            var ydiff:uint = Math.abs(point1.y - point2.y);
            return xdiff <= 1 && ydiff <= 1;
        }


        public function Main() {
            inittrace(stage);
            
            addChild(myStage);
            
            var myText:SimpleText = new SimpleText('ÁGATA','Georgia',135,textColor);
            addChild(myText);
            myText.y = myText.height;
                
            
            const TW:Number = myText.width;
            const TH:Number = myText.height;

            // Text -> BitmapData
            var bmd:BitmapData = new BitmapData(TW,TH,false,0);
            bmd.draw(myText);
            
            // getColor
                for (var w:int = myText.width - 1; w >= 0; w--) {
            for (var h:int = myText.height - 1; h >= 0; h--) {
                    if(colorIsLike(bmd.getPixel(w,h),textColor)){
                        if (!colorIsLike(bmd.getPixel(w+1,h),textColor) ||
                            !colorIsLike(bmd.getPixel(w-1,h),textColor) ||
                            !colorIsLike(bmd.getPixel(w,h+1),textColor) ||
                            !colorIsLike(bmd.getPixel(w,h-1),textColor)) {
                                vOutline.push(new Point(w,h));
    
                        }
                    }

                }
            }
            
            vOutline.reverse();
    
         
            
            //Convert outline to different parts
            var maxIterations:uint = 100000;
            
            var iterations:uint = 0; //guard against infinite loop
            while(vOutline.length > 0){
                
                if(vOutline[0] == null){
                    vOutline.shift();
                    continue;
                }

                var currentGlyph:Vector.<Point> = new Vector.<Point>();
                
                var currentPoint:Point = vOutline.shift();
                currentGlyph.push(currentPoint);
                
                var shouldContinue:Boolean = true;
                
                while(shouldContinue && iterations < maxIterations){
                    

                    if(iterations++ > maxIterations){
                        trace("REturning from asdf");
                        return;
                    }
                        
                    shouldContinue = false;
                                        
                    for(var index:uint = 0; index<vOutline.length; index++){
                    
                        if(vOutline[index] == null){
                            continue;
                        }
   
                        if(
                            arePointsCloseEnough(currentGlyph[currentGlyph.length - 1], vOutline[index]) ||
                            (currentGlyph.length > 2 
                                && arePointsCloseEnough(currentGlyph[currentGlyph.length - 2], vOutline[index]) 
                                && arePointsCloseEnough(currentGlyph[currentGlyph.length - 1], currentGlyph[currentGlyph.length - 2])
                            ) ||
                            false
                            ){
                            currentGlyph.push(vOutline[index]);
                            vOutline[index] = null;
                            shouldContinue = true;
                            continue;
                        }else{
                            //trace("No match", currentGlyph[currentGlyph.length - 1]);
                        }
    
    
                    }

                }
                glyphs.push(currentGlyph);
              
            }
            

            
            outline = new BitmapData(TW,TH,false,0x00000000);

            var bitmap:Bitmap = new Bitmap(outline);
            addChild(bitmap);
  
            drawTimer = new Timer(1, vOutline.length);
            drawTimer.addEventListener(TimerEvent.TIMER, drawNextPixel);
            drawTimer.start();

            /** /
            for (var i:uint = 0; i < firstGlyph.length; i++) {
                if(firstGlyph[i] == null){
                    continue;
                }
                var point:Point = firstGlyph[i];
                outline.setPixel(point.x, point.y, 0xffff0000);
            }
            /**/
            
            //bitmap.x = (SW-TW)/2;
            //bitmap.y = (SH-TH)/2+TH;
        }
        
        private var drawTimer:Timer = null;
        
        public function drawNextPixel(e:TimerEvent):void {
            //trace(glyphs);
            if(glyphs.length <= 0){
                drawTimer.stop();
                return;
            }
            
            if(glyphs[0].length <= 0){
                glyphs.shift();
                return;
            }


            outline.lock();
            
            var point:Point = glyphs[0].shift();
            //trace("drawing", point);
            outline.setPixel(point.x, point.y, 0xffffff);
            
            outline.unlock();
        }

    }
    

}






import flash.display.*;
import flash.text.*;
class SimpleText extends Sprite {
    public function SimpleText(message:String, fontName:String, fontSize:Number, fontColor:uint) {
        var tf:TextFormat = new TextFormat();
        tf.color = fontColor;
        tf.size = fontSize;
        tf.font = fontName;
        
        var txt:TextField = new TextField();
        txt.autoSize = TextFieldAutoSize.LEFT;
        txt.text = message;
        txt.selectable = false;
        txt.setTextFormat(tf);
        
        addChild(txt);
    }
}















/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
        
        public static function clear():void {
            while(TextFields.length > 0){
                
                trace_stage.removeChild(TextFields.shift());
                
            }

        }

    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}
