/**
 * Copyright godspeed1977max ( http://wonderfl.net/user/godspeed1977max )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5MQl
 */

// forked from su8erlemon's Dot Visualizer
package  {
    import flash.display.Shape;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.display.StageQuality;
    import flash.events.MouseEvent;
    import frocessing.color.ColorHSV;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.display.BlendMode;
    import frocessing.color.ColorHSL;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import flash.media.SoundMixer;
    import flash.media.SoundChannel;
    import flash.system.Security;
    import flash.filters.ColorMatrixFilter;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x000000")]
    public class Main extends MovieClip{

        private const SW:int = 465;
        private const SH:int = 465;
        
        private const SPEED:int = 40;
        private const MAX_NUM:int = 25;
        
        private var st:Sprite = new Sprite();
        
        private var rl:Number = 0;
        private var rl2:Number = 0;
        
        private var rects:Vector.<Shape>;
        private var rectPoints:Vector.<Point>;
        
        private var perse:PerspectiveProjection;
        
        private var ry:int = 0;
        private var rx:int = 0;
        
        private var zz:int = 0;
        
        private var startTime:Number;
        private var prevBeat:Number;
        
        private var sound:Sound = new Sound();
        
        private var spectBytes:ByteArray = new ByteArray();
        private var spectrum:Vector.<Number> = new Vector.<Number>(512, true);
        private var spectrumAverage:Number = 0.0;

        private var back:Shape = new Shape();
        public function Main() {
            Security.loadPolicyFile('http://su8erlemon.com/crossdomain.xml');
            sound.addEventListener(Event.COMPLETE, soundLoadCompleteHandler);
            sound.load(new URLRequest('http://su8erlemon.com/lab/music/music2.mp3'));
            
        }
        
        private function soundLoadCompleteHandler(e:Event):void{
            sound.removeEventListener(Event.COMPLETE, soundLoadCompleteHandler);

            back.graphics.beginFill(0x000000,1);
            back.graphics.drawRect(0,0,465,465);
            back.graphics.endFill();
            addChild(back);
            
            stage.quality = StageQuality.LOW;
            rects = new Vector.<Shape>(MAX_NUM,true);
            rectPoints = new Vector.<Point>(MAX_NUM,true);
            
            perse = root.transform.perspectiveProjection;        
            perse.fieldOfView =65;
            
            for(var i:uint = 0;i<MAX_NUM;i++){
                var rect:Shape = new Shape();
                rect.graphics.beginFill(0xffffff,1);
                rect.graphics.drawCircle(0,0,50);
                rect.graphics.endFill();
                
                rect.x = -200 + 200 * int(i/5);
                rect.y = -200 + 200 * int(i%5);

                rectPoints[i] = new Point(rect.x,rect.y);
                rects[i] = rect;
                
                st.addChild(rect);
            }
            
            trace(st.width);
            st.graphics.beginFill(0x00ff00,0);
            st.graphics.drawRect(0,0,200,200);
            st.graphics.endFill();
            st.x = 0;//-SW/2;
            st.y = 0;//-SH/2;            
            addChild(st);


            
            var sc:SoundChannel = sound.play();
            sc.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
            addEventListener(Event.ENTER_FRAME,loop);
            
            startTime = getTimer();
            prevBeat = 0.0;
        }
        
        private function soundCompleteHandler(e:Event):void{
            var sc:SoundChannel = e.target as SoundChannel;
            
            sc.removeEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
            sc.stop();
            sc = sound.play();
            sc.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
            
            prevBeat = 0.0;
            startTime = getTimer();
        }
        
    
        private function loop(e:Event):void{            
            computeSpectrum();
            
            rl += 0.1;
            rl2 += 0.005;
            
            st.z += (zz - st.z)/6;
       
            for(var i:uint = 0;i<MAX_NUM;i++){                 
                rects[i].x += (rectPoints[i].x - rects[i].x)/6;
                rects[i].y += (rectPoints[i].y - rects[i].y)/6;
            }
            

            var interval:uint = ( 60 * 1000)/140;
            var current:Number = getTimer() - startTime;
            var beat:uint = int(current/interval*2);
            
            if(int(beat*0.5) != int(prevBeat*0.5)){
                for(var ii:uint = 0;ii<MAX_NUM;ii++){
                    rl = 0;
                    rl2 += 90;                  
                    rects[ii].x = rects[ii].x -500 + Math.random() * 1000;
                    rects[ii].y = rects[ii].y -500 + Math.random() * 1000;
                    rects[ii].scaleX = 1;
                    rects[ii].scaleY = 1;
                }
                    zz = int(-700*spectrumAverage*spectrumAverage);
                    if(zz < 100)zz = 100;
            }
                                    
            if(int(0.125+beat*0.125) != int(0.125+prevBeat*0.125)){
                for(ii = 0;ii<MAX_NUM;ii++){
                    rl = 0;
                    rl2 = 5;
                           
                    rects[ii].x = rects[ii].x -100 + Math.random() * 200;
                    rects[ii].y = rects[ii].y -100 + Math.random() * 200;
                    
                    rects[ii].scaleX = 0.4;
                    rects[ii].scaleY = 0.4;
                }
                zz = int(-700*spectrumAverage*spectrumAverage);
               if(zz < 100)zz = 100;
            }
        
            
            st.rotationY = Math.sin(rl2)*30;
            st.rotationX = Math.sin(rl2*3)*30;
            st.rotationZ = Math.sin(rl2)*30;
       
            prevBeat = beat;
        }
        
        
        private function computeSpectrum():void{
            var bytes:ByteArray = spectBytes;
            bytes.position = 0;
            
            SoundMixer.computeSpectrum(bytes, false);
            
            var total:Number = 0;
            var plus:Number = 0;
            var pc:uint = 0;
            var minus:Number = 0;
            var mc:uint = 0;
            var numbers:Vector.<Number> = spectrum;
            for (var i:uint = 0; i < 512; ++i) {
                var n:Number = bytes.readFloat() * 2.0;
                total += Math.abs(n);
                if (n > 0) {
                    plus += n;
                    ++pc;
                }
                else if (n < 0) {
                    minus += n;
                    ++mc;
                }
                numbers[i] = n;
            }
            spectrumAverage = total / 512.0;
        }
    }
}