/**
 * Copyright vasari ( http://wonderfl.net/user/vasari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5MQC
 */

// forked from uwi's flash on 2009-8-17
package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import org.papervision3d.view.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.render.*;
    
    // TODO 回転軸の計算
    [SWF(frameRate="120", backgroundColor = "#eeeeee")]
    public class FlashTest extends Sprite {
        private var _vp : Viewport3D;
        private var _s : Scene3D;
        private var _c : Camera3D;
        private var _cm : ColorMaterial;
        private var _ml : MaterialsList;
        private var _cube : Cube;
        private var _bre : BasicRenderEngine;
        private var _ax : Vector3D = Vector3D.X_AXIS;
        private var _ay : Vector3D = Vector3D.Y_AXIS;
        private var _az : Vector3D = Vector3D.Z_AXIS;
       //private var _rz : Matrix3D = new Matrix3D(new Vector.<Number>([0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]));
        //private var _rx : Matrix3D = new Matrix3D(0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
        //private var _ry : Matrix3D = new Matrix3D(0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
        
        public function FlashTest() {
            var vec : Vector.<Number> = Vector.<Number>([0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
            var _rz : Matrix3D = new Matrix3D(vec);
            
            var tf : TextField = new TextField();
            _ay = Vector3D.Y_AXIS;
            tf.appendText("" + _ay + "\n");
            addChild(tf);
            _ay = _rz.deltaTransformVector(_ay);
            tf.appendText("" + _ay + "\n");
            
            _vp = new Viewport3D(0, 0, true, false);
            addChild(_vp);
            _s = new Scene3D();
            _c = new Camera3D();
            _bre = new BasicRenderEngine();
            
            _ml = new MaterialsList();
            _ml.addMaterial(new ColorMaterial(randomColor()), "front");
            _ml.addMaterial(new ColorMaterial(randomColor()), "back");
            _ml.addMaterial(new ColorMaterial(randomColor()), "left");
            _ml.addMaterial(new ColorMaterial(randomColor()), "right");
            _ml.addMaterial(new ColorMaterial(randomColor()), "top");
            _ml.addMaterial(new ColorMaterial(randomColor()), "bottom");
            
            _cube = new Cube(_ml, 100, 100, 100);
            _cube.y = 50;
            _s.addChild(_cube);
            
            var _plane : Plane = new Plane(new ColorMaterial(randomColor()), 100, 100);
            _plane.x = 0;
            _plane.rotationX = 90;
            _s.addChild(_plane);
            
            _c.z = -300;
            _c.y = 150;
            _c.lookAt(_cube);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
        }
        
        private function randomColor() : uint
        {
            return  (Math.random() * 256) << 16 | 
                    (Math.random() * 256) << 8 | 
                    (Math.random() * 256) << 0;
        }
        
        private function onEnterFrame(e : Event) : void
        {
            if(_cube.rotationZ >= 90){
                if(_cube.rotationY >= 90){
                    _cube.rotationX += 0.4;
                }else{
                    _cube.rotationY += 0.4;
                }
            }else{
                _cube.rotationZ += 0.4;
            }
            var t : Number = (_cube.rotationZ + 45) / 180 * 3.1416;
            _cube.y = 50 * Math.sqrt(2) * Math.sin(t);
            _cube.x = -50 + 50 * Math.sqrt(2) * Math.cos(t);
//            _c.zoom /= 1.001;
            _bre.renderScene(_s, _c, _vp);
        }
    }
}