/**
 * Copyright ffffine ( http://wonderfl.net/user/ffffine )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5M2v
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.ActivityEvent;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.filters.*
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import flash.display.LoaderInfo;
	
	/**
	 * ...
	 * @author ffffine
	 */
	
    [SWF(width = 465, height = 465, backgroundColor = 0x0, frameRate = 30)]
	
	public class NightView extends Sprite
	{
		private var video:Video;
		private var camera:Camera;
		private var currentBMD:BitmapData;
		private var mirrarMatrix:Matrix;
		private var rc:Number = 1 / 2;
		private var gc:Number = 1 / 2;
		private var bc:Number = 1;
		private var tc:Number = -1 / 3;
		private var ghostA:Number = 0;
		private var ghost:Bitmap;		
		private var isActive:Boolean;
                private var isCameraReady:Boolean;
		
		private var myShader:Vignetting = new Vignetting();
		private var myFilter:ShaderFilter = new ShaderFilter(myShader);
		


		public function NightView() 
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
                        Wonderfl.capture_delay(30);
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			Security.loadPolicyFile("http://www.ffffine.net/crossdomain.xml");
			cameraSetting();
			addEventListener(Event.ENTER_FRAME, render);
			camera.addEventListener(ActivityEvent.ACTIVITY, checkLevel);
		}
		
		private function checkLevel(e:ActivityEvent):void 
		{
                        isCameraReady = true;
			if (e.activating) {
				isActive = true;
			} else {
				isActive = false;
			}
  
		}
		
		private function cameraSetting():void
		{
			camera = Camera.getCamera();
			camera.setMode(stage.stageWidth, stage.stageHeight, 30);
			camera.setMotionLevel(70, 1000);
			video = new Video(stage.stageWidth, stage.stageHeight);
			video.attachCamera(camera);
			mirrarMatrix = new Matrix();
			mirrarMatrix.scale( -1, 1);
			mirrarMatrix.translate(stage.stageWidth, 0);
			currentBMD = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
			
			var screen:Bitmap = new Bitmap(currentBMD);
			addChild(screen);
			
			var loader:Loader = new Loader();
			var loaderContext:LoaderContext = new LoaderContext();
			loaderContext.checkPolicyFile = true;
			loader.load(new URLRequest("http://www.ffffine.net/nightvison/image.jpg"),loaderContext);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,loaderComplete);
			
			var sh:Shape = new Shape();
			sh.graphics.clear();
			sh.graphics.beginFill(0x1a4900);
			sh.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			sh.graphics.endFill();
			sh.blendMode="add"
			addChild(sh);
			
			function loaderComplete(e:Event):void 
			{
				ghost = LoaderInfo(e.target).content as Bitmap;
				ghost.blendMode = "add";
				ghost.alpha = 0;
				addChild(ghost);
                                
			}	
		}
		
		private function render(e:Event):void 
		{
			currentBMD.draw(video,mirrarMatrix);
			currentBMD.applyFilter(currentBMD, currentBMD.rect, new Point(), new ColorMatrixFilter([rc, gc, bc, tc, 0, rc, gc, bc, tc, 0, rc, gc, bc, tc, 0, 0, 0, 0, 1, 0]));
			currentBMD.applyFilter(currentBMD, currentBMD.rect, new Point(), myFilter);
			myFilter.shader.data.amount.value = [1];
			myFilter.shader.data.radius.value = [1];
			myFilter.shader.data.size.value = [500,500];
			
			if (isActive && isCameraReady) {
				ghostA -= 0.01;
			} else if (!isActive && isCameraReady){
				ghostA += 0.01;
			}
			if (ghostA > 1) {
				ghostA  = 1;
			} else if (ghostA < 0 ) {
				ghostA = 0;
			}
			if (ghost) {ghost.alpha = ghostA; };
		}
	}

}

    import flash.display.Shader;
    import flash.utils.ByteArray;
    
    /**
     * Vignetting
     * Photo vignetting effect
     * @author Ilya Ovdin
     * @version 1
     * @namespace me.odin
     */
    class Vignetting extends Shader
    {
        //Parameters
        /**
         * (Parameter) size [Number, Number]
         * @type float2
         * @minValue [1, 1]
         * @maxValue [4096, 4096]
         * @defaultValue [1, 1]
         */
        public function get size():Array { return data.size.value; }
        public function set size(value:Array):void { data.size.value = value; }
        public function get size_min():Array { return [1, 1]; }
        public function get size_max():Array { return [4096, 4096]; }
        public function get size_default():Array { return [1, 1]; }
        public function get size_type():String { return "float2"; }
        
        /**
         * (Parameter) amount [Number]
         * @type float
         * @minValue [0]
         * @maxValue [2]
         * @defaultValue [0.5]
         */
        public function get amount():Array { return data.amount.value; }
        public function set amount(value:Array):void { data.amount.value = value; }
        public function get amount_min():Array { return [0]; }
        public function get amount_max():Array { return [2]; }
        public function get amount_default():Array { return [0.5]; }
        public function get amount_type():String { return "float"; }
        
        /**
         * (Parameter) radius [Number]
         * @type float
         * @minValue [0]
         * @maxValue [10]
         * @defaultValue [2.5]
         */
        public function get radius():Array { return data.radius.value; }
        public function set radius(value:Array):void { data.radius.value = value; }
        public function get radius_min():Array { return [0]; }
        public function get radius_max():Array { return [10]; }
        public function get radius_default():Array { return [2.5]; }
        public function get radius_type():String { return "float"; }
        
        //Inputs
        /**
         * (Input) src
         * @channels 4
         */
        public function get src():Object { return data.src.input; }
        public function set src(input:Object):void { data.src.input = input; }
        public function get src_width():int { return data.src.width; }
        public function set src_width(width:int):void { data.src.width = width; }
        public function get src_height():int { return data.src.height; }
        public function set src_height(height:int):void { data.src.height = height; }
        
        //Constructor
        public function Vignetting(init:Object = null):void
        {
            if (_byte == null)
            {
                _byte = new ByteArray();
                for (var i:uint = 0, l:uint = _data.length; i < l; ++i) _byte.writeByte(_data[i]);
            }
            super(_byte);
            for (var prop:String in init) this[prop] = init[prop];
        }
        
        //Data
        private static var _byte:ByteArray = null;
        private static var _data:Vector.<int> = Vector.<int>([-91, 1, 0, 0, 0, -92, 10, 0, 86, 105, 103, 110, 101, 116, 116, 105, 110, 103, -96, 12, 110, 97, 109, 101, 115, 112, 97, 99, 101, 0, 109, 101, 46, 111, 100, 105, 110, 0, -96, 12, 118, 101, 110, 100, 111, 114, 0, 73, 108, 121, 97, 32, 79, 118, 100, 105, 110, 0, -96, 8, 118, 101, 114, 115, 105, 111, 110, 0, 1, 0, -96, 12, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 80, 104, 111, 116, 111, 32, 118, 105, 103, 110, 101, 116, 116, 105, 110, 103, 32, 101, 102, 102, 101, 99, 116, 0, -95, 1, 2, 0, 0, 12, 95, 79, 117, 116, 67, 111, 111, 114, 100, 0, -93, 0, 4, 115, 114, 99, 0, -95, 2, 4, 1, 0, 15, 100, 115, 116, 0, -95, 1, 2, 0, 0, 3, 115, 105, 122, 101, 0, -94, 2, 109, 105, 110, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, 63, -128, 0, 0, -94, 2, 109, 97, 120, 86, 97, 108, 117, 101, 0, 69, -128, 0, 0, 69, -128, 0, 0, -94, 2, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, 63, -128, 0, 0, -95, 1, 1, 2, 0, 8, 97, 109, 111, 117, 110, 116, 0, -94, 1, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, 0, 0, -94, 1, 109, 97, 120, 86, 97, 108, 117, 101, 0, 64, 0, 0, 0, -94, 1, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 63, 0, 0, 0, -95, 1, 1, 2, 0, 4, 114, 97, 100, 105, 117, 115, 0, -94, 1, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, 0, 0, -94, 1, 109, 97, 120, 86, 97, 108, 117, 101, 0, 65, 32, 0, 0, -94, 1, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 64, 32, 0, 0, 29, 2, 0, 49, 0, 0, 16, 0, 48, 3, 0, -15, 2, 0, -80, 0, 29, 4, 0, -13, 3, 0, 27, 0, 50, 3, 0, -128, 63, 0, 0, 0, 29, 3, 0, 97, 3, 0, 0, 0, 3, 3, 0, 97, 0, 0, -80, 0, 29, 5, 0, -63, 2, 0, -80, 0, 2, 5, 0, -63, 3, 0, 96, 0, 36, 3, 0, -127, 5, 0, 16, 0, 50, 3, 0, 64, 63, 0, 0, 0, 29, 3, 0, 49, 0, 0, -80, 0, 3, 3, 0, 49, 3, 0, 80, 0, 36, 3, 0, 65, 3, 0, -80, 0, 4, 3, 0, 32, 3, 0, 64, 0, 3, 3, 0, 32, 3, 0, 0, 0, 29, 3, 0, -128, 3, 0, -128, 0, 7, 3, 0, -128, 2, 0, 64, 0, 29, 3, 0, 64, 2, 0, 0, 0, 3, 3, 0, 64, 3, 0, 0, 0, 29, 3, 0, -128, 3, 0, 64, 0, 29, 3, 0, 64, 3, 0, 0, 0, 50, 3, 0, 32, 0, 0, 0, 0, 50, 3, 0, 16, 63, -128, 0, 0, 29, 5, 0, -128, 3, 0, 64, 0, 10, 5, 0, -128, 3, 0, -128, 0, 29, 5, 0, 64, 5, 0, 0, 0, 9, 5, 0, 64, 3, 0, -64, 0, 29, 3, 0, -128, 5, 0, 0, 0, 50, 3, 0, 64, 63, -128, 0, 0, 29, 3, 0, 32, 3, 0, 0, 0, 9, 3, 0, 32, 3, 0, 64, 0, 29, 3, 0, -128, 3, 0, -128, 0, 50, 3, 0, 64, 63, -128, 0, 0, 29, 3, 0, 32, 3, 0, 64, 0, 2, 3, 0, 32, 3, 0, 0, 0, 29, 5, 0, -30, 3, 0, -88, 0, 3, 5, 0, -30, 4, 0, 24, 0, 29, 1, 0, -30, 5, 0, 24, 0, 29, 1, 0, 16, 4, 0, -64, 0]);
    }



