/**
 * Copyright tester00001 ( http://wonderfl.net/user/tester00001 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Kdu
 */

package {

    //インポート　適当に選んだ
    import flash.display.*;
    import flash.events.Event;
    import flash.text.*;
    import flash.events.MouseEvent;

    //カレンダーを表示するためのクラス
    public class FlashTest extends MovieClip {
                
        //マスの大きさとマス間の隙間の大きさ
        private const massXN:Number = 30;
        private const massYN:Number = 20;
        private const massIntervalXN:Number = 5;
        private const massIntervalYN:Number = 5;

        //マスがオンのときとオフの時のときの透明度  massAlphaBasicが基本の透明度でそれに massAlphaOffNの値とかをかける
        private const massAlphaBasicN:Number=0.3;
        private const massAlphaOnN:Number = 1;
        private const massAlphaOffN:Number = 0;
        private const massAlphaWeekN:Number = 0;
        private const massAlphaMonthAN:Number = 1;
        private const massAlphaMonthBN:Number = 0;
        
        //一番下のシャープの透明度と大きさ
        private const basicShAlphaN:Number = 0.2;
        private const basicShWN:int = 250;
        private const basicShHN:int = 205;
        
        //今見ている時間
        private var yearN:Number;
        private var monthN:Number;
        
        //monthSとweekSのインデックスに応じた配列
        private  const weekA:Array=new Array("Sun","Mon","Tue","Wed","Thu","Fri","Sat");
        private const monthA:Array=new Array("January","February","March","April","May","June","July","August","September","October","November","December");

        //サブスプライトの位置 xの位置は全部一緒
        private const subSpriteXN:Number = 5;
        private const monthSYN:Number = 5;
        private const weekSYN:Number = monthSYN + massYN + 5;
        private const dateSYN:Number = weekSYN + massYN + 5;
        
        //背景を全部黒くするすプライト
        private var bgSp:Sprite=new Sprite();

        //スプライトの用意
        private var basicS:Sprite=new Sprite();
        private var monthS:Sprite=new Sprite();
        private var weekS:Sprite=new Sprite ();
        private var dateS:Sprite=new Sprite ();

        //コンストラクタ
        public function FlashTest ():void {

            //マス目配置
            massPositF ();

            //スプライト配置
            spritePositF ();
            
            //背景を黒くするスプライトの配置
            bgSpPositF();

            //basicSp配置
            basicSpPositF();

            //現在の日にちを取得
            getNowTimeF ();

            //各マスに文字入れる　あと透明度　ついでにイベントセット
            setStringF();

        }

        //コンストラクタではじめにマスを配置する関数
        private function massPositF ():void {

            //月のマスの配置(左から　0:1マス年号　1:1マス今月　2:3マス今月英語　3:1マス左矢印　4:1ます右矢印)
            for (var i3:Number=0; i3<5; i3++) {
                if (i3 <= 1) {
                    addMassF ((massXN+massIntervalXN)*i3,0,massXN,massYN,monthS,"Month"+i3);
                } else if (i3==2) {
                    addMassF ((massXN+massIntervalXN)*i3,0,(massXN*3+massIntervalXN*2),massYN,monthS,"Month"+i3);
                } else {
                    addMassF ((massXN+massIntervalXN)*(i3+2),0,massXN,massYN,monthS,"Month"+i3);
                }

            }

            //曜日のマスの配置
            for (var i1:Number=0; i1<7; i1++) {
                addMassF ((massXN+massIntervalXN)*i1,0,massXN,massYN,weekS,"Week"+i1);
            }

            //日付のマスの配置
            for (var i2:Number=0; i2<6; i2++) {
                for (var j2:Number=0; j2<7; j2++) {
                    addMassF ((massXN+massIntervalXN)*j2,(massYN+massIntervalYN)*i2,massXN,massYN,dateS,"Date"+(i2*7+j2));
                }
            }

        }

        //basicSに各サブスプライトを配置する関数
        private function spritePositF ():void {

            //basicSにテーブルのシャープを投入
            var basicSh:Shape=new Shape();
            basicSh.graphics.lineStyle (1,0xFFFFFF,1);
            basicSh.graphics.beginFill (0xFFFFFF,basicShAlphaN);
            basicSh.graphics.drawRect (0,0,basicShWN,basicShHN);
            basicS.addChild (basicSh);

            //basicSにサブのスプライトを投入
            basicS.addChild (monthS);
            basicS.addChild (weekS);
            basicS.addChild (dateS);

            //サブスプライトの位置
            monthS.x = subSpriteXN;
            monthS.y = monthSYN;
            weekS.x = subSpriteXN;
            weekS.y = weekSYN;
            dateS.x = subSpriteXN;
            dateS.y = dateSYN;
        }

        //マスを一個配置する関数
        //因数　スプライト内のｘ，ｙ　マスの横縦幅　追加するスプライト　追加する入れ子の名前
        private function addMassF (targetXN:Number,targetYN:Number,targetWN:Number,targetHN:Number,targetSp:Sprite,targetSt:String):void {
            
            //スプライト
            //this[~]ではだめ　ここの土台は拡張したムービークリップらしい
            //この場合ムービークリップをドキュメントクラスというらしい
            MovieClip["sp"+targetSt]=new Sprite();

            //下地にアウトラインのない白い長方形
            var boxSh:Shape=new Shape();
            boxSh.graphics.lineStyle (0,0xFFFFFF,0);//線の透明度0
            boxSh.graphics.beginFill (0xFFFFFF,massAlphaBasicN);
            boxSh.graphics.drawRect (0,0,targetWN,targetHN);
            MovieClip["boxSh"+targetSt]=new Sprite();
            MovieClip["boxSh"+targetSt]=boxSh;

            //アウトラインのみ　本当はアウトラインのみの長方形
            var outlineSh:Shape=new Shape();
            outlineSh.graphics.lineStyle (1,0xFFFFFF,1);//線の透明度1
            outlineSh.graphics.beginFill (0xFFFFFF,0);//四角形の中は透明度0
            outlineSh.graphics.drawRect (0,0,targetWN,targetHN);
            MovieClip["outlineSh"+targetSt]=new Shape();
            MovieClip["outlineSh"+targetSt]=outlineSh;

            //アウトラインなしのテキストボックス
            var tf:TextField=new TextField();
            tf.width = targetWN;
            tf.height = targetHN;
            tf.border = false;
            //tf.borderColor=0xFFFFFF;
            tf.background = false;
            tf.textColor = 0xFFFFFF;
            tf.wordWrap = false;
            tf.multiline = false;
            tf.selectable = false;
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.type = TextFieldType.DYNAMIC;
            tf.text = "";
            MovieClip["tf"+targetSt]=new TextField();
            MovieClip["tf"+targetSt]=tf;

            //tempSpに四角とアウトラインとテキストボックスを配置して、ターゲットのスプライトに配置
            MovieClip["sp"+targetSt].addChild (MovieClip["boxSh"+targetSt]);
            MovieClip["sp"+targetSt].addChild (MovieClip["outlineSh"+targetSt]);
            MovieClip["sp"+targetSt].addChild (MovieClip["tf"+targetSt]);
            targetSp.addChild (MovieClip["sp"+targetSt]);

            //ターゲットスプライト内でのspの位置
            MovieClip["sp"+targetSt].x = targetXN;
            MovieClip["sp"+targetSt].y = targetYN;

        }

        //現在の日にちを取得
        private function getNowTimeF ():void {
            var tempD:Date=new Date();
            yearN=tempD.getFullYear();
            monthN=tempD.getMonth()+1;    //返ってくる月の数字は(-1)であることに注意
        }

        //各マスに文字入れる　あと透明度　ついでにイベントセット
        private function setStringF ():void {
            //年月のマスに文字を入れる　あと透明度
            for(var i2:Number=0;i2<5;i2++){
                switch(i2){
                    case 0:
                        MovieClip["tfMonth"+i2].text=yearN;
                        MovieClip["boxShMonth"+i2].alpha=massAlphaMonthAN;
                    break;
                    case 1:
                        MovieClip["tfMonth"+i2].text=monthN;
                        MovieClip["boxShMonth"+i2].alpha=massAlphaMonthAN;
                    break;
                    case 2:
                        MovieClip["tfMonth"+i2].text=monthA[monthN-1];
                        MovieClip["boxShMonth"+i2].alpha=massAlphaMonthBN;
                    break;
                    case 3:
                        MovieClip["tfMonth"+i2].addEventListener(MouseEvent.CLICK,changePreMonthF);
                        MovieClip["tfMonth"+i2].text="←";
                        MovieClip["boxShMonth"+i2].alpha=massAlphaMonthAN;
                    break;
                    case 4:
                        MovieClip["tfMonth"+i2].addEventListener(MouseEvent.CLICK,changeNextMonthF);
                        MovieClip["tfMonth"+i2].text="→";
                        MovieClip["boxShMonth"+i2].alpha=massAlphaMonthAN;
                    break;
                    }
                }

            //曜日のマスに文字を入れる　あと透明度
            for(var i1:Number=0;i1<7;i1++){
                MovieClip["tfWeek"+i1].text=weekA[i1];
                MovieClip["boxShWeek"+i1].alpha=massAlphaWeekN;
            }

            //日付のマスに文字を入れる　あと透明度
            
            //表示する月の初めの曜日
            var tempD:Date=new Date(yearN,monthN-1,1,0,0,0,0);
            var firstWeekN:Number=tempD.getDay();
            
            //表示する最後の曜日
            if(monthN==12){
                tempD=new Date(yearN+1,0,1,0,0,0,0)
            }
            else{
                tempD=new Date(yearN,monthN,1,0,0,0,0);
            }
            var lastWeekN:Number=tempD.getDay()-1;
            if(lastWeekN==(-1)){
                lastWeekN=6;
                }
                
            //マスに数字入れる
            var tempDateN:Number=0;    //今書いてる日付　０はまだ始まってない 100はもう終わった
            for(var i3:Number=0;i3<42;i3++){
                
                //空欄のマスの背景を薄くする
                if(tempDateN==0||tempDateN==100){
                    MovieClip["boxShDate"+i3].alpha=massAlphaOffN;
                    MovieClip["tfDate"+i3].text="";
                    }
                
                if(tempDateN==0&&i3==firstWeekN){
                    tempDateN++;
                    MovieClip["tfDate"+i3].text=tempDateN;
                    MovieClip["boxShDate"+i3].alpha=massAlphaOnN;
                }
                else if(tempDateN>0&&tempDateN<100){
                    tempDateN++;
                    MovieClip["tfDate"+i3].text=tempDateN;
                    MovieClip["boxShDate"+i3].alpha=massAlphaOnN;
                    
                    //この月の最終日か
                    if(tempDateN>=28&&lastWeekN==(i3%7)){
                        tempDateN=100
                    }
                }
            }
        }
        
        //月を変える関数でイベントリスナーで引数を使用できないからしょうがなく定義した関数
        private function changePreMonthF(e:MouseEvent):void{
            changeMonthF(-1);
        }
        
        private function changeNextMonthF(e:MouseEvent):void{
            changeMonthF(1);
        }
        
        //月を変える関数 1:来月　-1：先月
        private function changeMonthF(a:Number):void{
            if(a==1){
                monthN++;
                if(monthN==13){
                    yearN++;
                    monthN=1;
                    }
            }
            else{
                monthN--;
                if(monthN==0){
                    yearN--;
                    monthN=12;
                }
            }
            setStringF();
        }
        
        //背景を黒くするスプライトの配置
        private function bgSpPositF():void{
            addChild(bgSp);
            bgSp.graphics.beginFill(0x000000,1);
            bgSp.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
        }
        
        //basicSp配置
        private function basicSpPositF():void{
            addChild(basicS);
            basicS.x=(stage.stageWidth-basicShWN)/2;
            basicS.y=(stage.stageHeight-basicShHN)/2;
        }
    }
}