/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5KaT
 */






package 
{
    import br.com.stimuli.loading.BulkLoader;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Linear;
    import org.si.sion.events.SiONTrackEvent;
    import org.si.sion.sequencer.SiMMLTrack;
    import org.si.sion.SiONDriver;
    import org.si.sion.SiONVoice;
    
    [SWF(backgroundColor="#ffffff", frameRate="60", width="465", height="465")] 


    public class Main extends Sprite
    {
        private const  _URL_SNARE:String = "http://asset.alumican.net/wonderfl/dr110snr.mp3";
        private const  _GlobalBPM:uint = 30;
        private var    _sionDriver:SiONDriver;
        private var    _sionVoice:SiONVoice;
        private var    _sionBeatCount:int;        
        private var    _uiPlayButton:PushButton;
        private var    _uiStopButton:PushButton;
        private var    _uiCounter:Label;
        private var    _uiBase:Shape;
        
        private var _bulkLoader:BulkLoader;
        
        public function Main():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.EXACT_FIT;
            
            _bulkLoader = new BulkLoader("main");
            _bulkLoader.addEventListener(BulkLoader.COMPLETE, _bulkLoaderCompleteHandler);
            _bulkLoader.add(_URL_SNARE, { type : BulkLoader.TYPE_SOUND });
            _bulkLoader.start();
        }
        
        private function _bulkLoaderCompleteHandler(e:Event):void
        {
            _sionVoice = new SiONVoice( 10 );
            _sionVoice.setMP3Voice(Sound(_bulkLoader.getSound(_URL_SNARE)), true);
            _sionDriver = new SiONDriver();
            _sionDriver.setBeatCallbackInterval(1);
            _sionDriver.setTimerInterruption(1, _sionDriverTimerInterruptionHandler);
            _sionDriver.addEventListener(SiONTrackEvent.BEAT, _sionDriverBeatHandler);
            _sionDriver.bpm = _GlobalBPM;
            
            _setupController();
            _stop();
        }
        
        private function _sionDriverTimerInterruptionHandler():void
        {
            var mmlTrack:SiMMLTrack = _sionDriver.noteOn(69, _sionVoice);
        }
        
        private function _sionDriverBeatHandler(e:SiONTrackEvent):void
        {
            ++_sionBeatCount;
            _uiCounter.text = String(_sionBeatCount);
            BetweenAS3.tween(_uiBase, { alpha : 0 }, { alpha : 1.0 }, 1.0, Linear.easeNone).play();
        }
        
        private function _play():void
        {
            _sionDriver.play();
        }
        
        private function _stop():void
        {
            _sionDriver.stop();
            _sionBeatCount = 0;
            _uiCounter.text = "0";
            _uiBase.alpha = 0;
        }
        
        private function _setupController():void
        {
            _uiBase = Shape(addChild(new Shape()));
            _uiBase.graphics.beginFill(0x000000);
            _uiBase.graphics.drawRect(0, 0, 100, 100);
            _uiBase.graphics.endFill();
            _uiPlayButton = new PushButton(this, 10, 10, "SiONDriver.play", function(e:MouseEvent):void { _play(); } );
            _uiStopButton = new PushButton(this, 120, 10, "SiONDriver.stop", function(e:MouseEvent):void { _stop(); } );
            new Label(this, 10, 170, "COUNTER : SiONTrackEvent.BEAT");
            _uiCounter = new Label(this, 0, 100);
            _uiCounter.scaleX  =  5;
            _uiCounter.scaleY  =  5;
            stage.addEventListener(Event.RESIZE, _stageResizeHandler);
            _stageResizeHandler();
        }
        
        private function _stageResizeHandler(e:Event = null):void 
        {
            _uiBase.width = stage.stageWidth;
            _uiBase.height = stage.stageHeight;
        }
    }
}