/**
 * Copyright Drugys11 ( http://wonderfl.net/user/Drugys11 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5KYe
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
         import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import fl.data.DataProvider;
    import flash.geom.ColorTransform;
    import flash.net.*;

    public class Components extends MovieClip {

        private var contentScale:Number;
        private var images:Array = ["","kelly.jpg", "birds.jpg", "appartment.jpg"];
        private var thumbs:Array = ["","kelly_t.jpg", "birds_t.jpg", "appartment_t.jpg"];
        private var titles:Array = ["","Focuso Girl", "Wired Birds", "Appartments"];
        private var myURLLoader:URLLoader;

        // you can add components with code rather than putting them on the stage
        // but you need to put the component in the library first
        // then you import it and say myButton = new Button(); for instance
        // all these components were just put on stage - a few were resized
        // you can resize and reposition components with code
        // there are many other properties, methods and events too
        // the samples below are what you will usually use

        public function Components() {

            myButton.label = "Toggle Check";
            myButton.addEventListener(MouseEvent.CLICK, doButton);

            myCheckBox.addEventListener(Event.CHANGE, doCheckBox);

            myComboBox.addItem({label:"Hello 1", data:"1"});
            myComboBox.addItem({label:"Hello 2", data:"2"});
            myComboBox.addEventListener(Event.CHANGE, doComboBox);

            myList.addEventListener(Event.CHANGE, doList);

            myNumberStepper.minimum = 1;
            myNumberStepper.maximum = 3;
            myNumberStepper.addEventListener(Event.CHANGE, doNumberStepper);

            myProgressBar.visible = false;

            myButton2.addEventListener(MouseEvent.CLICK, doButton2);

            myProgressBar.source = myScrollPane;
            myProgressBar.addEventListener(Event.COMPLETE, doProgressBar);

            myScrollPane.addEventListener(Event.COMPLETE, doScrollPane);

            mySlider.liveDragging = true;
            mySlider.snapInterval = .5;
            mySlider.minimum = 1;
            mySlider.maximum = 10;
            mySlider.addEventListener(Event.CHANGE, doSlider);

            for (var i:uint=1; i<=20; i++) {
                myTileList.addItem( {label:titles[i%3+1], source:"images/" + thumbs[i%3+1], bigPicture:"images/" + images[i%3+1]} );
            }
            myTileList.columnWidth = 90;
            myTileList.rowHeight = 120;
            myTileList.columnCount = 4;
            myTileList.rowCount = 1;
            myTileList.addEventListener(MouseEvent.CLICK, doTileList);

            myTextInput.addEventListener(Event.CHANGE, doTextInput);

            myLabel.autoSize = "left";
            myLabel.setStyle("textFormat", new TextFormat("Georgia",20));

            var myDataProvider:Array = [];
            for (i=1; i<=20; i++) {
                myDataProvider.push({label:titles[i%3+1], source:thumbs
        }
        private function doButton(e:MouseEvent) {
            myCheckBox.selected = !myCheckBox.selected;
        }
        private function doCheckBox(e:Event) {
            if (e.target.selected) {
                myRadioButton1.selected = true;
            } else {
                myRadioButton2.selected = true;
            }
        }
        private function doComboBox(e:Event) {
            myList.addItem(myComboBox.selectedItem);
        }
        private function doList(e:Event) {
            if (e.target.selectedItem.data > 0) {
                myNumberStepper.value = e.target.selectedItem.data;
            }
        }
        private function doNumberStepper(e:Event) {
            myTextArea.text = "";
            for (var i:uint = 0; i<=6; i++) {
                myTextArea.appendText("Oh yes!\nClick Load to see picture " + myNumberStepper.value + "\n");
            }
        }
        private function doButton2(e:Event) {
            myProgressBar.reset();
            myProgressBar.visible = true;
            myScrollPane.source = "images/" + images[myNumberStepper.value];
        }
        private function doProgressBar(e:Event) {
            myProgressBar.visible = false;
        }
        private function doScrollPane(e:Event) {
            contentScale = Math.min(e.target.width/e.target.content.width, e.target.height/e.target.content.height);
            e.target.content.scaleX = e.target.content.scaleY = contentScale;
            e.target.horizontalScrollBar.scrollPosition = 0;
            e.target.verticalScrollBar.scrollPosition = 0;
            mySlider.value = 1;

        }
        private function doSlider(e:Event) {
            if (contentScale) {
                myScrollPane.content.scaleX = myScrollPane.content.scaleY = contentScale * e.target.value;
            }
        }
        private function doTileList(e:Event) {
            myProgressBar.reset();
            myProgressBar.visible = true;
            myScrollPane.source = myTileList.selectedItem.bigPicture;
        }
        private function doTextInput(e:Event) {
            myLabel.text = e.target.text.toUpperCase();
        }
        private function doDataGrid(e:Event) {
            myProgressBar.reset();
            myProgressBar.visible = true;
            myScrollPane.source = "images/" + e.target.selectedItem.bigPicture;
        }
        private function doColorPicker(e:Event) {
            var myTransform:ColorTransform = new ColorTransform();
            myTransform.color = e.target.selectedColor;
            myBackground.transform.colorTransform = myTransform;
        }
        private function doURLLoader(e:Event) {
            myCode.wordWrap = false;
            myCode.text = e.target.data.replace(/\r/g,"");
        }
    }
}
            
        }
    }
}