/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Jjt
 */

/*
 * obanettyさんの“直線や線分の交点を計算する”
 * http://wonderfl.net/code/f9751de2db14811654827f951714c5a2d6926b67
 * を見て計算式が理解できなかったので
 *
 * 直線と線分に必要なデータと交点の求め方
 * 線分のあらわし方 : 両端の指定とパラメータ表記
 * http://www.h4.dion.ne.jp/~zero1341/t/03.htm
 * を参考に“理解しようと試みた”描画テスト
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        		var line1:Line = new Line(100,150,400,250,0x0000ff);
        		addChild(line1);
        		
        		var line2:Line = new Line(300,100,100,250,0x00ff00);
        		addChild(line2);

        		getCrossPoint(line1,line2);
        }
        
        // ２本の直線の交点を計算して画面に描画
        public function getCrossPoint(lineA:Line, lineB:Line):void {
	        	// det == 0 は平行
	        	var det:Number = lineB.f*lineA.g - lineA.f*lineB.g;
	        	if (det != 0) {
				var dx:Number = lineB.p1.x - lineA.p1.x;
				var dy:Number = lineB.p1.y - lineA.p1.y;
				var t1:Number = (lineB.f*dy - lineB.g*dx)/det;
				var t2:Number = (lineA.f*dy - lineA.g*dx)/det;
				// t1, t2の値が0～1の範囲外の場合、交点は延長線上に存在する
				if (Math.abs(t1) <= 1 && Math.abs(t2) <= 1) {
					var px:Number = lineA.p1.x + lineA.f*t1;
					var py:Number = lineA.p1.y + lineA.g*t1;
					graphics.lineStyle(0,0xff0000);
					graphics.drawCircle(px,py,5);
				}
	        	}
		}
    }
}
import flash.display.Sprite;
import flash.geom.Point;
class Line extends Sprite {
	public var p1:Point;
	public var p2:Point;
	public var f:Number;
	public var g:Number;
	public var color:uint;
	public function Line(x1:Number=0, y1:Number=0, x2:Number=0, y2:Number=0, c:uint=0):void {
		p1 = new Point(x1, y1);
		p2 = new Point(x2, y2);
		color = c;
		f = p2.x - p1.x;
		g = p2.y - p1.y;
		xDraw();
	}
    public function xDraw():void {
		graphics.lineStyle(1,color);
		graphics.moveTo(p1.x, p1.y);
		graphics.lineTo(p2.x, p2.y);
	}
}