/**
 * Copyright inspirit ( http://wonderfl.net/user/inspirit )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5JFK
 */

// forked from Fumio's Getting the max value in an Array
package {
    import flash.display.Sprite;
    import flash.utils.getTimer;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    [SWF(width = "240",height = "180")]
    public class Max_in_Array extends Sprite {
        private const MAX_NUMBER:uint = 100000;
        private const nCount:uint = 100;
        private var source_array:Array = createArray(nCount);
        private var source_vector:Vector.<int> = createVector(nCount);
        private var testArrays:Vector.<Array >  = new Vector.<Array > (MAX_NUMBER,true);
        private var testVectors:Vector.<Vector.<int> >  = new Vector.<Vector.<int>> (MAX_NUMBER,true);
        private var my_txt:TextField = new TextField  ;
        private var label_txt:TextField = new TextField  ;
        private var my_fmt:TextFormat = new TextFormat  ;
        public function Max_in_Array() {
            // Creating a TextField for display
            createTextField();
            setArrays();
            setVector();
            // Starting Test
            use_Array_sort();
            use_Array_sort2();
            use_condition();
            use_condition2();
            use_Function_apply();
            
            use_conditionVector();
            use_conditionVector2();
        }
        private function use_Array_sort():void {
            var started:int = getTimer();
            for (var i:uint = 0; i < MAX_NUMBER; i++) {
                var my_array:Array = testArrays[i].concat();
                my_array.sort(Array.NUMERIC);
                var nMax:int = my_array[int(my_array.length - 1)];
            }
            xTrace("Array.sort()",getTimer() - started);
        }
        private function use_Array_sort2():void {
            var started:int = getTimer();
            for (var i:uint = 0; i < MAX_NUMBER; i++) {
                var my_array:Array = testArrays[i].concat();
                my_array.sort(Array.NUMERIC | Array.DESCENDING);
                var nMax:int = my_array[0];
            }
            xTrace("Array.sort() (decending)",getTimer() - started);
        }
        private function use_condition():void {
            var started:int = getTimer();
            for (var i:int = 0; i < MAX_NUMBER; ++i) {
                var my_array:Array = testArrays[i];
                var nLength:int = my_array.length;
                var nMax:int = my_array[0];
                for (var j:int = 1; j < nLength; ++j) {
                    var n:int = my_array[j];
                    if ((n > nMax)) {
                        nMax = n;
                    }
                }
            }
            xTrace("if condition",getTimer() - started);
        }
        private function use_Function_apply():void {
            var started:int = getTimer();
            var math:Function = Math.max.apply;
            for (var i:uint = 0; i < MAX_NUMBER; ++i) {
                var my_array:Array = testArrays[i];
                var nMax:int = math(null, my_array);
            }
            xTrace("Function.apply()",getTimer() - started);
        }
        
        private function use_condition2():void {
            var started:int = getTimer();
            for (var i:int = 0; i < MAX_NUMBER; ++i) {
                var my_array:Array = testArrays[i];
                var nLength:int = my_array.length;
                var nMax:int = my_array[0];
                for (var j:int = 1; j < nLength; ++j) {
                    var n:int = my_array[j];
                    var t:int = int(n > nMax);
                    n = n*t;
                    t = 1-t;
                    nMax = t * nMax;
                    nMax = nMax + n;
                }
            }
            xTrace("if condition2",getTimer() - started);
        }
        
        private function use_conditionVector():void {
            var started:int = getTimer();
            var nn:int = MAX_NUMBER;
            for (var i:int = 0; i < nn; ++i) {
                var my_array:Vector.<int> = testVectors[i];
                var nLength:int = my_array.length;
                var nMax:int = my_array[0];
                for (var j:int = 1; j < nLength; ++j) {
                    var n:int = my_array[j];
                    if(n > nMax)
                    {
                        nMax = n;
                    }
                }
            }
            xTrace("if condition Vector",getTimer() - started);
        }
        
        private function use_conditionVector2():void {
            var started:int = getTimer();
            var nn:int = MAX_NUMBER;
            for (var i:int = 0; i < nn; ++i) {
                var my_array:Vector.<int> = testVectors[i];
                var nLength:int = my_array.length;
                var nMax:int = my_array[0];
                for (var j:int = 1; j < nLength; ++j) {
                    var n:int = my_array[j];
                    var t:int = int(n > nMax);
                    n = n*t;
                    t = 1-t;
                    nMax = t * nMax;
                    nMax = nMax + n;
                }
            }
            xTrace("if condition Vector2",getTimer() - started);
        }
        
        private function setArrays():void {
            for (var i:uint = 0; i < MAX_NUMBER; i++) {
                var my_array:Array = source_array.concat();
                shuffleArray(my_array);
                testArrays[i] = my_array;
            }
        }
        private function createArray(n:uint):Array {
            var my_array:Array = [];
            for (var i:uint = 0; i < n; i++) {
                my_array[i] = i;
            }
            return my_array;
        }
        private function createVector(n:uint):Vector.<int> 
        {
            var my_array:Vector.<int> = new Vector.<int>(n, true);
            for (var i:int = 0; i < n; ++i) 
            {
                my_array[i] = i;
            }
            return my_array;
        }
        private function setVector():void
        {
            for (var i:uint = 0; i < MAX_NUMBER; i++) {
                var my_array:Vector.<int> = source_vector.concat();
                shuffleVector(my_array);
                testVectors[i] = my_array;
            }
        }
        private function shuffleArray(my_array:Array):void {
            var i:uint = my_array.length;
            while (i) {
                var nRandom:int = Math.floor(Math.random() * i--);
                var temp:Object = my_array[i];
                my_array[i] = my_array[nRandom];
                my_array[nRandom] = temp;
            }
        }
        private function shuffleVector(my_array:Vector.<int>):void {
            var i:uint = my_array.length;
            while (i) {
                var nRandom:int = Math.floor(Math.random() * i--);
                var temp:int = my_array[i];
                my_array[i] = my_array[nRandom];
                my_array[nRandom] = temp;
            }
        }
        private function createTextField():void {
            addChild(my_txt);
            addChild(label_txt);
            my_fmt.align = TextFormatAlign.RIGHT;
            my_txt.x +=  50;
            my_txt.defaultTextFormat = my_fmt;
            my_txt.autoSize = TextFieldAutoSize.RIGHT;
            label_txt.autoSize = TextFieldAutoSize.LEFT;
        }
        private function xTrace(_str:String,n:int):void {
            my_txt.appendText((String(n) + "\n"));
            label_txt.appendText(((_str + ":") + "\n"));
        }
    }
}