/**
 * Copyright entermeister ( http://wonderfl.net/user/entermeister )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5IyA
 */

////////////////////////////////////////////////////////////////////////////////
//
//  バウンドするキューブ
//
//  某プラグインのインストール確認用のサンプルを
//  Papervision3D + BetweenAS3 で再現したもの。
//
////////////////////////////////////////////////////////////////////////////////

package
{
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Sine;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.tweens.ITweenGroup;
	import org.papervision3d.core.effects.view.ReflectionView;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	
	[SWF(backgroundColor = 0xe6e6e6)]
	
	/**
	 * バウンドするキューブ
	 */
	public class BouncingCube extends ReflectionView
	{
		//--------------------------------------------------------------------------
		//
		//  コンストラクタ
		//
		//--------------------------------------------------------------------------
		
		/**
		 * コンストラクタ
		 */
		public function BouncingCube()
		{
			// superクラスのコンストラクタ
			super(0, 0, true, true, "Target");
			
			// キューブのセットアップ
			var cubeWrapper:DisplayObject3D = setUpCube();
			
			// シーンに追加する。
			scene.addChild(cubeWrapper);
			
			// トゥイーンの生成
			createTweens(cubeWrapper);
			
			// カメラの位置
			camera.x = 0;
			camera.y = 0;
			camera.z = 1200;
			
			// 反射の設定
			viewportReflection.alpha = 0.2;
			
			// キャプチャ用
			Wonderfl.capture_delay(1); 
			graphics.beginFill(0xe6e6e6);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			// フレーム更新のイベントハンドラ
			// そこでレンダリングする。
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		//--------------------------------------------------------------------------
		//
		//  メソッド
		//
		//--------------------------------------------------------------------------
		
		/**
		 * キューブをセットアップします。
		 * 
		 * @return	セットアップされたキューブを含むDisplayObject3Dです。
		 */
		private function setUpCube():DisplayObject3D
		{
			// ライトの設定
			var light:PointLight3D = new PointLight3D(true);
			light.y = 400;
			light.z = 400;
			
			// マテリアルの設定
			// 白いキューブをフラットシェーディングする。
			var material:MaterialObject3D = new FlatShadeMaterial(light, 0xffffff, 0x666666);
			material.interactive = true;
			var materialList:MaterialsList = new MaterialsList( { all:material } );
			
			// cubeを生成する。
			// cubeの中心とその外側でそれぞれ階層を持つ。
			var wrapper:DisplayObject3D = new DisplayObject3D();
			var center:DisplayObject3D = new DisplayObject3D();
			var body:Cube = new Cube(materialList, 200, 200, 200);
			wrapper.addChild(center, "center");
			center.addChild(body, "body");
			
			// 伸縮がやりやすいようにキューブの中心を底面に移動する。
			body.y = 100;
			
			// キューブの色
			body.useOwnContainer = true;
			body.filters = [new ColorMatrixFilter([1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0])];
			
			return wrapper;
		}
		
		/**
		 * トゥイーンを生成します。
		 * 
		 * @param	wrapper キューブの外側の階層です。内部に中心と実体を持ちます。
		 */
		private function createTweens(wrapper:DisplayObject3D):void
		{
			// キューブの中心
			var center:DisplayObject3D = wrapper.getChildByName("center");
			
			// バウンド
			// 1秒で「伸びる→上昇→下降→縮む」をサイクルする。
			var expand:ITween = BetweenAS3.tween
			(
				center,
				{ scaleY: 1 },
				{ scaleY: 0.8 },
				0.1,
				Sine.easeIn
			)
			var jump:ITween = BetweenAS3.tween
			(
				center,
				{ y: 200 },
				{ y: 0 },
				0.4,
				Sine.easeOut
			)
			var bound:ITweenGroup = BetweenAS3.serial
			(
				expand, // 伸びる
				jump, // 上昇
				BetweenAS3.reverse(jump), // 下降
				BetweenAS3.reverse(expand) // 縮む
			);
			bound.stopOnComplete = false;
			
			// 往復運動
			// 2秒で往復する。
			var oneWay:ITween = BetweenAS3.tween
			(
				center,
				{ x: 150, z: -150 },
				{ x: -150, z: 150 },
				0.9
			);
			// 前後0.05秒は伸縮運動のため移動しない。
			oneWay = BetweenAS3.delay(oneWay, 0.05, 0.05);
			var roundTrip:ITweenGroup = BetweenAS3.serial
			(
				oneWay, // 往路
				BetweenAS3.reverse(oneWay) // 復路
			)
			roundTrip.stopOnComplete = false;
			
			// 回転運動
			// y軸を中心に回転しつづける。
			var rotation:ITween = BetweenAS3.tween
			(
				wrapper,
				{ rotationY: -360 },
				{ rotationY: 0 },
				15
			);
			rotation.stopOnComplete = false;
			
			// キューブ本体
			var body:DisplayObject3D = center.getChildByName("body");
			
			// 変色
			// 赤→黄色→緑→シアン→青→マジェンタ→赤→……
			var red:ITween = BetweenAS3.tween
			(
				body.filters[0],
				{ matrix: [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0] },
				{ matrix: [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0] },
				2.5
			);
			var yellow:ITween = BetweenAS3.tween
			(
				body.filters[0],
				{ matrix: [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0] },
				{ matrix: [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0] },
				2.5
			);
			var green:ITween = BetweenAS3.tween
			(
				body.filters[0],
				{ matrix: [0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0] },
				{ matrix: [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0] },
				2.5
			);
			var cyan:ITween = BetweenAS3.tween
			(
				body.filters[0],
				{ matrix: [0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0] },
				{ matrix: [0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0] },
				2.5
			);
			var blue:ITween = BetweenAS3.tween
			(
				body.filters[0],
				{ matrix: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0] },
				{ matrix: [0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0] },
				2.5
			);
			var magenta:ITween = BetweenAS3.tween
			(
				body.filters[0],
				{ matrix: [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0] },
				{ matrix: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0] },
				2.5
			);
			var multipleColor:ITweenGroup = BetweenAS3.serial
			(
				red,
				yellow,
				green,
				cyan,
				blue,
				magenta
			);
			multipleColor.stopOnComplete = false;
			
			// 再生する。
			bound.play();
			roundTrip.play();
			rotation.play();
			multipleColor.play();
		}
		
		//--------------------------------------------------------------------------
		//
		//  イベントハンドラ
		//
		//--------------------------------------------------------------------------
		
		/**
		 * フレーム更新ごとに呼ばれます。
		 * 
		 * @param	event イベントオブジェクトです。
		 */
		private function enterFrameHandler(event:Event):void 
		{
			// レンダリング
			singleRender();
		}
	}	

}