/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Iuo
 */

// forked from tepe's flash on 2011-3-19
package {
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.ui.*;
    import net.hires.debug.Stats;
    //[SWF(backgroundColor=0, width=465, height=465)]
    //[SWF(backgroundColor="#005500", width="465", height="465", frameRate="60")]
    public class FlashTest extends Sprite {//==================================
        private var node1:node = new node();
        private var text1:TextField = new TextField();
        
        private var bitmap:Bitmap;
        private var bitmapData:BitmapData;
        private var canvas:Sprite;
        private var seed:uint;
        private var px:Number = 0;
        private var py:Number = 0;
        private var clearBtn:Btn;
        private var whiteBtn:Btn;
        private var pinkBtn:Btn;
        private var greenBtn:Btn;
        private var blueBtn:Btn;
        private var fill:BitmapData;
        private var color:ColorTransform;        
        
        public function FlashTest() {//----------------------------------------
            bitmapData = new BitmapData(465, 435, true, 0x00000000);
            bitmap = new Bitmap(bitmapData);
            node1.map.addChild(bitmap);
            bitmap.blendMode = BlendMode.ADD;
            canvas = new Sprite();
            node1.map.addChild(canvas);
            seed = uint(Math.random()*10000);
            fill = new BitmapData(465, 435);
            fill.perlinNoise(3, 3, 1, seed, false, true, 8, true);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true); 
                        

            addChild(node1);
            text1.selectable = false;
            text1.height = 20;
            text1.width = 20;
            text1.textColor = 0xff00ff;
            //text1.border = true;
            addChild(text1);
            //stage.showDefaultContextMenu=false;
            stage.addEventListener(MouseEvent.CLICK,screenMode2);
            addEventListener(Event.ENTER_FRAME,function():void{
                
                text1.text = String(node1.scaleSize);
            });
            
            var menu:ActionMenu = new ActionMenu();
                menu.x = -135 ;
                menu.y = 20;
                stage.addChild(menu);
                menu.init({id: 1, label: "Esc" , width: 60});
                menu.addEventListener(MouseEvent.CLICK, screenMode3);
                menu.alpha = 0.7;
                

            //FPS計測    
            //addChild( new Stats() );
            //Wonderfl.capture(stage);
           
        
        }
        private function drawSt():void{
            stage.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            Mouse.hide();
        }
        private function drawEnd():void{
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            Mouse.show();
        }


        
        private function screenMode3(e:MouseEvent):void{//-----------------------------
            if(stage.displayState != StageDisplayState.NORMAL)stage.displayState = StageDisplayState.NORMAL;
            e.stopPropagation();//イベントの伝播を止める  
        }
        
        private function screenMode2(e:MouseEvent):void{//-----------------------------
            if(stage.displayState == StageDisplayState.NORMAL)stage.displayState = StageDisplayState.FULL_SCREEN;
        }
        
                
        
        private function press(evt:Event):void {
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            stage.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            px = node1.map.mouseX;
            py = node1.map.mouseY;
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        
        private function release(evt:Event):void {
            stage.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            removeEventListener(Event.ENTER_FRAME, update);
            //canvas.graphics.clear();
        }
        
        private function update(evt:Event):void {
            var tx:Number = node1.map.mouseX;
            var ty:Number = node1.map.mouseY;
            //canvas.graphics.clear();
            canvas.graphics.lineStyle(8,0x000000);
            //canvas.graphics.lineBitmapStyle(fill);
            //canvas.graphics.beginFill(0x000000);
            canvas.graphics.moveTo(px, py);
            canvas.graphics.lineTo(tx, ty);
            px = tx;
            py = ty;
            //canvas.graphics.endFill();
            /*bitmapData.lock();
            bitmapData.draw(canvas, null, color);
            bitmapData.draw(canvas, null, color);
            bitmapData.unlock();
            */
        }

    }
}




//------------------------------------------------------------------------------

import flash.geom.Point;
import caurina.transitions.Tweener;
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.ui.*;
import flash.utils.*;

class node extends Sprite{//======================================================
        
        private var scale:Number = 1;
        
        public var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        public var map:Sprite;//フィールド
        
        private var mapFocusX:Number=0;
        private var mapFocusY:Number=0;
        private var scrFocusX:int=0; 
        private var scrFocusY:int=0; 
        
        private var scalingPanel:Sprite;
        private var base:Sprite;
              
        private var mapscale:int=0;
        
        private var dragPanel:Sprite = new Sprite();
        
        //ozmap状態フラグ
        private const testMode:Boolean = false;//テスト表示

        private var mapBrowseMode:Boolean;//マップ移動操作
        private var mapDragMode:Boolean;//マップドラッグ中はtrue
        private var mapRotationMode:Boolean;//マップ回転操作
        
        private var endZoomOut:int = 15; 
        private var endZoomIn:int = -7;
        
        //コンストラクタ 
        public function node():void{//-----------------------------
            
            //カーソル位置描画
            //scalingPanel ズーム中心
            scalingPanel = new Sprite();//ズーム中心
            if(testMode == true){ 
                var t1:TextField = new TextField();
                t1.textColor = 0x00ff00;
                t1.selectable = false;
                t1.y = -20;
                t1.text = "scalingPanel";
                scalingPanel.addChild(t1);
                scalingPanel.graphics.lineStyle(1,0x00ff00,0.3);
                scalingPanel.graphics.moveTo(-100,0);
                scalingPanel.graphics.lineTo(100,0);
                scalingPanel.graphics.moveTo(0,-100);
                scalingPanel.graphics.lineTo(0,100);
            }
            addChild(scalingPanel);
            
            
            //マップ基準座標
            base = new Sprite();
            if(testMode == true){
                var t2:TextField = new TextField();
                t2.textColor = 0xff0000;
                t2.selectable = false;
                t2.y = -20;
                t2.text = "base";
                base.addChild(t2);
                base.graphics.lineStyle(1,0xff0000,0.3);
                base.graphics.moveTo(-100,0);
                base.graphics.lineTo(100,0);
                base.graphics.moveTo(0,-100);
                base.graphics.lineTo(0,100);
            }            
            scalingPanel.addChild(base);
            
            //マップ上への配置
            map = new Sprite();
            
            if(testMode == true){
                var t3:TextField = new TextField();
                t3.textColor = 0x0000ff;
                t3.selectable = false;
                t3.y = -20;
                t3.text = "map 0,0";
                map.addChild(t3);
                map.graphics.lineStyle(1,0x0000ff,0.3);
                map.graphics.moveTo(-100,0);
                map.graphics.lineTo(100,0);
                map.graphics.moveTo(0,-100);
                map.graphics.lineTo(0,100);
            } 
            
            browseOn();
 
            base.addChildAt(map,0); 
            map.addChild(dragPanel);
            if(testMode == true){
 
                var t4:TextField = new TextField();
                t4.textColor = 0x0000ff;
                t4.selectable = false;
                t4.y = -40;
                t4.text = "dragPanel 0,0";
                dragPanel.addChild(t4);
            }

            
            dragPanel.doubleClickEnabled = true;
            
            
            
            update();
        }
        
        public function get scaleSize():int{//-----------------------------
            return mapscale;
        }
        
        //マップ移動操作状態
        public function get IsBrowseMode():Boolean{//-----------------------------
            return mapBrowseMode;
        }
        //マップドラッグスクロール状態
        public function get IsDragMode():Boolean{//-----------------------------
            return mapDragMode;
        }        
        //マップ回転操作状態
        public function get IsRotationMode():Boolean{//-----------------------------
            return mapRotationMode;
        }

        //
        public function returnHome():void{//-----------------------------
            map.x = 0;
            map.y = 0;
            map.scaleX = map.scaleY = 1.0;
            mapscale = 0;
            update();
            
        }

        
        
        //画面移動操作の受付　ON・OFF切り替え
        public function browseOn():void{//-----------------------------
            mapBrowseMode = true;
            //Mouse.hide();
            map.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.addEventListener(MouseEvent.MOUSE_UP,up1);
            dragPanel.addEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.addChild(dragPanel);
        }
        
        
        public function browseOff():void{//-----------------------------
            wheel = 0;
            mapBrowseMode = false;
            //Mouse.show();
            map.removeEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.removeEventListener(MouseEvent.MOUSE_UP,up1);
            dragPanel.removeEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.removeEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.removeChild(dragPanel);
        }
        
       

        
        //ダブルクリックでマップブラウズモード解除　⇒　オブジェクト操作モードに移行
        private function onDouble(e:MouseEvent):void{//-----------------------------
            browseOff();
            //ホイール操作でブラウズモードに移行
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,function():void{
                browseOn();
            });
        }


  
        //マップドラッグ
        private function down1(e:MouseEvent):void{//-----------------------------
            wheel=0;//ズーム操作ストップ
            
      　    e.currentTarget.startDrag();
      　    addEventListener(MouseEvent.MOUSE_MOVE,onMove);
      　    stage.removeEventListener(Event.ENTER_FRAME,onFrame);
      　    e.stopPropagation();//イベントの伝播を止める
      　    
        }
        private function up1(event:MouseEvent):void{//-----------------------------
            event.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            event.stopPropagation();//イベントの伝播を止める
        }
        
        //マップドラッグ中
        private function onMove(e:MouseEvent):void{//-----------------------------
            update();
        }
    
        //ホイール操作
        private function on_wheel(event:MouseEvent):void{//-----------------------------
            wheel += event.delta;
            if(wheel != 0)addEventListener(Event.ENTER_FRAME,onFrame);
            //else removeEventListener(Event.ENTER_FRAME,onFrame);
        }
  
        private function onFrame(e:Event):void {//-----------------------------
            if(wheel==0)removeEventListener(Event.ENTER_FRAME,onFrame);
            
            on_zoom(1+(0.005*wheel));
        }
        
        
        //マップ表示位置を更新
        private function update(z:Number=1, x:Number=0, y:Number=0, a:Number=0):void{//-----------------------------
            var mX:int,mY:int;
            if(1<=z){//ズームイン
                mX = mouseX;
                mY = mouseY;//カーソル位置    
            }
            else{//ズームアウト
                mX = this.root.loaderInfo.width/2;
                mY = this.root.loaderInfo.height/2;//カーソル位置
            }
            
            //ズーム中心
            scalingPanel.x = mX;
            scalingPanel.y = mY; 
            //マップ位置
            base.x -= (mX-scrFocusX)/zoom;
            base.y -= (mY-scrFocusY)/zoom;
            //フォーカス位置
            scrFocusX = mX;
            scrFocusY = mY;
            

            //フィールドドラッグ用
            dragPanel.graphics.clear();
            dragPanel.graphics.beginFill(0xffffff,0.3);
            dragPanel.graphics.drawCircle(-(map.x+map.parent.x)/map.scaleX,-(map.y+map.parent.y)/map.scaleY,600/map.scaleX);
            dragPanel.graphics.endFill();
            

      
        }

        
        
        private function on_zoom(z:Number=0):void{//-----------------------------
            if(z==0)return;
            update(z);//基準点更新
            if(z>1 && endZoomIn > mapscale){
                wheel = 0;
            }
            else if(z<1 && endZoomOut < mapscale){
                wheel = 0;
            }
            else zoom *= z;    
                
            if(2 < zoom){

                map.scaleX *= 2;
                map.scaleY *= 2;
                zoom /= 2;
                map.x += map.x+base.x;
                map.y += map.y+base.y;
                    
                mapscale--;
                
            }
            else if(zoom < 1.0){
             
                map.x -= (map.x+base.x)/2;
                map.y -= (map.y+base.y)/2;
                zoom *= 2;
                map.scaleX /= 2;
                map.scaleY /= 2;
                    
                mapscale++;
                    
            }    
            scalingPanel.scaleX = zoom;
            scalingPanel.scaleY = zoom;        
          
        }
        
    }
 
 
 

//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {//============================
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// ActionMenuクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class ActionMenu extends Sprite {//=============================
    public var id:uint;
    private var shade:Shape;
    private var base:Shape;
    private var front:Shape;
    private var light:Shape;
    private var reflection:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 32;
    private static var corner:uint = 6;
    private static var tHeight:uint = 17;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var baseColor:uint = 0x0066CC;
    private var lightColor:uint = 0x00FFFF;
    private var overColor:uint = 0x3333FF;
    private static var tColor:uint = 0xFFFFFF;
    private var defaultColorTrans:ColorTransform;
    private static var disableColor:uint = 0xCCCCCC;
    private static var disableColorTrans:ColorTransform;
    private var mode:int;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function ActionMenu() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        draw();
    }
    public function colorize(color:uint, list:Array):void {
        var bTrans:ColorTransform = new ColorTransform();
        bTrans.color = color;
        defaultColorTrans = bTrans;
        base.transform.colorTransform = bTrans;
        front.transform.colorTransform = bTrans;
        lightColor = list[0];
        overColor = list[0];
        createLight(light, _width-2, _height-2, corner);
    }
    private function draw():void {
        defaultColorTrans = new ColorTransform();
        disableColorTrans = new ColorTransform();
        disableColorTrans.color = disableColor;
        shade = new Shape();
        base = new Shape();
        front = new Shape();
        light = new Shape();
        reflection = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(base);
        addChild(front);
        addChild(light);
        addChild(reflection);
        addChild(txt);
        createBase(shade, _width, _height, corner, bColor);
        shade.filters = [new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false)];
        createBase(base, _width-2, _height-2, corner, baseColor);
        createFront(front, _width, _height, corner);
        createLight(light, _width-2, _height-2, corner);
        createReflection(reflection, _width-2, _height-2, corner);
        txt.x = -_width/2;
        txt.y = -tHeight + _height/4;
        txt.width = _width;
        txt.height = tHeight;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        txt.text = label;
        txt.filters = [new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 2, 3, false, false)];
        light.alpha = 0;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        mode = 1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function rollOut(evt:MouseEvent = null):void {
        mode = -1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function action(evt:Event):void {
        light.alpha += 0.1*mode;
        if (light.alpha < 0) {
            light.alpha = 0;
            removeEventListener(Event.ENTER_FRAME, action);
        }
        if (light.alpha > 1) {
            light.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, action);
        }
    }
    private function _up():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
        light.alpha = 1;
    }
    private function _disable():void {
        base.transform.colorTransform = disableColorTrans;
        front.transform.colorTransform = disableColorTrans;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            _down();
        } else {
            _up();
            rollOut();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        } else {
            _disable();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createFront(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = [baseColor, baseColor];
        var alphas:Array = [0, 0.5];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w/2, -h/2);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createLight(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.clear();
        var colors:Array = [lightColor, overColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [40, 160];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*2, h*3, 0, -w, -h*0.9);
        target.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createReflection(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor, 0.3);
        target.graphics.drawEllipse(-w*1.125, -h*4.375, w*2.25, h*4.375);
        target.graphics.endFill();
        var _mask:Shape = new Shape();
        _mask.graphics.beginFill(sColor);
        _mask.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        _mask.graphics.endFill();
        addChild(_mask);
        target.mask = _mask;
    }

}
//---------------------------------------------------------


// forked from saharan's forked from: チョーク (こくばんin風)
// forked from ProjectNya's チョーク (4)
////////////////////////////////////////////////////////////////////////////////
// チョーク (4)
////////////////////////////////////////////////////////////////////////////////

    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.display.BlendMode;


    class Main extends Sprite {
        private var bitmap:Bitmap;
        private var bitmapData:BitmapData;
        private var canvas:Sprite;
        private var seed:uint;
        private var px:Number = 0;
        private var py:Number = 0;
        private var clearBtn:Btn;
        private var whiteBtn:Btn;
        private var pinkBtn:Btn;
        private var greenBtn:Btn;
        private var blueBtn:Btn;
        private var fill:BitmapData;
        private var color:ColorTransform;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x005500);
            graphics.drawRect(0, 0, 465, 435);
            graphics.endFill();
            graphics.beginFill(0x996633);
            graphics.drawRect(0, 435, 465, 30);
            graphics.endFill();
            color = new ColorTransform(1, 1, 1, 1);
            //
            clearBtn = new Btn();
            addChild(clearBtn);
            clearBtn.x = 420;
            clearBtn.y = 450;
            clearBtn.init({label: "clear"});
            clearBtn.addEventListener(MouseEvent.CLICK, clear, false, 0, true);
            //
            whiteBtn = new Btn();
            addChild(whiteBtn);
            whiteBtn.x = 40;
            whiteBtn.y = 450;
            whiteBtn.init({label: "white"});
            whiteBtn.addEventListener(MouseEvent.CLICK, white, false, 0, true);
            //
            pinkBtn = new Btn();
            addChild(pinkBtn);
            pinkBtn.x = 120;
            pinkBtn.y = 450;
            pinkBtn.init({label: "pink"});
            pinkBtn.addEventListener(MouseEvent.CLICK, pink, false, 0, true);
            //
            greenBtn = new Btn();
            addChild(greenBtn);
            greenBtn.x = 200;
            greenBtn.y = 450;
            greenBtn.init({label: "green"});
            greenBtn.addEventListener(MouseEvent.CLICK, green, false, 0, true);
            //
            blueBtn = new Btn();
            addChild(blueBtn);
            blueBtn.x = 280;
            blueBtn.y = 450;
            blueBtn.init({label: "blue"});
            blueBtn.addEventListener(MouseEvent.CLICK, blue, false, 0, true);
            //
            bitmapData = new BitmapData(465, 435, true, 0x00000000);
            bitmap = new Bitmap(bitmapData);
            addChild(bitmap);
            bitmap.blendMode = BlendMode.ADD;
            canvas = new Sprite();
            seed = uint(Math.random()*10000);
            fill = new BitmapData(465, 435);
            fill.perlinNoise(3, 3, 1, seed, false, true, 8, true);
            //
            stage.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        }
        
        private function press(evt:Event):void {
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            stage.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            px = stage.mouseX;
            py = stage.mouseY;
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        
        private function release(evt:Event):void {
            stage.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            removeEventListener(Event.ENTER_FRAME, update);
            canvas.graphics.clear();
        }
        
        private function update(evt:Event):void {
            var tx:Number = stage.mouseX;
            var ty:Number = stage.mouseY;
            canvas.graphics.clear();
            canvas.graphics.lineStyle(8);
            canvas.graphics.lineBitmapStyle(fill);
            canvas.graphics.moveTo(px, py);
            canvas.graphics.lineTo(tx, ty);
            px = tx;
            py = ty;
            bitmapData.lock();
            bitmapData.draw(canvas, null, color);
            bitmapData.draw(canvas, null, color);
            bitmapData.unlock();
        }

        private function clear(evt:MouseEvent):void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0x00000000);
            bitmapData.unlock();
        }

        private function white(evt:MouseEvent):void {
            color = new ColorTransform(0.9, 0.9, 0.9, 1);
        }

        private function pink(evt:MouseEvent):void {
            color = new ColorTransform(1, 0.5, 0.7, 1);
        }

        private function green(evt:MouseEvent):void {
            color = new ColorTransform(0.5, 1, 0.5, 1);
        }

        private function blue(evt:MouseEvent):void {
            color = new ColorTransform(0.5, 0.5, 1, 1);
        }
        
    }




//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}



    
    
    

