/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5IWQ
 */

/*
 * Picasa Web Albums Data API
 * http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
 * 参考
 * http://wonderfl.net/code/95d18286b23549ece13d4933dffd64a6cf550386
 * 
*/
package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.filters.DropShadowFilter;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import com.adobe.serialization.json.JSONDecoder;
	public class Main extends Sprite{
		public function Main() {
			//クロスドメインポリシーファイルの位置を指定
			Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
			//検索結果のロード
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onComplete);
			var URLstr:String = "http://photos.googleapis.com/data/feed/base/all?alt=json&kind=photo&q=waterdrop&imglic=commercial&max-results=3&imgmax=288";
			myURLLoader.load(new URLRequest(URLstr));
		}
		
		private function onComplete(e:Event):void {
			//取得したデータをJSON型にする
			var decoder:JSONDecoder = new JSONDecoder(e.currentTarget.data);
			var json:Object = decoder.getValue();
			
			//背景のグレーの文字。JSONの文字列を流し込んでいる。
			var tf:TextField = new TextField();
			tf.text = e.currentTarget.data;
			tf.textColor = 0xCCCCCC;
			tf.wordWrap = true;
			tf.width = tf.height = 465;
			addChild(tf);
			
			//JSONをパース
			var titleStr:String = json.feed.entry[0].title.$t;
			var linkURL:String = json.feed.entry[0].link[1].href;
			var creditStr:String = json.feed.entry[0]["media$group"].media$credit[0].$t;
			var imgURL:String = json.feed.entry[0].media$group.media$content[0].url;
			
			//タイトル、クレジット、リンクのテキストを入れて、ドロップシャドウをかける
			var htmldata:String = "Title:" + titleStr + "<br>";
			htmldata += "Credit:" + creditStr + "<br>";
			htmldata += "<a href='" + linkURL + "'>" + linkURL + "</a>";
			var fld:TextField = new TextField();
			fld.autoSize = TextFieldAutoSize.LEFT;
			fld.width = 300;
			fld.x = 50;
			fld.y = 50;
			fld.multiline = true;
			fld.htmlText = htmldata;
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			fld.filters = [dsf];
			addChild(fld);
            
			//画像のロード
			var myLoader:Loader = new Loader();
			var myURLRequest:URLRequest = new URLRequest(imgURL);
			//クロスドメインポリシーファイルをドキュメントルートから取得
			var myLoaderContext:LoaderContext = new LoaderContext(true);
			myLoader.load(myURLRequest, myLoaderContext);
			myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteImg);
		}
		
		private function onCompleteImg(e:Event):void {
			//読み込んだ画像をBitmapData化し、SpriteにbeginBitmapFillで転写しています。
			//この操作を複数ドメイン上で行うにはクロスドメインポリシーファイルによる
			//許可が必要です。
			var myBitmap:Bitmap = e.target.content;
			var myBitmapData:BitmapData = new BitmapData(myBitmap.width, myBitmap.height);
			myBitmapData.draw(myBitmap);
			var mySprite:Sprite = new Sprite();
			mySprite.graphics.beginBitmapFill(myBitmapData);
			mySprite.graphics.drawRoundRect(0, 0, myBitmap.width, myBitmap.height, 50, 50);
			mySprite.x = 50;
			mySprite.y = 100;
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			mySprite.filters = [dsf];
			addChild(mySprite);
		}
	}
}
