/**
 * Copyright Nao_u ( http://wonderfl.net/user/Nao_u )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5IRt
 */

//   
// テクスチャ生成実験
//
// 制御点をドラッグで移動
//
package {      
    import flash.display.Sprite;      
    import flash.events.*;      
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="15")] 
         
    public class FlashTest extends Sprite {      
        public function FlashTest() {      
            Main = this;      
            initialize();      
            stage.addEventListener(Event.ENTER_FRAME,update);       
        }      
    }      
}          
    
import flash.display.Sprite;       
import flash.events.* 
import flash.text.TextField;      
import flash.geom.*; 
import flash.utils.getTimer; 
var Main:Sprite;      
var SCREEN_W:Number = 465; 
var SCREEN_H:Number = 465; 
var Text:TextField     
var Text2:TextField     

var Tex:ProcTex; 
var BITMAP_W:int = 128; 
var BITMAP_H:int = 128; 
var Pnt:Vector.<ControlPoint> = new Vector.<ControlPoint>; 

// 初期化
function initialize():void{      
    Tex = new ProcTex( BITMAP_W, BITMAP_H ); 
    Tex.Bmp.x = 0; 
    Tex.Bmp.y = 0; 
     
    Text = new TextField();      
    Text.text = "生成中...";    
    Text.autoSize = "left"; 
    Main.addChild(Text);       

    Text2 = new TextField();      
    Text2.text = "";    
    Text2.autoSize = "left"; 
    Text2.y = 16; 
    Main.addChild(Text2);       

    // 制御点の設置
    Pnt[0] = new ControlPoint( new Point(SCREEN_W/2-70, SCREEN_H/2+40) ); 
    Pnt[1] = new ControlPoint( new Point(SCREEN_W/2-150,   SCREEN_H/2-120) ); 
    Pnt[2] = new ControlPoint( new Point(SCREEN_W/2+0,   SCREEN_H/2-50) ); 
    Pnt[3] = new ControlPoint( new Point(SCREEN_W/2+140,   SCREEN_H/2-130) ); 
    Pnt[4] = new ControlPoint( new Point(SCREEN_W/2+100,   SCREEN_H/2+120) ); 
    Pnt[5] = new ControlPoint( new Point(SCREEN_W/2-140,   SCREEN_H/2+140) ); 
    Pnt[6] = new ControlPoint( new Point(SCREEN_W/2+10,    SCREEN_H/2+180) ); 
    Pnt[7] = new ControlPoint( new Point(SCREEN_W/2-40,    SCREEN_H/2-180) ); 
    Pnt[8] = new ControlPoint( new Point(SCREEN_W/2-140,    SCREEN_H/2-10) ); 
    Pnt[9] = new ControlPoint( new Point(SCREEN_W/2+140,    SCREEN_H/2-10) ); 

} 

// 更新
function update(e :Event):void{      
    var time:int = getTimer();  
        
    Tex.draw(); 

    var endTime:int = getTimer() - time; 
    Text.text = " 生成時間：" + endTime + "[ms]";    
}   

import flash.display.Bitmap;  
import flash.display.BitmapData;  

// テクスチャ生成クラス
class ProcTex{ 
    public var BmpData:BitmapData;  
    public var TmpBmpData:BitmapData;  
    public var Bmp:Bitmap; 
    public var Width:int; 
    public var Height:int; 

    public function ProcTex( w:int, h:int ){ 
        Width = w; 
        Height = h; 
        BmpData = new BitmapData(Width, Height, false, 0xffffff);  
        TmpBmpData = new BitmapData(Width, Height, false, 0xffffff);  
        Bmp = new Bitmap(BmpData);  
        Bmp.x = 0.0; 
        Bmp.y = 0.0; 
        Bmp.scaleX = 4; 
        Bmp.scaleY = 4; 
        Main.addChild(Bmp);       
    } 

    public function draw():void{ 
        drawBmpData( BmpData ); 
    } 

    public function getF1( pAry:Array, x:int, y:int):int{ 
       x = x % Width;
       y = y % Height;
       var num:int =pAry.length;
       var dx:int, dy:int, dist:int;
        var min:int = 99999;
        for( var i:int=0; i<num; i++ ){
            dx = x - pAry[i].x;
            dy = y - pAry[i].y;
            if( dx < 0 ) dx *= -1;
            if( dy < 0 ) dy *= -1;
            if( dx > dy ) dist = dx;
            else          dist = dy;
            if( min > dist ) min = dist;
        }
        //min = Math.sqrt(min);
        return min;
    }

import frocessing.color.ColorHSV; 
    public function drawBmpData( bmpData:BitmapData ):void{ 
      var pAry:Array = new Array();
      var num:int = Pnt.length;
      for( i=0; i<num; i++ ){
        pAry[i] = new Object;
        pAry[i].x = Pnt[i].Sp.x * 0.25;
        pAry[i].y = Pnt[i].Sp.y * 0.25;
       }

      var colTbl:Array = new Array();
      for( i=0; i<num; i++ ){
          colTbl[i] = new ColorHSV(i*36-18, 0.5, 1).value32;
      }
       var i:int, len:int, min:int, min2:int, min3:int, min4:int, dx:int, dy:int, dist:int;
       var col:int, no:int; 
        for( var x:int=0; x<Width; x++ ){  
            for( var y:int=0; y<Height; y++ ){
                min = getF1( pAry, x, y);
              //  min += getF1( pAry, x*2, y*2) / 2;
              //  min += getF1( pAry, x*4, y*4) / 4;
                col = min;
                col = col * 5 +60;
                if( col > 255 ) col = 255;
                if( col < 0 ) col = 0;
                //col = 255 - col;
                //col = col*col / 256;
                //col = col*col / 256;
                col = 255 - col;
                col = (colTbl[no]&0xff)*col/0xff +
                      ((((colTbl[no]&0xff00)>>8)*col/0xff)<<8) +
                      ((((colTbl[no]&0xff0000)>>16)*col/0xff)<<16); 

                //bmpData.setPixel(x, y, col + col*0x100 + col * 0x10000);  
                bmpData.setPixel(x, y, col);  

            } 
        }  
    } 

    public function drawBmpDataRec( bmpData:BitmapData ):void{ 
      var pAry:Array = new Array();
      var num:int = Pnt.length;
      for( i=0; i<num; i++ ){
        pAry[i] = new Object;
        pAry[i].x = Pnt[i].Sp.x * 0.25;
        pAry[i].y = Pnt[i].Sp.y * 0.25;
       }

      var colTbl:Array = new Array();
      for( i=0; i<num; i++ ){
          colTbl[i] = new ColorHSV(i*36-18, 0.5, 1).value32;
      }
       var i:int, len:int, min:int, min2:int, min3:int, min4:int, dx:int, dy:int, dist:int;
       var col:int, no:int; 
        for( var x:int=0; x<Width; x++ ){  
            for( var y:int=0; y<Height; y++ ){
                min = getF1( pAry, x, y);
                min += getF1( pAry, x*2, y*2) / 2;
                min += getF1( pAry, x*4, y*4) / 4;
                col = min;
                col = col * 8 -60;
                if( col > 255 ) col = 255;
                if( col < 0 ) col = 0;
                //col = 255 - col;
                //col = col*col / 256;
                //col = col*col / 256;
                col = 255 - col;
                col = (colTbl[no]&0xff)*col/0xff +
                      ((((colTbl[no]&0xff00)>>8)*col/0xff)<<8) +
                      ((((colTbl[no]&0xff0000)>>16)*col/0xff)<<16); 

                //bmpData.setPixel(x, y, col + col*0x100 + col * 0x10000);  
                bmpData.setPixel(x, y, col);  

            } 
        }  
    } 
}

// 制御点マーカークラス
class ControlPoint{  
    public var Sp:Sprite;  
    public var isEnable:Boolean = false; 
    public var Pos:Point; 
    public function ControlPoint( p:Point ){  
        Sp=new Sprite();    
        Pos = p;  
        Sp.x = Pos.x;  
        Sp.y = Pos.y; 
        setEnable( true ); 
        Main.stage.addChild(Sp);   

        Sp.addEventListener(MouseEvent.MOUSE_UP,   function (event:MouseEvent):void{ Sp.stopDrag(); });  
        Sp.addEventListener(MouseEvent.MOUSE_DOWN, function (event:MouseEvent):void{ if( isEnable ) Sp.startDrag(); });      
    }  

    public function setEnable( flg:Boolean ):void{     
        if( flg == true && isEnable == false ){ 
            Sp.graphics.clear(); 
            Sp.graphics.lineStyle(1.4,0x000000);        
            Sp.graphics.beginFill(0xe0d000,1);    
            Sp.graphics.drawCircle(0,0,5.0);    
            Sp.graphics.endFill();    
        }else if( flg == false && isEnable == true ){ 
            Sp.graphics.clear(); 
        } 
        isEnable = flg; 
    } 
}  

