/**
 * Copyright royi ( http://wonderfl.net/user/royi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Hw1
 */

package {
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    import com.bit101.components.*;
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]
    public class Bird extends Sprite {
        private static const SCALE:int = 5;
        private static const GRAVITY:Number = 0.1;
        private static const BACKGROUND_COLOR:uint = 0xc4e3e3;
        private static const OBSTACLE_INTERVAL:int = 60;
        private var sw:int, sh:int, w:int, h:int;
        private var canvas:BitmapData;
        private var gfx:Object = {};
        private var player:GameObject;
        private var obstacleTop:GameObject;
        private var obstacleBottom:GameObject;
        private var obstacleTop2:GameObject;
        private var obstacleBottom2:GameObject;
        private var hudScore:Label;
        private var particles:Array = [];
        private var speed:Number = 1;
        private var playerScore:int = 0;
        private var obstaclePassed:Boolean = false;
        private var paused:Boolean = false;
        private var dead:Boolean = false;
        private var obstacleInterval:int = OBSTACLE_INTERVAL;
        private var obstacleSwitch:Boolean = false;
        private var debug:TextField = new TextField();
        
        public function Bird() {
            sw = stage.stageWidth, sh = stage.stageHeight;
            w = sw / SCALE, h = sh / SCALE;
            canvas = new BitmapData(sw, sh, false, BACKGROUND_COLOR);
            var bmp:Bitmap = new Bitmap(canvas);
            bmp.scaleX = bmp.scaleY = SCALE;
            addChild(bmp);
            
            debug.autoSize = "left";
            //addChild(debug);
            //debug.text = "test";
            hudScore = new Label();
            hudScore.text = "0";
            
            // gfx player
            var bmd:BitmapData = new BitmapData(7, 7, true, 0x00000000);
            with (bmd) {
                fillRect(new Rectangle(3, 0, 2, 1), 0xff233cbd);
                fillRect(new Rectangle(2, 1, 4, 2), 0xff233cbd);
                fillRect(new Rectangle(0, 3, 6, 2), 0xff233cbd);
                fillRect(new Rectangle(1, 5, 4, 1), 0xff233cbd);
                fillRect(new Rectangle(3, 1, 2, 2), 0xffffffff);
                fillRect(new Rectangle(5, 3, 2, 1), 0xffd65c4f);
                setPixel32(3, 3, 0xff576ab1);
                setPixel32(4, 2, 0xff222222);
            }
            gfx["player"] = bmd;
            
            // gfx obstacles
            bmd = new BitmapData(16, 70, true, 0x00000000);
            with (bmd) {
                fillRect(new Rectangle(0, 0, 16, 6), 0xff3d9938);
                fillRect(new Rectangle(1, 6, 14, 64), 0xff3d9938);
                fillRect(new Rectangle(1, 1, 1, 4), 0xff83c746);
                fillRect(new Rectangle(3, 1, 3, 4), 0xff83c746);
                fillRect(new Rectangle(2, 6, 1, 64), 0xff83c746);
                fillRect(new Rectangle(4, 6, 3, 64), 0xff83c746);
                fillRect(new Rectangle(13, 1, 2, 4), 0xff32723e);
                fillRect(new Rectangle(12, 6, 2, 64), 0xff32723e);
            }
            gfx["obstacleBottom"] = bmd;
            
            var bmd2:BitmapData = new BitmapData(16, 70, true, 0x00000000);
            var matrix:Matrix = new Matrix( 1, 0, 0, -1, 0, 70);
            bmd2.draw(bmd, matrix, null, null, null, true);
            gfx["obstacleTop"] = bmd2;
            
            // game objects
            player = new GameObject("player");
            player.x = w / 6;
            player.y = h / 3;
            player.vy = -2;
            
            obstacleTop = new GameObject("obstacleTop");
            obstacleTop.x = -100;
            obstacleBottom = new GameObject("obstacleBottom");
            
            obstacleTop2 = new GameObject("obstacleTop");
            obstacleTop2.x = -100;
            obstacleBottom2 = new GameObject("obstacleBottom");
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function restart():void {
            speed = 1;
            score = 0;
            paused = false;
            player.y = h / 3;
            player.vy = -2;
            obstacleTop.x = -100;
            obstacleTop2.x = -100;
            dead = false;
            player.active = true;
        }
        
        private function gameOver():void {
            if (!dead) {
                dead = true;
                explode(player);
                player.active = false;
            }
        }
        
        private function explode(obj:Object):void {
            var width:int = gfx[obj.gfxId].width;
            var height:int = gfx[obj.gfxId].height;
            for (var i:int = 0; i < width; i++) {
                for (var j:int = 0; j < height; j++) {
                    var color:uint = gfx[obj.gfxId].getPixel(i, j);
                    if (color) {
                        if (Math.random() < .7)
                            particles.push([obj.pos.x+i, obj.pos.y+j, 0, 0, color, 0, true]);
                        else
                            particles.push([obj.pos.x+i, obj.pos.y+j, (Math.random() - .5) * 4, (Math.random() - .8) * 4, color, 0, true] );
                    }
                }
            }
        }
        
        private function loop(e:Event):void {
            if (paused) return;
            
            player.vy += GRAVITY;
            player.y += player.vy;
            
            obstacleInterval--;
            if (obstacleInterval < 0) {
                obstacleInterval = OBSTACLE_INTERVAL;
                
                obstacleSwitch = !obstacleSwitch;
                var oTop:GameObject, oBottom:GameObject;
                
                if (obstacleSwitch) {
                    oTop = obstacleTop;
                    oBottom = obstacleBottom;
                } else {
                    oTop = obstacleTop2;
                    oBottom = obstacleBottom2;
                }
                
                oTop.x = w;
                oTop.y = (Math.random() * 40) -65;
                oBottom.y = (Math.random() * 20) + oTop.y + 100;
            }

            obstacleTop.x -= speed;
            obstacleBottom.x = obstacleTop.x;
            obstacleTop2.x -= speed;
            obstacleBottom2.x = obstacleTop2.x;
            
            // check for game over
            if (!dead) {
                if (player.y < 0 || player.y > h-6) {
                    gameOver();
                }
                
                if (player.x > obstacleTop.x-6 && player.x < obstacleTop.x+16) {
                    if (player.y < obstacleTop.y+71) {
                        gameOver();
                    }
                } else if (player.x > obstacleTop2.x-6 && player.x < obstacleTop2.x+16) {
                    if (player.y < obstacleTop2.y+71) {
                        gameOver();
                    }
                }
                if (player.x > obstacleBottom.x-6 && player.x < obstacleBottom.x+16) {
                    if (player.y > obstacleBottom.y-6) {
                        gameOver();
                    } else if (!obstaclePassed) {
                        obstaclePassed = true;
                        score++;
                    }
                } else if (player.x > obstacleBottom2.x-6 && player.x < obstacleBottom2.x+16) {
                    if (player.y > obstacleBottom2.y-6) {
                        gameOver();
                    } else if (!obstaclePassed) {
                        obstaclePassed = true;
                        score++;
                    }
                } else {
                    obstaclePassed = false;
                }

            }
            canvas.lock();
            canvas.fillRect(canvas.rect, BACKGROUND_COLOR);
            if (player.active) {
                canvas.copyPixels(gfx[player.gfxId], gfx[player.gfxId].rect, player.pos);
            }
            canvas.copyPixels(gfx[obstacleTop.gfxId], gfx[obstacleTop.gfxId].rect, obstacleTop.pos);
            canvas.copyPixels(gfx[obstacleBottom.gfxId], gfx[obstacleBottom.gfxId].rect, obstacleBottom.pos);
            canvas.copyPixels(gfx[obstacleTop2.gfxId], gfx[obstacleTop2.gfxId].rect, obstacleTop2.pos);
            canvas.copyPixels(gfx[obstacleBottom2.gfxId], gfx[obstacleBottom2.gfxId].rect, obstacleBottom2.pos);
            
            // draw particles
            for (var i:int = particles.length-1; i >= 0; i--) {
                particles[i][2] *= .98;
                particles[i][3] *= .96;
                particles[i][3] += GRAVITY;
                particles[i][0] += particles[i][2];
                particles[i][1] += particles[i][3];
                
                if (particles[i][1] > h) {
                    particles[i][1] = h;
                    if (particles[i][5] < 1) {
                        particles[i][3] = -particles[i][3];
                        particles[i][5]++;
                    } else {
                        particles.splice(i, 1);
                        continue;
                    }
                }
                canvas.setPixel(particles[i][0], particles[i][1], particles[i][4]);
            }
            canvas.draw(hudScore);
            canvas.unlock();
        }
        
        private function onMouseDown(e:MouseEvent):void {
            if (dead && particles.length == 0) {
                /*
                for (var i:int = particles.length-1; i >= 0; i--) {
                    particles[i][1] = 1000;
                    particles[i][5] = 1000;
                }
                */
                restart();
                return;
            }
            
            player.vy -= 3;
        }
        
        public function get score():int {
            return playerScore;
        }
        public function set score(value:int):void {
            playerScore = value;
            hudScore.text = String(value);
        }
    }
}

import flash.geom.Point;

class GameObject extends Object {
    private var p:Point = new Point();
    public var active:Boolean = true;
    public var gfxId:String;
    public var vy:Number = 0;
    
    public function GameObject(gfxId:String) {
        this.gfxId = gfxId;
    }
    public function get pos():Point { return p; }
    public function set x(value:Number):void { p.x = value; }
    public function get x():Number { return p.x; }
    public function set y(value:Number):void { p.y = value; }
    public function get y():Number { return p.y; }
}
