/**
 * Copyright russ ( http://wonderfl.net/user/russ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5HNv
 */

package  {
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.utils.getTimer;

public class ObjectSubclassingBenchmark extends Sprite {
    private var logBox:TextField = new TextField();
    private var _TestSequence:Array;
    private var _NUM_LOOPS:uint = 1000000;

    private function log(...data):void {
        logBox.appendText(data.join("\t") + "\n")
    }

    private function onEnterFrame(event:Event):void {
        var curTest:Array = _TestSequence.shift();
        if (curTest == null) {
            stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            return;
        }
        if (curTest[2] != null) {

        }
        (curTest[0] as Function).apply(this, curTest[1] as Array);
    }

    public function ObjectSubclassingBenchmark() {
        stage.align = StageAlign.TOP_LEFT;
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.addChild(logBox);
        logBox.autoSize = TextFieldAutoSize.LEFT;

        log("Add data logging using log()");
        _TestSequence = [
            [_InstantiateWithSuper, []],
            [_InstantiateWithoutSuper, []],
            [_InstantiateObjectLiteral, []],
            [_InstantiateObjectInstance, []],
        ];
        stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function _InstantiateWithSuper():void {
        var obj:A;
        var t:int = getTimer();
        for(var i:uint; i < _NUM_LOOPS; ++i) {
            obj = new A(1, 2, 3, 4, 5);
        }
        log("With super: " + (getTimer() - t));
    }

    private function _InstantiateWithoutSuper():void {
        var obj:B_NoSuper;
        var t:int = getTimer();
        for(var i:uint; i < _NUM_LOOPS; ++i) {
            obj = new B_NoSuper(1, 2, 3, 4, 5);
        }
        log("Without super: " + (getTimer() - t));
    }

    private function _InstantiateObjectLiteral():void {
        var obj:Object;
        var t:int = getTimer();
        for(var i:uint; i < _NUM_LOOPS; ++i) {
            obj = {a:1, b:2, c:3, d:4, e:5};
        }
        log("Literal object: " + (getTimer() - t));
    }

    private function _InstantiateObjectInstance():void {
        var obj:Object;
        var t:int = getTimer();
        for(var i:uint; i < _NUM_LOOPS; ++i) {
            obj = new Object();
            obj.a = 1;
            obj.b = 1;
            obj.c = 1;
            obj.d = 1;
            obj.e = 1;
        }
        log("Object creation, then assignment: " + (getTimer() - t));
    }

}}

class A extends Object {
    private var _a:uint;
    private var _b:uint;
    private var _c:uint;
    private var _d:uint;
    private var _e:uint;
    public function A(a:uint, b:uint, c:uint, d:uint, e:uint) {
        super();
        _a = a;
        _b = b;
        _c = c;
        _d = d;
        _e = e;
    }
}

class B_NoSuper extends Object {
    private var _a:uint;
    private var _b:uint;
    private var _c:uint;
    private var _d:uint;
    private var _e:uint;
    public function B_NoSuper(a:uint, b:uint, c:uint, d:uint, e:uint) {
        _a = a;
        _b = b;
        _c = c;
        _d = d;
        _e = e;
    }
}
