/**
 * Copyright predek ( http://wonderfl.net/user/predek )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5GWb
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.geom.Rectangle;
    import flash.display.Sprite;

    public class Snake extends Sprite
    {

        var w:int = 20;
        var h:int = 20;
        var skala:int = 20;
        var ilpikseli:int;
        var i,j,k:int;

        var cb:uint = 0xEEEEEE;
        var cm:uint = 0x334466;
        var bmd:BitmapData = new BitmapData(w,h,false,cb);
        var bm:Bitmap = new Bitmap(bmd);

        var Tablica:Array = new Array  ;
        var dir:Point = new Point(1,0);
        var timer = new Timer(200,0);
        var gamepaused:Boolean;
        var apple:Point;

        public function Snake()
        {
            addChild(bm);

            bm.scaleX = skala;
            bm.scaleY = skala;

            bm.x = stage.stageWidth / 2 - w * skala / 2;
            bm.y = stage.stageHeight / 2 - h * skala / 2;

            ilpikseli = 3;

            for (i = 0; i < ilpikseli; i++)
            {
                Tablica[i] = new Point(w / 2 - i,h / 2);
            }

            timer.addEventListener(TimerEvent.TIMER,refreshview);
            timer.start();

            stage.addEventListener(KeyboardEvent.KEY_DOWN,klawisz);

            putapple();
        }

        function refreshview(e:TimerEvent)
        {
            var trypoint:Point = Tablica[0].add(dir);

            if (hittest(trypoint))
            {
                gameover();
            }
            else if(trypoint.equals(apple))
            {
                Tablica.push(Tablica[Tablica.length]);
                for (i = Tablica.length - 1; i > 0; i--)
                {
                    Tablica[i] = Tablica[i - 1].clone();
                }
                Tablica[0] = trypoint.clone();
                putapple();
                
            }
            else
            {

                for (i = Tablica.length - 1; i > 0; i--)
                {
                    Tablica[i] = Tablica[i - 1].clone();
                }
                Tablica[0] = trypoint.clone();

            }




            for (i = 0; i < w; i++)
            {
                for (j = 0; j < h; j++)
                {
                    bm.bitmapData.setPixel(i,j,cb);
                }
            }

            for (i = 0; i < Tablica.length; i++)
            {
                bm.bitmapData.setPixel(Tablica[i].x,Tablica[i].y,cm);
            }

            bm.bitmapData.setPixel(apple.x,apple.y,0xEE9999);

        }


        function klawisz(e:KeyboardEvent)
        {
            var ldir:Point = dir.clone();

            if (e.keyCode == Keyboard.UP)
            {
                dir = new Point(0,-1);
            }
            else if (e.keyCode == Keyboard.RIGHT)
            {
                dir = new Point(1,0);
            }
            else if (e.keyCode == Keyboard.DOWN)
            {
                dir = new Point(0,1);
            }
            else if (e.keyCode == Keyboard.LEFT)
            {
                dir = new Point(-1,0);
            }
            var zero:Point = new Point(0,0);
            if (dir.add(ldir).equals(zero))
            {
                dir = ldir.clone();
            }
        }

        function losujliczbe(min:Number,max:Number):int
        {
            //losuje liczby z podanego przedzialu:
            if (min <= max)
            {
                return Math.round(Math.random() * max - min) + min;
            }
            else
            {
                return 0;
            }

        }

        function hittest(p:Point):Boolean
        {
            var tryrect:Rectangle = new Rectangle(0,0,w,h);

            var flaga:Boolean = true;
            for (i = 0; i < Tablica.length; i++)
            {
                if (p.equals(Tablica[i]))
                {
                    flaga = false;
                    break;
                }
            }

            if (tryrect.containsPoint(p) && flaga)
            {
                return false;
            }
            else
            {
                return true;
            }
        }


        function putapple():void
        {
            apple = new Point(losujliczbe(0,w),losujliczbe(0,h));
            while (hittest(apple))
            {
                apple = new Point(losujliczbe(0,w),losujliczbe(0,h));
            }

            trace("apple:" + apple.toString());
        }

        function gameover()
        {
            trace("game over");
        }



    }
}