/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5GKL
 */

package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Shader;
    import flash.filters.ShaderFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.net.*;
    import com.bit101.components.*;
    
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "30")]
    public class Main extends Sprite{
        private const FILTER_URL:String = "http://www.digifie.jp/files/filters/Thermograph.pbj";
        
        private var _loader:URLLoader;
        private var _shader:Shader;
        private var _filter:ShaderFilter;
        
        private var _source:BitmapData;
        private var _bm:Bitmap;
        private var _video:CameraCapture;
        
        private var _chengeBtn:PushButton;
        private var _blendBtn:PushButton;
        
        private var _sliderR:HSlider;
        private var _sliderG:HSlider;
        private var _sliderB:HSlider;

        public function Main() {
            addChild(new Bitmap(new BitmapData(465, 465, false, 0)));
            
            var label:Label = new Label(this, 72, 360, "R Value                         G Value                          B Value");
            _sliderR = new HSlider(this, 72, 380, changeVal);
            _sliderG = new HSlider(this, 182, 380, changeVal);
            _sliderB = new HSlider(this, 292, 380, changeVal);
            _chengeBtn = new PushButton(this, 115, 410, "NormalView", viewChenge);
            _blendBtn = new PushButton(this, 250, 410, "VideoBland", blendVideo);
            //
            _source = new BitmapData(320, 240, false, 0);
            _bm = new Bitmap(_source);
            _bm.x = 72;
            _bm.y = 100;
            //
            filterLoad();
        }
        
        private function filterLoad():void{
            _loader = new URLLoader;
            _loader.addEventListener(Event.COMPLETE, onLoaded);
            _loader.dataFormat = URLLoaderDataFormat.BINARY;
            _loader.load(new URLRequest(FILTER_URL));
        }
        
        private function onLoaded(e:Event):void{
            _loader.removeEventListener(Event.COMPLETE, onLoaded);
                
            // CreateFilter
            _shader = new Shader(_loader.data);
            _filter = new ShaderFilter(_shader);
            //
            _sliderR.value = _shader.data.luminance_r.value * 100;
            _sliderG.value = _shader.data.luminance_g.value * 100;
            _sliderB.value = _shader.data.luminance_b.value * 100;
            //
            _video = new CameraCapture(320, 240, 30);
            _video.x = 72;
            _video.y = 100;
            _video.visible = false;
            addEventListener(Event.ENTER_FRAME, update);
            addChild(_video);
            addChild(_bm);
        }
        
        private function update(e:Event):void{
            _source.draw(_video)
            // addedFilter
            _source.applyFilter(_source, _source.rect, new Point(), _filter);
        }
        
        private function changeVal(e:Event):void{
            var n:Number = e.currentTarget.value * .01;
            switch(e.currentTarget){
                case _sliderR:
                    _shader.data.luminance_r.value = [n];
                    break;
                case _sliderG:
                    _shader.data.luminance_g.value = [n];
                    break;
                case _sliderB:
                    _shader.data.luminance_b.value = [n];
                    break;
            }
        }
        
        private function viewChenge(e:MouseEvent):void{
            if(_video.visible && !_bm.visible){
                _video.visible = false;
                _bm.visible = true;
                _chengeBtn.label = "NormalView"
            }else if(_bm.visible && !_video.visible){
                _video.visible = true;
                _bm.visible = false;
                _chengeBtn.label = "ThermoView"
            }else{
                if(_chengeBtn.label == "NormalView"){
                    _video.visible = true;
                    _bm.visible = false;
                    _chengeBtn.label = "ThermoView"
                }else if(_chengeBtn.label == "ThermoView"){
                    _video.visible = false;
                    _bm.visible = true;
                    _chengeBtn.label = "NormalView"
                }
                _bm.blendMode = "normal";
                _blendBtn.mouseEnabled = true;
                _blendBtn.alpha = 1;
            }
        }
        
        private function blendVideo(e:MouseEvent):void{
            _video.visible = _bm.visible = true;
            _bm.blendMode = "overlay";
            _blendBtn.mouseEnabled = false;
            _blendBtn.alpha = .3;
            if(_chengeBtn.label == "NormalView"){
                _chengeBtn.label = "ThermoView"
            }else if(_chengeBtn.label == "ThermoView"){
                _chengeBtn.label = "NormalView"
            }
        }

    }
    
}


// Camera
import flash.media.Video;
import flash.events.Event;
import flash.media.Camera;

class CameraCapture extends Video{
    private var _cam:Camera;
    private var _camW:int;
    private var _camH:int;
    private var _fps:Number;

    public function CameraCapture(camW:Number, camH:Number, fps:Number=30) {
        this.width = camW;
        this.height = camH;
        _camW = camW;
        _camH = camH;
        _fps = fps;
        _cam = Camera.getCamera();
        _cam.setMode(_camW, _camH, _fps);
        this.attachCamera(_cam);
    }
}