/**
 * Copyright TetsuroKato ( http://wonderfl.net/user/TetsuroKato )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5GFT
 */

/*
れんしゅう
*/
package {
    import flash.display.AVM1Movie;
    
    import flash.display.Sprite;
    import flash.events.*;
    import flash.ui.Keyboard;
    import net.hires.debug.Stats;
    
    public class MouseEvents extends Sprite{
        private var ball:Ball;
        public function MouseEvents(){
            ball = new Ball();
            ball.x = 100;
            ball.y = 100;
            ball.graphics.beginFill(0);
            ball.graphics.drawRect(0,0,100,100);
            ball.graphics.endFill();
            addChild(ball);
            //addChild(new Stats());
            ball.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownBall);
            ball.addEventListener(MouseEvent.MOUSE_UP, onMouseUpBall);
            ball.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveBall);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownStage);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUpStage);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveStage);
        }
        private function onMouseDownBall(e:MouseEvent):void{
            ball.draw(0xff0000);
        }
        private function onMouseUpBall(e:MouseEvent):void{
            ball.draw(0x0000ff);
        }
        private function onMouseMoveBall(e:MouseEvent):void{
            ball.draw(0x00ff00);
        }
        private function onMouseDownStage(e:MouseEvent):void{
            graphics.beginFill(0xff0000);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
        }
        private function onMouseUpStage(e:MouseEvent):void{
            graphics.beginFill(0x0000ff);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
        }
        private function onMouseMoveStage(e:MouseEvent):void{
            graphics.beginFill(0x00ff00);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
        }

    }

/*    public class ShipSim extends Sprite{
        private var ship:Ship;
        private var vr:Number = 0;
        private var thrust:Number =0;
        private var vx:Number = 0;
        private var vy:Number = 0;
        public function ShipSim(){
            init();
        }

        public function init():void{
            graphics.beginFill(0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
            ship = new Ship();
            addChild(ship);
            ship.x = stage.stageWidth / 2;
            ship.y = stage.stageHeight / 2;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        private function onKeyDown(e:KeyboardEvent):void{
            switch(e.keyCode){
                case Keyboard.LEFT:
                vr = -5;
                break;
                
                case Keyboard.RIGHT:
                vr = 5;
                break;
                
                case Keyboard.UP:
                thrust =0.2;
                ship.draw(true);
                break;
                
                default:
                break;
            }

        }
        private function onKeyUp(e:KeyboardEvent):void{
            vr = 0;
            thrust =0;
            ship.draw(false);
        }
        private function onEnterFrame(e:Event):void{
            ship.rotation += vr;
            var angle:Number = ship.rotation * Math.PI / 180;
            var ax:Number = Math.cos(angle) * thrust;
            var ay:Number = Math.sin(angle) * thrust;
            vx += ax;
            vy += ay;
            vx /= 1.1;
            vy /= 1.1;
            ship.x += vx;
            ship.y += vy;
        }


    }*/

    /*public class FlashTest extends Sprite {
        private var arrow:Arrow;
        private var speed:Number = 5;
        
        private var ball:Ball;
        private var bvx:Number = 0;
        private var bvy:Number = 0;
        private var bax:Number = 0;
        private var bay:Number = 0;
        
        public function FlashTest() {
            // arrow
            arrow = new Arrow();
            addChild(arrow);
            addEventListener(Event.ENTER_FRAME, onEnterFrameArrow);
            // ball
            ball = new Ball();
            addChild(ball);
            ball.x = stage.stageWidth/2;
            ball.y = stage.stageHeight/2;
            addEventListener(Event.ENTER_FRAME, onEnterFrameBall);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDownBall);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUpBall);
        }
        private function onEnterFrameArrow(event:Event):void{
            var dx:Number = mouseX - arrow.x;
            var dy:Number = mouseY - arrow.y;
            var angle:Number = Math.atan2(dy,dx);
            arrow.rotation = angle * 180 / Math.PI;
            var vx:Number = Math.cos(angle) * speed;
            var vy:Number = Math.sin(angle) * speed;
            arrow.x += vx;
            arrow.y += vy;
            arrow.x = Math.min(stage.stageWidth, Math.max(0, arrow.x));
            arrow.y = Math.min(stage.stageHeight, Math.max(0, arrow.y));
        }
        
        private function onEnterFrameBall(event:Event):void{
            bvx += bax;
            bvy += bay;
            ball.x += bvx;
            ball.y += bvy;
            
            if(ball.x<0 || stage.stageWidth<ball.x){
                bvx *= -1;
            }
            if(ball.y<0 || stage.stageHeight<ball.y){
                bvy *= -1;
            }


        }
        private function onKeyDownBall(event:KeyboardEvent):void{
            switch(event.keyCode){
                case Keyboard.LEFT:
                bax = -0.2;
                break;
                
                case Keyboard.RIGHT:
                bax = 0.2;
                break;
                
                case Keyboard.UP:
                bay = -0.2;
                break;
                
                case Keyboard.DOWN:
                bay = 0.2;
                break;
            }

        }
        private function onKeyUpBall(event:KeyboardEvent):void{
            bax = 0;
            bay = 0;
        }


    }*/
}

import flash.display.Sprite;
class Arrow extends Sprite{
    public function Arrow():void{
        graphics.lineStyle(1,0,1);
        graphics.beginFill(0xffff00);
        graphics.moveTo(-50, -25);
        graphics.lineTo(0,-25);
        graphics.lineTo(0,-50);
        graphics.lineTo(50,0);
        graphics.lineTo(0,50);
        graphics.lineTo(0,25);
        graphics.lineTo(-50,25);
        graphics.lineTo(-50,-25);
        graphics.endFill();
    }

}

class Ball extends Sprite{
    private var radius:Number;
    private var color:uint;
    
    public function Ball(radius:Number=40, color:uint=0x0000ff){
        this.radius = radius;
        this.color = color;
        graphics.beginFill(color);
        graphics.drawCircle(0,0, radius);
        graphics.endFill();
    }
    public function draw(color:uint):void
    {
        this.color = color;
        graphics.beginFill(color);
        graphics.drawCircle(0,0, radius);
        graphics.endFill();
        
    }


}

class Ship extends Sprite{
    public function Ship(){
        draw(false);
    }

    public function draw(showFlame:Boolean):void{
        graphics.clear();
        graphics.lineStyle(1, 0xffffff);
        graphics.moveTo(10,0);
        graphics.lineTo(-10,10);
        graphics.lineTo(-5,0);
        graphics.lineTo(-10,-10);
        graphics.lineTo(10,0);
        
        if(showFlame){
            graphics.moveTo(-7.5, -5);
            graphics.lineTo(-15,0);
            graphics.lineTo(-7.5, 5);
        }
    }
}
