/**
 * Copyright yurij.shaulov ( http://wonderfl.net/user/yurij.shaulov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5G4c
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;

    public class EasingDocument1 extends Sprite {
        private var _ball:Ball;
        private var _easing:Number = .2;
        private var _targetX:Number;
        private var _targetY:Number;
        
        public function EasingDocument1() {
            init();
        }

        private function init():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var tex:TextField = new TextField  ;
            addChild(tex);
            tex.width = 450;
            tex.x = tex.y = 10;
            tex.multiline = true;
            
            tex.text = 'クリックした位置にボールが徐々に近づき、その後はマウスストーカーになります。\n';
            
            // ステージ上にスプライトを配置します。
            addChild(_ball = new Ball);
            _ball.x = stage.stageWidth / 2;
            _ball.y = stage.stageHeight / 2;
            // イベントハンドルを設定します。
            

            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }
        
        private function clickHandler($event:MouseEvent):void{
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler($event:Event):void{
            _targetX = mouseX;
            _targetY = mouseY;
            

            var distanceX:Number = _targetX - _ball.x;
            var distanceY:Number = _targetY - _ball.y;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, box);
            
            if(Math.abs(distanceX) < .5 && Math.abs(distanceY) < .5){
                //trace(distanceX, distanceY)
               // _ball.x = _targetX;
                //_ball.y = _targetY;
                //removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
            }else{
                _ball.x = _ball.x + distanceX * _easing;
                _ball.y = _ball.y + distanceY * _easing;
            }
        }
        
        private function box($event:MouseEvent):void{
                
            }
    }
}

import flash.display.Sprite;
class Ball extends Sprite {
    private var _radius:Number = 10;
    function Ball(){
        init();
    }
    
    private function init():void{
        graphics.beginFill(0x000000);
        graphics.lineStyle(0, 0x999999);
        graphics.drawCircle(0, 0, _radius);
    }
    
    public function get radius():Number{
        return _radius;
    }
}
import flash.display.Sprite;
import flash.display.DisplayObjectContainer;
import flash.events.*;
class Box extends Sprite
    {
        private var _canvas:DisplayObjectContainer;
        private var _startX:Number;
        private var _startY:Number;
        private var _endX:Number;
        private var _endY:Number;

        public function Box($canvas:DisplayObjectContainer, $startX:Number, $startY:Number)
        {            
            _canvas = $canvas;
            _startX = $startX;
            _startY = $startY;
            _endX = _canvas.mouseX;
            _endY = _canvas.mouseY;
            
            _canvas.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveHandler);
            _canvas.addEventListener(MouseEvent.MOUSE_UP, onMouseUpHandler);
            _canvas.addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }
        
        private function onMouseMoveHandler(event:MouseEvent):void
        {
            _endX = _canvas.mouseX;
            _endY = _canvas.mouseY;
        }
        
        private function onMouseUpHandler(event:MouseEvent):void 
        {
            _canvas.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveHandler);            
            _canvas.removeEventListener(MouseEvent.MOUSE_UP, onMouseUpHandler);
            _canvas.removeEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }
        
        private function onEnterFrameHandler(event:Event):void 
        {
            graphics.clear();
            graphics.lineStyle(2, 0x88B1CC);
            graphics.moveTo(_startX, _startY);
            graphics.beginFill(0x88B1CC, .25);
            graphics.lineTo(_endX, _startY);
            graphics.lineTo(_endX, _endY);
            graphics.lineTo(_startX, _endY);
            graphics.lineTo(_startX, _startY);
            graphics.endFill();
        }
    }
