/**
 * Copyright freddy ( http://wonderfl.net/user/freddy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Ftx
 */

// forked from freddy's boxes
// forked from freddy's db97531
package {
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class Main extends Sprite {
        private var canvas:BitmapData;
        private var backCanvas:BitmapData;
        private var source:Sprite = new Sprite();
        private var frame:int = 0;
        private var rect:Rectangle;
        
        public function box(x:Number, y:Number, speed:Number):void {
            var beat:int = 8 * speed;
            var gravity:Number = 2 / speed / speed;
            var juggler:Juggler;
            juggler = new Juggler([4, 0], [[60, 0], [60, 0], [-60, 0], [-60, 0]], [[60, 0], [60, 0], [-60, 0], [-60, 0]], beat, gravity);
            juggler.x += x;
            juggler.y += y;
            source.addChild(juggler);
            juggler = new Juggler([2, 0], [[-60, 0], [-60, 0], [60, 0], [60, 0]], [[-60, 0], [-60, 0], [60, 0], [60, 0]], beat, gravity);
            juggler.x += x;
            juggler.y += y;
            source.addChild(juggler);
        }

        public function Main() {
            box(-150, -300, 0.25);
            box(-150, -150, 0.5);
            box(0, -150, 1);
            box(150, -150, 2);
            box(150, 0, 4);
            
            addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF)));
            backCanvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            rect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
        }
        public function enterFrameHandler(event:Event):void {
            frame++;
            if (frame == 15) {
                frame = 0;
                canvas.copyPixels(backCanvas, rect, new Point(0, 0));
                backCanvas.fillRect(rect, 0xFFFFFF);
            }

            backCanvas.draw(source);
        }

    
    }

}

import flash.display.Sprite;
import flash.events.Event;

class Juggler extends Sprite {

    private var _siteswap:Array;
    private var _throwpos:Array;
    private var _catchpos:Array;
    private var _index:int = 0;
    private var _frame:int = 0;
    private var _beat:int = 8;
    private var _gravity:Number = 1;
    private var _queue:Array = [];
    
    public function Juggler(siteswap:Array, throwpos:Array, catchpos:Array, beat:int, gravity:Number) {
        // write as3 code here..
        _siteswap = siteswap;
        _throwpos = throwpos;
        _catchpos = catchpos;
        _beat = beat;
        _gravity = gravity;
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        x = 240;
        y = 430;
        scaleX = scaleY = 0.5;
    }
    public function enterFrameHandler(event:Event):void {
        _frame++;
        if (_frame == _beat) {
            _frame = 0;
            var s:int = _siteswap[_index % _siteswap.length];
            var tp0:Array = _throwpos[_index % _throwpos.length];
            var cpS:Array = _catchpos[(_index + s) % _catchpos.length];
            var tpS:Array = _throwpos[(_index + s) % _throwpos.length];
            _index++;
            
            if (s == 0) {
                return;
            }

            
            var air:Number = (s == 1 ? 0.5 : s - 1) * _beat;
            var ball:Ball;
            if (_queue.length == 0) {
                ball = new Ball();
                ball.addEventListener(Event.COMPLETE, function (event:Event):void {
                    _queue.push(ball);
                });
                addChild(ball);
            } else {
                ball = _queue.shift();
            }
            var orbit:Function = createJoinOrbit(
                createFallOrbit(tp0[0], 0, cpS[0], 0, _gravity, air),
                createFallOrbit(cpS[0], 0, tpS[0], 0, -1 * _gravity, s * _beat - air),
                air);
            ball.reset(orbit, s * _beat - 1);


        }

    }
    
    public function createFallOrbit(ax:Number, ay:Number, bx:Number, by:Number, g:Number, tab:Number):Function {
        var vy:Number = by / tab - ay / tab - 0.5 * g * tab;
        return function(t:Number):Object {
            return {
                x: ax * (1 - t / tab) + bx * t / tab,
                y: ay + vy * t + 0.5 * g * t * t
            };
        }
    }
    
    public function createJoinOrbit(a:Function, b:Function, tb:Number):Function {
        return function(t:Number):Object {
            return t < tb ? a(t) : b(t - tb);
        };
    }
}

class Ball extends Sprite {
    private var _orbit:Function;
    private var _frame:int = 0;
    private var _life:int = 0;
    
    public function Ball() {
        graphics.beginFill(Math.random() * 0xffffff);
        graphics.drawCircle(0, 0, 15);
        graphics.endFill();
        addEventListener(Event.ENTER_FRAME, function(event:Event):void {
            _frame++;
            var p:Object = _orbit(_frame);
            x = p.x;
            y = p.y;
            if (_frame == _life) {
                dispatchEvent(new Event(Event.COMPLETE));
            }
        });
        super();
    }
    
    public function reset(orbit:Function, life:int):void {
        _orbit = orbit;
        _frame = 0;
        _life = life;
        var p:Object = _orbit(_frame);
        x = p.x;
        y = p.y;
    }


}


