/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Ej4
 */

// forked from ProjectNya's キラキラ (4)
////////////////////////////////////////////////////////////////////////////////
// キラキラ (4)
//
// [AS3.0] LightFoliumクラスだ！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1123
// [AS3.0] MiniVisualizerクラスだ！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1344
// [AS3.0] TwinkleParticlesクラスだ！ (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1371
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var twinkle:TwinkleParticles;
        private var visualizer:SoundVisualizer;
        private var se:SoundEffect;
        private static var bgmPath:String = "http://www.project-nya.jp/images/bgm/project.mp3";

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var label:Label = new Label(400, 80, 40, Label.CENTER);
            addChild(label);
            label.x = 32;
            label.y = 202;
            label.textColor = 0xFFFFFF;
            label.alpha = 0.3;
            label.text = "Bienvenue";
            //
            twinkle = new TwinkleParticles();
            addChild(twinkle);
            //
            visualizer = new SoundVisualizer(8, 0xFFFFFF);
            addChild(visualizer);
            visualizer.x = 442;
            visualizer.y = 12;
            visualizer.alpha = 0.4;
            //
            se = new SoundEffect();
            se.addEventListener(Event.COMPLETE, complete, false, 0, true);
            se.load(bgmPath);
        }
        private function complete(evt:Event):void {
            se.removeEventListener(Event.COMPLETE, complete);
            se.play(0.5, true);
            visualizer.alpha = 1;
            visualizer.start();
            //
            twinkle.start();
        }
        
    }

}


//////////////////////////////////////////////////
// TwinkleParticlesクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class TwinkleParticles extends Sprite {
    private var particles:Array;
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private static var colorTrans:ColorTransform;
    private static var point:Point = new Point();
    private static var blur:BlurFilter;
    private var count:uint = 0;
    private var color:ColorHSV;
    private static var cx:uint = 232;
    private static var cy:uint = 232;
    private static var radius:uint = 160;
    private static var radian:Number = Math.PI/180;
    private var nx:uint = 1;
    private var ny:uint = 1;

    public function TwinkleParticles() {
        particles = new Array();
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        rect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        colorTrans = new ColorTransform(1, 1, 1, 0.6, 0, 0, 0, 0);
        blur = new BlurFilter(16, 16, 3);
        color = new ColorHSV(0, 0.5);
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, create, false, 0, true);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function create(evt:Event):void {
        count += 2;
        if (count%90 == 0) nx = nx%10 + 1;
        if (count%900 == 0) ny = ny%10 + 1;
        color.h = count;
        var particle:Particle = new Particle(color.value);
        particle.x = cx + radius*Math.sin(count*nx*radian)*Math.cos(count*radian);
        particle.y = cy + radius*Math.sin(count*ny*radian)*Math.sin(count*radian);
        container.addChild(particle);
        particles.push(particle);
    }
    private function update(evt:Event):void {
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            particle.update();
            if (particle.life < 0 || particle.y > stage.stageHeight + 50) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        draw();
    }
    private function draw():void {
        bitmapData.lock();
        bitmapData.draw(container, null, colorTrans);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.filters.GlowFilter;

class Particle extends Sprite {
    private var glow:GlowFilter;
    private var _width:uint = 12;
    private var _height:uint = 18;
    private var blur:uint = 8;
    private static var color:uint = 0xFFFFFF;
    private static var max:uint = 50;
    public var life:int = max;
    private static var radius:Number = 3;
    private var dx:Number = 0;
    private var gravity:Number = - 6;
    private static var acceleration:Number = 0.8;

    public function Particle(rgb:uint = 0xFFFFFF, w:uint = 12, h:uint = 18, b:uint = 8) {
        _width = w;
        _height = h;
        blur = b;
        glow = new GlowFilter(rgb, 1, blur, blur, 2, 3, false, false);
        draw();
        init();
    }

    private function init():void {
        dx = Math.random()*radius*2 - radius;
    }
    public function update():void {
        if (life < 0) return;
        life --;
        x += dx;
        gravity += acceleration;
        y += gravity;
        alpha = (life/max < 0.5) ? life*2/max : 1;
        blink();
    }
    private function blink():void {
        if (life%4 == 0) {
            visible = false;
        } else {
            visible = true;
        }
    }
    private function draw():void {
        graphics.beginFill(color);
        graphics.moveTo(0, -_height/2);
        graphics.curveTo(0, 0, -_width/2, 0);
        graphics.curveTo(0, 0, 0, _height/2);
        graphics.curveTo(0, 0, _width/2, 0);
        graphics.curveTo(0, 0, 0, -_height/2);
        graphics.endFill();
        filters = [glow];
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// SoundVisualizerクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.media.SoundMixer;
import flash.utils.ByteArray;

class SoundVisualizer extends Sprite {
    private var max:uint;
    private var color:uint;
    private static var bw:uint = 4;
    private static var bh:uint = 16;
    private static var xoffset:uint = 1;
    private static var yoffset:uint = 2;
    private var indicators:Array;
    private var timer:Timer;
    private static var interval:uint = 25;
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint;

    public function SoundVisualizer(m:uint, c:uint = 0x000000) {
        max = m;
        color = c;
        factors = uint(channels/max);
        draw();
    }

    private function draw():void {
        indicators = new Array();
        for (var n:uint = 0; n < max; n++) {
            var indicator:SoundIndicator = new SoundIndicator(bw, bh, color);
            addChild(indicator);
            indicator.x = - uint((bw + xoffset)*max/2) + (bw + xoffset)*n;
            indicator.y = uint(bh/2);
            indicators.push(indicator);
        }
        byteArray = new ByteArray();
    }
    public function start():void {
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, update, false, 0, true);
        timer.start();
    }
    public function stop():void {
        if (timer) {
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER, update);
        }
        reset();
    }
    public function update(evt:TimerEvent):void {
        try {
            SoundMixer.computeSpectrum(byteArray, true, factors);
        } catch (err:Error) {
            trace(err.message);
        }
        for (var n:uint = 0; n < max; n++) {
            var indicator:SoundIndicator = indicators[n];
            byteArray.position = factors*4*n;
            var percent:Number = byteArray.readFloat();
            indicator.update(percent);
        }
    }
    public function reset():void {
        for (var n:uint = 0; n < max; n++) {
            var indicator:SoundIndicator = indicators[n];
            indicator.reset();
        }
    }

}


//////////////////////////////////////////////////
// SoundIndicatorクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;

class SoundIndicator extends Sprite {
    private var bar:Shape;
    private var color:uint;
    private var _width:uint;
    private var _height:uint;

    public function SoundIndicator(w:uint, h:uint, c:uint = 0x000000) {
        _width = w;
        _height = h;
        color = c;
        draw();
        reset();
    }

    private function draw():void {
        var base:Shape = new Shape();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, _width, 1);
        base.graphics.endFill();
        //
        bar = new Shape();
        addChild(bar);
        bar.graphics.beginFill(color);
        bar.graphics.drawRect(0, 0, _width, - _height);
        bar.graphics.endFill();
    }
    public function update(percent:Number):void {
        bar.scaleY = percent;
        bar.height = uint(bar.height);
    }
    public function reset():void {
        bar.scaleY = 0;
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;
import flash.media.SoundLoaderContext;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;

    public function SoundEffect() {
    }

    public function init(Snd:Class):void {
        sound = new Snd();
    }
    public function load(filePath:String):void {
        sound = new Sound();
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
        try {
            sound.load(new URLRequest(filePath), new SoundLoaderContext(10, true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(lv:Number, loop:Boolean = false):void {
        playing = true;
        if (channel) channel.stop();
        level = lv;
        looping = loop;
        channel = sound.play();
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
        if (looping) {
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
        }
    }
    public function stop():void {
        playing = false;
        if (channel) {
            channel.stop();
            channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        }
    }
    public function setVolume(v:Number):void {
        volume = v;
        if (channel) {
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        }
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}
