/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5DTl
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import jp.progression.commands.lists.SerialList;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.easing.*;
	
	[SWF(width="465", height="465", frameRate="60", backgroundColor="0x000000")]
	
    public class FlashTest extends Sprite {
    	
		private var tf:TextField;
		private var fm_title:TextFormat;
		private var fm_body_title:TextFormat;
		private var fm_body_comment:TextFormat;
		
		private var data:Vector.<Object>;
		
        public function FlashTest() {
            // write as3 code here..
			var notice:TextField = new TextField();
			
			new SerialList(null,
				new Amf('SampleController.get_spark_data',
					function(res:Object):Vector.<Object> {
						//trace(res);
						var V:Vector.<Object> = new Vector.<Object>(res.length);
						res.forEach(function(res:Object, i:int, a:Array):void {
							var O:Object = { };
							O['h3'] = res['h3'];
							var aa:Array = [];
							res['a_wiki'].forEach(function(a_wiki:Object, i:int, a:Array):void {
								var OO:Object = {};
								OO['href'] = a_wiki['href'];
								OO['text'] = a_wiki['text'];
								OO['comment'] = a_wiki['comment'];
								aa.push(OO);
							} );
							O['a_wiki'] = aa;
							V[i] = O;
						} );
						return V;
					}, {
						onStart:function():void {
							trace('amf start');
							notice.defaultTextFormat = new TextFormat('_typewriter', 10, 0xffffff);
							notice.text = 'データ取得中';
							addChild(notice);
						},
						onComplete:function():void {
							trace('amf end');
							removeChild(notice);
							
							data = this.latestData;
							//youtube
							youtube();
						}
					}
				),
				function():void {
					//data = this.latestData;
				}
			).execute();
        }
        
		private function startTween(data:Vector.<Object>):void
		{
			var totalTween:ITween;
			var titleTween:ITween;
			var tweens:Array = [];
			fm_title = new TextFormat('_typewriter', 20, 0xffffff);
			fm_body_title = new TextFormat('_typewriter', 16, 0xffffff);
			fm_body_comment = new TextFormat('_typewriter', 12, 0xffffff);
			
			data.forEach(function(o:Object, i:int, v:Vector.<Object>):void {
				tf = new TextField();
				tf.defaultTextFormat = fm_title;
				tf.autoSize = 'left';
				tf.text = o.h3;
				tf.x = -tf.width;
				tf.y = (stage.stageHeight - tf.height) / 2;
				addChild(tf);
				
				var wrapSprite:Sprite = new Sprite();
				var asdf:int = 0;
				o.a_wiki.forEach(function(w:Object, j:int, a:Array):void {
					var innerSprite:Sprite = new Sprite();
					var tf_body_title:TextField = new TextField();
					tf_body_title.defaultTextFormat = fm_body_title;
					tf_body_title.autoSize = 'left';
					tf_body_title.text = w.text;
					innerSprite.addChild(tf_body_title);
					var tf_body_comment:TextField = new TextField();
					tf_body_comment.defaultTextFormat = fm_body_comment;
					tf_body_comment.width = 400;
					tf_body_comment.multiline = true;
					tf_body_comment.wordWrap = true;
					tf_body_comment.y = tf_body_title.height;
					tf_body_comment.text = w.comment;
					innerSprite.addChild(tf_body_comment);
					innerSprite.y = asdf;
					wrapSprite.addChild(innerSprite);
					asdf += innerSprite.height;
				} );
				wrapSprite.x = (stage.stageWidth - wrapSprite.width) / 2;
				wrapSprite.y = stage.stageHeight;
				addChild(wrapSprite);
				
				titleTween = BetweenAS3.tween(tf, { x:stage.stageWidth }, { x: -tf.width }, 1, Sine.easeInOut);
				var tw_a:ITween = BetweenAS3.slice(titleTween, 0.0, 0.45, true);
				var tw_b:ITween = BetweenAS3.slice(titleTween, 0.45, 0.5, true);
				var tw_c:ITween = BetweenAS3.slice(titleTween, 0.5, 1.0, true);
				tw_a = BetweenAS3.scale(tw_a, 0.5);
				tw_b = BetweenAS3.scale(tw_b, 20);
				tw_c = BetweenAS3.scale(tw_c, 0.25);
				tweens.push(BetweenAS3.serial(tw_a, tw_b, tw_c));
				
				tweens.push(BetweenAS3.tween(wrapSprite, { y: -wrapSprite.height }, { y:stage.stageHeight }, 8 + Math.round(wrapSprite.height * 0.01)));
			} );
			
			totalTween = BetweenAS3.serialTweens(tweens);
			totalTween.play();
			totalTween.stopOnComplete = false;
		}
        
		private function youtube():void
		{
			Security.allowDomain('www.youtube.com');
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
			loader.load(new URLRequest('http://www.youtube.com/apiplayer?version=3'));
		}
		
		private function onLoaderInit(e:Event):void 
		{
			e.currentTarget.loader.content.addEventListener('onReady', onPleyerReady);
			e.currentTarget.loader.x = stage.stageWidth - 100;
			e.currentTarget.loader.y = stage.stageHeight - 100;
			addChild(e.currentTarget.loader);
		}
		
		private function onPleyerReady(e:Event):void 
		{
			e.currentTarget.setSize(100,100);
			e.currentTarget.cueVideoById('h86rFn7CF64');
			e.currentTarget.playVideo();
			
			//tweenstart
			startTween(data);
		}
		
    }
}

import flash.events.Event;
import flash.net.Responder;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

/**
 * ...
 * @author m_emem
 */
class Amf extends Command 
{
	private var _amf:AmfConnect;
	private var _func:String;
	private var _args:Object;
	private var _callback:Function;
	
	/**
	 * 新しい AmfCommand インスタンスを作成します。
	 */
	public function Amf( func:String, callback:Function, initObject:Object = null, ... args:Array ) 
	{
		_func = func;
		_callback = callback;
		_args = args;
		
		// 親クラスを初期化します。
		super( _execute, _interrupt, initObject );
	}
	
	/**
	 * 実行されるコマンドの実装です。
	 */
	private function _execute():void 
	{
		_amf = AmfConnect.instance;
		_amf.dispatcher.addEventListener(Event.COMPLETE, _complete, false, 0, true);
		
		var params:Array = [_func, _callback];
		params.push.apply(params, _args);
		_amf.execute.apply(_amf, params);
		
		// 
		//executeComplete();
	}
	
	/**
	 * 中断されるコマンドの実装です。
	 */
	private function _interrupt():void 
	{
	}
	
	private function _complete(e:Event):void
	{
		_amf.dispatcher.removeEventListener(Event.COMPLETE, _complete);
		latestData = _amf.data;
		
		_amf.data = null;
		_func = null;
		_callback = null;
		_args = null;
		
		if (_amf.error != null) {
			super.throwError(this, new Error(_amf.error));
		} else {
			super.executeComplete();
		}
	}
	
	/**
	 * インスタンスのコピーを作成して、各プロパティの値を元のプロパティの値と一致するように設定します。
	 */
	public override function clone():Command 
	{
		return new Amf( _func, _callback, this, _args );
	}
}

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.events.NetStatusEvent;
import flash.net.NetConnection;
import flash.net.ObjectEncoding;
import flash.net.Responder;

/**
 * ...
 * @author m_emem
 */
class AmfConnect
{
	private static var _instance:AmfConnect;
	public var dispatcher:IEventDispatcher;
	public var nc:NetConnection;
	public var error:Object;
	
	//private var gatewayUrl:String = 'http://localhost:13000/rubyamf/gateway';
	private var gatewayUrl:String = 'http://afternoon-spring-97.heroku.com/rubyamf/gateway';
	private var callback:Function;
	public var data:Object;
	
	public function AmfConnect() 
	{
		if (_instance === null) {
			_instance = this;
			init();
		} else {
			throw new Error('Singleton class');
		}
	}
	
	public static function get instance():AmfConnect
	{
		if (_instance === null) {
			_instance = new AmfConnect();
		}
		return _instance;
	}
	
	private function init():void
	{
		dispatcher = new EventDispatcher();
		error = null;
		
		nc = new NetConnection();
		nc.objectEncoding = ObjectEncoding.AMF3;
		nc.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
		nc.connect(gatewayUrl);
	}
	
	private function onNetStatus(e:NetStatusEvent):void 
	{
		trace("Connection error, error code: (" +e.info.code + ")", "System message");
	}
	
	public function execute(_func:String, _callback:Function, ... _args:Array):void
	{
		callback = _callback;
		
		var params:Array = [_func, new Responder(onResultHandler, onFaultHandler)];
		params.push.apply(params, _args);
		nc.call.apply(nc, params);
	}
	
	private function onResultHandler(result:Object):void
	{
		if (callback != null) {
			data = callback.call(null, result);
		} else {
			data = result;
		}
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
	private function onFaultHandler(fault:Object):void
	{
		data = fault;
		error = 'discription: ' + fault.description + ' code: ' + fault.code + ' details: ' + fault.details + ' level: ' + fault.level + ' line: ' + fault.line;
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
}