/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5DQR
 */

package 
{
    import flash.display.BlendMode;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.system.System;
    import flash.display.LoaderInfo;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.ByteArray;
    import flash.external.ExternalInterface;
    import flash.net.URLRequest;
    import com.adobe.images.PNGEncoder;
    import flash.system.Security;
    
    /**
     * versão 0.2
     * thx alot to http://blog.yoz.sk/2009/10/bitmap-bitmapdata-bytearray/
     * @author Thi
     */
    public class Main extends Sprite 
    {
        
        public function Main(){
            if (stage) flashLoaded();
            else addEventListener(Event.ADDED_TO_STAGE, flashLoaded);
        }
        
        private function flashLoaded(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, flashLoaded);
            Security.allowDomain("*");
            ExternalInterface.addCallback("sendSrc", srcToFlash)
            ExternalInterface.call("flashLoaded");
        }
        
        private var l:Loader,
                    pref:String,
                    maker:String;
        public function srcToFlash(src:String, pref:String, maker:String):void
        {
            this.pref = pref;
            this.maker = maker;
            l = new Loader();
            l.load(new URLRequest(src));
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, srcLoaded);
        }
        
        private function srcLoaded(e:Event):void
        {
            var loaderInfo:LoaderInfo = LoaderInfo(e.target);
            var ba:ByteArray = loaderInfo.bytes;
            l = new Loader();
            l.loadBytes(ba);
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, baLoaded);
        }
        
        private function baLoaded(e:Event):void
        {
            var loaderInfo:LoaderInfo = LoaderInfo(e.target);
            var bmd:BitmapData = new BitmapData(loaderInfo.width, loaderInfo.height, true, 0xFFFFFF);
            bmd.draw(loaderInfo.loader);
            
            var bmd2:BitmapData;
            var w2:Number = bmd.width;
            var h2:Number = bmd.height;
            var x2:Number = 0;
            var y2:Number = 0;
            var rect:Rectangle;
            var point:Point = new Point(0, 0);

            
            if (maker == pref || pref == null)
            {
                // no change
                rect = new Rectangle(x2, y2, w2, h2);
                bmd2 = new BitmapData(w2, h2, true, 0xFFFFFF);
                bmd2.copyPixels(bmd, rect, point, null, null, false);
            } else if (maker == "xp" && pref == "vx")
            {
                // sem primeira coluna
                w2 = Math.floor(w2 * .75);
                x2 = Math.floor(bmd.width / 4);
                rect = new Rectangle(x2, y2, w2, h2);
                bmd2 = new BitmapData(w2, h2, true, 0xFFFFFF);
                bmd2.copyPixels(bmd, rect, point, null, null, false);
            } else if (maker == "vx" && pref == "xp")
            {
                // adicionar coluna do meio em primeira
                point.x = w2 / 3;
                w2 = Math.floor(w2 / .75);
                rect = new Rectangle(x2, y2, w2, h2);
                bmd2 = new BitmapData(w2, h2, true, 0xFFFFFF);
                bmd2.copyPixels(bmd, rect, point, null, null, false);
                
                point.x = 0;
                w2 = Math.floor(bmd.width / 3);
                x2 = w2;
                rect.width = w2;
                rect.x = x2;
                bmd2.copyPixels(bmd, rect, point, null, null, false);
                w2 = Math.floor(bmd.width / .75);
            }
            
            ExternalInterface.call("b64ToJs", Base64.encode(PNGEncoder.encode(bmd2)), maker, pref, String(w2), String(h2));
        }
    }
}


/*  
 * Base64 library for ActionScript 3.0.  
 * Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php  
 * By: Jean-Philippe Auclair : http://jpauclair.net  
 * Based on article: http://jpauclair.net/2010/01/09/base64-optimized-as3-lib/ 
 * Benchmark:  
     * This version: encode:  260ms   decode:  255ms 
     * Blog version: encode:  322ms   decode:  694ms 
     * as3Crypto     encode: 6728ms   decode: 4098ms 
     *  
     * Encode: com.sociodox.utils.Base64 is 25.8x faster than as3Crypto Base64 
     * Decode: com.sociodox.utils.Base64 is 16x faster than as3Crypto Base64 
 * 
 * Optimize & Profile any Flash content with TheMiner ( http://www.sociodox.com/theminer ) 
 */  

    import flash.utils.ByteArray;     
    class Base64  
    {     
        private static const _encodeChars:Vector.<int> = InitEncoreChar();  
        private static const _decodeChars:Vector.<int> = InitDecodeChar();  
          
        public static function encode(data:ByteArray):String   
        {     
            var out:ByteArray = new ByteArray();     
            //Presetting the length keep the memory smaller and optimize speed since there is no "grow" needed  
            out.length = (2 + data.length - ((data.length + 2) % 3)) * 4 / 3; //Preset length //1.6 to 1.5 ms  
            var i:int = 0;     
            var r:int = data.length % 3;     
            var len:int = data.length - r;     
            var c:uint;   //read (3) character AND write (4) characters  
            var outPos:int=0;  
            while (i < len)   
            {     
                //Read 3 Characters (8bit * 3 = 24 bits)  
                c = data[i++] << 16 | data[i++] << 8 | data[i++];     
                  
                out[outPos++] = _encodeChars[c >>> 18];  
                out[outPos++] = _encodeChars[c >>> 12 & 0x3f];  
                out[outPos++] = _encodeChars[c >>> 6 & 0x3f];  
                out[outPos++] = _encodeChars[c & 0x3f];       
            }     
              
            if (r == 1) //Need two "=" padding  
            {     
                //Read one char, write two chars, write padding  
                c = data[i];     
  
                out[outPos++] = _encodeChars[c >>> 2];  
                out[outPos++] = _encodeChars[(c & 0x03) << 4];  
                out[outPos++] = 61;  
                out[outPos++] = 61;   
            }     
            else if (r == 2) //Need one "=" padding  
            {     
                c = data[i++] << 8 | data[i];     
  
                out[outPos++] = _encodeChars[c >>> 10];  
                out[outPos++] = _encodeChars[c >>> 4 & 0x3f];  
                out[outPos++] = _encodeChars[(c & 0x0f) << 2];  
                out[outPos++] = 61;   
            }     
  
            return out.readUTFBytes(out.length);     
        }     
          
          
        public static function decode(str:String):ByteArray   
        {     
            var c1:int;     
            var c2:int;     
            var c3:int;     
            var c4:int;     
            var i:int = 0;     
            var len:int = str.length;    
  
            var byteString:ByteArray = new ByteArray();     
            byteString.writeUTFBytes(str);  
            var outPos:int = 0;  
            while (i < len)   
            {     
                //c1  
                c1 = _decodeChars[byteString[i++]];   
                if (c1 == -1) break;     
                  
                //c2         
                c2 = _decodeChars[byteString[i++]];   
                if (c2 == -1) break;      
                  
                byteString[outPos++] = (c1 << 2) | ((c2 & 0x30) >> 4);     
                  
                //c3     
                c3 = byteString[i++];  
                if (c3 == 61)   
                {  
                    byteString.length = outPos  
                    return byteString;     
                }  
                      
                c3 = _decodeChars[c3];     
                if (c3 == -1) break;     
                  
                byteString[outPos++] = ((c2 & 0x0f) << 4) | ((c3 & 0x3c) >> 2);     
                  
                //c4     
                c4 = byteString[i++];  
                if (c4 == 61)   
                {  
                    byteString.length = outPos  
                    return byteString;     
                }  
                  
                c4 = _decodeChars[c4];     
                if (c4 == -1) break;     
                  
                byteString[outPos++] = ((c3 & 0x03) << 6) | c4;     
            }     
            byteString.length = outPos  
            return byteString;     
        }     
          
        public static function InitEncoreChar() : Vector.<int>  
        {  
            var encodeChars:Vector.<int> = new Vector.<int>(64,true);  
              
            // We could push the number directly, but i think it's nice to see the characters (with no overhead on encode/decode)  
            var chars:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";  
            for (var i:int = 0; i < 64; i++)  
            {  
                encodeChars[i] = chars.charCodeAt(i);  
            }  
  
            return encodeChars;  
        }  
          
        public static function InitDecodeChar() : Vector.<int>  
        {  
            var decodeChars:Vector.<int> = new Vector.<int>();  
              
            decodeChars.push(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,     
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,     
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,     
                             52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1,     
                             -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,     
                             15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,     
                             -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,     
                             41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  
                             -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1);  
            return decodeChars;  
        }                 
    }     