/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5CT3
 */

// forked from hebee's forked from: Particle
// forked from xoul's Particle

package 
{
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.Sprite;

    public class dev extends Sprite
    {

        private const NUM_PARTICLES:int = 4000;
        private const NUM_LIGHTS:int = 4000;
        private const MAX_SPEED:Number = 1.5;
        private const MIN_SPEED:Number = 0.5;

        private const WELL_R:Number = 30;// Black Hole radius
        private var WELL_X:Number = 200;// Black Hole X postion
        private var WELL_Y:Number = 300;// Black Hole Y postion

        private var _canvas:BitmapData;
        private var _pixels:Array;
        private var _lights:Array;

        private var _alphaTransform:ColorTransform;
        private var _blurFilter:BlurFilter;

        private var _zeroPoint:Point;

        public function dev()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            WELL_X = stage.stageWidth/2;
            WELL_Y = stage.stageHeight/2;
            
            _blurFilter = new BlurFilter(2,2,1);
            _zeroPoint = new Point  ;

            _canvas = new BitmapData(stage.stageWidth,stage.stageHeight,false,0);
            addChild( new Bitmap( _canvas ) );

            _pixels = new Array();

            for (var i : int = 0; i < NUM_PARTICLES; ++i)
            {
                var pixel:Object = {};
                pixel.x = Math.random() * stage.stageWidth;
                pixel.y = Math.random() * stage.stageHeight;
                pixel.dx = 0;
                pixel.dy = 0;
                pixel.color = 0xFF5555;
                
                var r:Number = Math.random()*100 + 1;
                if (r > 80)
                {
                    pixel.color = 0xFFEE00;
                } else if(r > 30){
                    pixel.color = 0xFF0000;                    
                }


                pixel.speed = ((Math.random()*(100*(MAX_SPEED - MIN_SPEED))) + (100*MIN_SPEED))/100;
                _pixels[i] = pixel;
            }

            _lights = new Array();

            for (var n : int = 0; n < NUM_LIGHTS; ++n)
            {
                var light:Object = {};
                var p:Point = Point.polar(WELL_X+Math.random()*100-50,n);
                light.x = p.x + WELL_X
                light.y = p.y + WELL_Y;
                light.dx = 0;
                light.dy = 0;
                light.color = 0xFFEE00;
                
                if ((Math.random()*100 + 1) > 90)
                {
                    light.color = 0xEE3300;
                }
                
                light.speed = ((Math.random()*(100*(MAX_SPEED - MIN_SPEED))) + (100*MIN_SPEED))/100;
                _lights[n] = light;
            }

            addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }

        private function onEnterFrame( e : Event ):void
        {
            _canvas.lock();

            var fade:Number = 5;
            
            while (fade --)
            {
                _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);
            }

            var pixel:Object;
            var angle:Number;
            var distance_well:Number;
            var distance_mouse:Number;

            for (var n : int = 0; n < NUM_LIGHTS; ++n)
            {
                pixel = _lights[n];

                angle = Math.atan2(pixel.y - WELL_Y,pixel.x - WELL_X);

                distance_well = getAbs(Math.sqrt((pixel.x - WELL_X) * (pixel.x - WELL_X) + (pixel.y - WELL_Y) * (pixel.y - WELL_Y)));
                if ((Math.random()*WELL_R*2+WELL_R) < distance_well || (Math.random()*100 + 1) > 80)
                {
                    pixel.dx -=  pixel.speed * Math.cos(angle);
                    pixel.dy -=  pixel.speed * Math.sin(angle);
                    
                    pixel.dy *= (Math.random()*50)/100 + .5;
                    pixel.dx *= (Math.random()*50)/100 + .5;
                   
                    pixel.x +=  pixel.dx;
                    pixel.y +=  pixel.dy;
                }
                else
                {
                    var p:Point = Point.polar(WELL_X+Math.random()*100-50,n);
                    pixel.x = p.x + WELL_X
                    pixel.y = p.y + WELL_Y;
                }
                
                _canvas.setPixel(pixel.x,pixel.y,pixel.color);
            }

            _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);

            for (var i : int = 0; i < NUM_PARTICLES; ++i)
            {
                pixel = _pixels[i];

                distance_well = getAbs(Math.sqrt((pixel.x - WELL_X) * (pixel.x - WELL_X) + (pixel.y - WELL_Y) * (pixel.y - WELL_Y)));
                distance_mouse = getAbs(Math.sqrt((pixel.x - mouseX) * (pixel.x - mouseX) + (pixel.y - mouseY) * (pixel.y - mouseY)));

                // Random in there so some of the pixels should be sucked!
                if (distance_well > distance_mouse && (Math.random()*100 + 1) > 10)
                {
                    angle = Math.atan2(pixel.y - mouseY,pixel.x - mouseX);
                }
                else
                {
                    angle = Math.atan2(pixel.y - WELL_Y,pixel.x - WELL_X);
                }

                if ((Math.random()*WELL_R*2+WELL_R/2) < distance_well)
                {
                    pixel.dx -=  pixel.speed * Math.cos(angle);
                    pixel.dy -=  pixel.speed * Math.sin(angle);
                    
                    pixel.dy *= (Math.random()*80)/100 + .5;
                    pixel.dx *= (Math.random()*80)/100 + .5;
                    
                    pixel.x +=  pixel.dx;
                    pixel.y +=  pixel.dy;
                }
                else
                {
                    pixel.x = mouseX;
                    pixel.y = mouseY;
                }

                _canvas.setPixel(pixel.x,pixel.y,pixel.color);
            }

            _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);
            _canvas.unlock();
        }

        private function getAbs( x : Number ):Number
        {
            return x < 0 ? -x : x;
        }
    }
}