/**
 * Copyright chez_sugi ( http://wonderfl.net/user/chez_sugi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5C9I
 */

// forked from chez_sugi's forked from: Stage3D test03
// forked from sakef's Stage3D test03
package {
    // AGALプログラム文字列をバイトコード仕様に変換する＆射影変換計算に利用する
    import com.adobe.utils.AGALMiniAssembler;
    import com.adobe.utils.PerspectiveMatrix3D;
    
    import flash.display.Sprite;
    import flash.display.Stage3D;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DProgramType;
    import flash.display3D.Context3DTriangleFace;
    import flash.display3D.Context3DVertexBufferFormat;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.VertexBuffer3D;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    
    [SWF(backgroundColor="#000000")]
    public class Main extends Sprite
    {    
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        private const PLANE:int = 120;
        private const CAMERA_RADIUS:int=500;
        private const RADIAN:Number= Math.PI/180;
        private const VECTOR_ZERO:Vector3D = new Vector3D();
        private var stage3d:Stage3D;
        private var ctx:Context3D;
        private var indexBuffer:IndexBuffer3D;
        
        private var modelMatrix:Matrix3D;
        private var viewMatrix:Matrix3D;
        private var rotX:Number;
        private var rotCamera:Number;
        
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;
            stage.frameRate = 60;
            
            // stage3D取得
            stage3d = stage.stage3Ds[0];
            // イベントリスナの追加
            stage3d.addEventListener(Event.CONTEXT3D_CREATE, onContext3DCreate);
            // Context3D のインスタンスが初期化
            stage3d.requestContext3D();
        }
        
        private function onContext3DCreate(e:Event):void 
        {
            // Context3Dの取得
            ctx = Stage3D(e.target).context3D;
            // 表示バッファの初期化
            ctx.configureBackBuffer(WIDTH, HEIGHT, 2, true);
            ctx.enableErrorChecking = true;
            ctx.setCulling(Context3DTriangleFace.NONE);
            // x, y, z, r, g, b, a のフォーマットで頂点情報＆色情報を指定
            var vertices:Vector.<Number> = new <Number>[
                -PLANE/2, -PLANE/2, 0.0,   1.0, 0.0, 0.0, 1.0, 
                -PLANE/2,  PLANE/2, 0.0,    0.0, 1.0, 0.0, 1.0,
                PLANE/2, PLANE/2, 0.0,    0.0, 0.0, 1.0, 1.0,
                PLANE/2, -PLANE/2, 0.0,    0.0, 1.0, 1.0, 1.0
            ];
            // 7つの値を持つ3つの頂点用の頂点バッファを作成
            var vb:VertexBuffer3D = ctx.createVertexBuffer(4, 7);
            // 上で定義したverticesの全データをアップロード
            vb.uploadFromVector(vertices, 0, 4);
            ctx.setVertexBufferAt(0, vb, 0, Context3DVertexBufferFormat.FLOAT_3);
            ctx.setVertexBufferAt(1, vb, 3, Context3DVertexBufferFormat.FLOAT_4);
            // 頂点インデックスの指定
            var indices:Vector.<uint> = new <uint>[0,1,2,  2,3,0];
            // GPUにインデックスバッファを取得
            indexBuffer = ctx.createIndexBuffer(6);
            // 上で定義したindexDataの全データをアップロード
            indexBuffer.uploadFromVector(indices, 0, 6);
            //コンパイルされたシェーダを GPUにアップロードするクラス
            var program:Program3D = ctx.createProgram();
            //頂点シェーダ
            var vertexPrg:String = "m44 vt0, va0, vc8\n" + "m44 vt1, vt0, vc4\n" + "m44 op,  vt1, vc0\n" + "mov v0,  va1";
            //断片シェーダ
            var fragmentPrg:String = "mov oc, v0";
            // 頂点シェーダと断片シェーダのコードをアップロード
            var assembler:AGALMiniAssembler = new AGALMiniAssembler();
            program.upload(
                assembler.assemble(Context3DProgramType.VERTEX, vertexPrg), 
                assembler.assemble(Context3DProgramType.FRAGMENT, fragmentPrg)
            );
            ctx.setProgram(program);
            
            // 射影変換用行列の初期化
            var perspectiveMatrix:PerspectiveMatrix3D = new PerspectiveMatrix3D;
            perspectiveMatrix.identity();
            perspectiveMatrix.perspectiveFieldOfViewLH( 35*RADIAN, WIDTH/HEIGHT, 10, 1000);  
            ctx.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, perspectiveMatrix,true);
            
            // モデル・ビュー行列の初期化　その他諸々
            modelMatrix = new Matrix3D;
            viewMatrix = new Matrix3D;
            rotCamera = rotX = 0;
            
            addEventListener(Event.ENTER_FRAME, onFrame);
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
        }
        
        // フレームイベント
        private function onFrame(e:Event=null):void
        {
            // モデル
            rotX += 3;
            modelMatrix.identity();
            modelMatrix.appendRotation(rotX,Vector3D.X_AXIS);
            ctx.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX,8, modelMatrix,true);
            
            // ビュー
            rotCamera ++;
            viewMatrix.identity();
            viewMatrix.appendTranslation(CAMERA_RADIUS*Math.sin(rotCamera*RADIAN),0,-CAMERA_RADIUS*Math.cos(rotCamera*RADIAN));
            viewMatrix.pointAt(VECTOR_ZERO, Vector3D.Z_AXIS, Vector3D.Y_AXIS);
            viewMatrix.invert();
            ctx.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 4, viewMatrix, true);
            
            // 描画
            ctx.clear();
            ctx.drawTriangles(indexBuffer,0,-1);
            ctx.present();
        }
        
        // リサイズイベント
        private function onResize(e:Event=null):void
        {
            if(stage3d)
            {
                stage3d.x = (stage.stageWidth - WIDTH) / 2;
                stage3d.y = (stage.stageHeight - HEIGHT) / 2;
            }
        }
    }
}