/**
 * Copyright a24 ( http://wonderfl.net/user/a24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5C5f
 */

//
// っぽいものをつくってみた
// 赤と青のメガネのやつをかけて見てみてね
//
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	
	[SWF(backgroundColor="#FFFFFF", frameRate=60)]
	
	public class Main extends MovieClip
	{
		private var anags:Array = new Array();
		private var circle:CircleRotation;
		
		public function Main() 
		{
			circle = new CircleRotation();
			circle.blur = 8;
			
			for (var i:int = 0; i < 10; i++) 
			{
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill(0x333333);
				sp.graphics.drawRect( -35, -35, 70, 70);
				var anag:Anaglyph = new Anaglyph(sp, 0);
				addChild(anag);
				circle.addObject(anag);
				anags.push(anag);
			}
			
			circle.init(233, 210, 150, 80);
			
			addEventListener(Event.ENTER_FRAME, updateDepth);
		}
		
		private function updateDepth(e:Event):void 
		{
			circle.angle ++;
			
			for (var i:int = 0; i < anags.length; i++) 
				anags[i].depth = (anags[i].y - 233) / 10;
		}
	}
}



import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.filters.ColorMatrixFilter;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;

class Anaglyph extends Sprite
{
	private const COLOR_BLUE:uint = 0x08FCFA;
	private const COLOR_RED:uint = 0xFB0200;
	
	private var _target:DisplayObject;
	private var _depth:Number;
	private var _blueImage:Bitmap;
	private var _redImage:Bitmap;
	private var _targetImage:Bitmap;
	
	
	public function Anaglyph(target:DisplayObject, depth:Number ) 
	{
		_target = target;
		_depth = depth;
		
		_targetImage = getCapture(_target);
		addChild(_targetImage);
		
		var blueBmd:BitmapData = convertColorTone(COLOR_BLUE);
		_blueImage = new Bitmap(blueBmd);
		_blueImage.blendMode = "multiply";
		_blueImage.alpha = 0.6;
		addChild(_blueImage);
		
		var redBmd:BitmapData = convertColorTone(COLOR_RED);
		_redImage = new Bitmap(redBmd);
		_redImage.blendMode = "multiply";
		_redImage.alpha = 0.6;
		addChild(_redImage);
		
		x = _target.x;
		y = _target.y;
		
		updateDepth();
	}
	
	private function convertColorTone(color:uint):BitmapData
	{
		var bmd:BitmapData = getCaptureData(_target, false);
		var rgb:Object = getRGB(color);
		var gray:Number = 1 / 3 / 255 * 5;
		var filter:ColorMatrixFilter = new ColorMatrixFilter
			(
				[gray * rgb.r, gray * rgb.r, gray * rgb.r, 0, 0,
				 gray * rgb.g, gray * rgb.g, gray * rgb.g, 0, 0,
				 gray * rgb.b, gray * rgb.b, gray * rgb.b, 0, 0,
				 0              ,0              ,0               ,0 , 0]
			);
			
		bmd.applyFilter(bmd, bmd.rect, new Point(0, 0), filter);
		return bmd;
	}
	
	private function updateDepth():void
	{
		var rect:Rectangle = _target.getRect(_target);
		_blueImage.x = depth + rect.left;
		_redImage.x = -depth + rect.top;
		_targetImage.x = rect.left;
	}
	
	public function getCapture( target:DisplayObject , transparent:Boolean = true , bgColor:uint = 0xFFFFFF ):Bitmap
	{
		return new Bitmap( getCaptureData( target , transparent , bgColor ) );
	}
	
	public function getCaptureData( target:DisplayObject , transparent:Boolean = true , bgColor:uint = 0x00FFFFFF ):BitmapData
	{
		var bmpData:BitmapData = new BitmapData( target.width , target.height , transparent , bgColor );
		var rect:Rectangle = target.getBounds( target );
		var mtx:Matrix = new Matrix();
		mtx.translate(-rect.left, -rect.top);
		bmpData.draw( target , mtx );
		return bmpData;
	}
	
	public function getRGB( color:uint ):Object
	{
		return { r : color >> 16 & 0xFF , g : color >> 8 & 0xFF , b : color & 0xFF };
	}
	
	public function get depth():Number { return _depth; }
	public function set depth(value:Number):void 
	{
		_depth = value;
		updateDepth();
	}
}



import flash.display.DisplayObject;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;

class CircleRotation extends EventDispatcher
{
	private var _objs:Array;
	private var _sort:Array;
	private var _centerX:Number;
	private var _centerY:Number;
	private var _cirW:Number;
	private var _cirH:Number;
	private var _angle:Number;
	
	private var _blur:Number = 8;
	
	public function CircleRotation() 
	{
		_objs = new Array();
		_sort = new Array();
	}
	
	public function addObject( object:DisplayObject ):void
	{
		_objs.push( object );
		_sort.push( object );
	}
	
	public function init( centerX:Number , centerY:Number , width:Number , height:Number ):void
	{
		_centerX = centerX;
		_centerY = centerY;
		_cirW = width;
		_cirH = height;
		
		_angle = 0;
		updata();
	}
	
	private function updata():void
	{
		var num:int = _objs.length;
		var ang:Number = 360 / num;
		var target:DisplayObject;
		
		for ( var i:int = 0; i < num; i ++ )
		{
			target = _objs[ i ];
			var targetAngle:Number = _angle + ang * i;
			target.x = _centerX + _cirW * Math.cos( targetAngle * Math.PI / 180 );
			target.y = _centerY + _cirH * Math.sin( targetAngle * Math.PI / 180 );
			
			target.scaleX = target.scaleY = ( target.y + _cirH - _centerY ) / ( _cirH * 2 ) * 0.4 + 0.6;
			target.filters = [ new BlurFilter( ( 1 - target.scaleX ) * _blur , ( 1 - target.scaleY ) * _blur )];
		}
		
		_sort.sortOn( "y" , Array.NUMERIC );
		
		for ( var j:int = 0; j < num; j ++ )
		{
			target = _sort[ j ];
			target.parent.setChildIndex( target , j );
		}
	}
	
	public function get angle():Number { return _angle; }
	public function set angle( value:Number ):void 
	{
		_angle = value;
		updata();
	}
	
	public function get blur():Number { return _blur; }
	public function set blur(value:Number):void 
	{
		_blur = value;
	}
}