/**
 * Copyright producerism ( http://wonderfl.net/user/producerism )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5BNK
 */

package
{   
    import flash.display.Sprite;
    
    public class SlotMachine extends Sprite {

        private var _credits:uint = 4; // start with $20
        
        private var _slotReel1:SlotReel;
        private var _slotReel2:SlotReel;
        private var _slotReel3:SlotReel;
        
        public function SlotMachine()
        {   
            
            //This is all the initialization you need in your main class
            inittrace(stage);
            
            _slotReel1 = new SlotReel();
            _slotReel2 = new SlotReel();
            _slotReel3 = new SlotReel();
            
            spinReels();
            spinReels();
            spinReels();
            spinReels();
        }
        
        private function spinReels():void
        {
            if (_credits)
            {
                _credits--; // costs $1 per spin
                
                _slotReel1.spin();
                _slotReel2.spin();
                _slotReel3.spin();
                
                // check for matches
                if (_slotReel1.value == _slotReel2.value && _slotReel1.value == _slotReel3.value)
                {
                    trace("win!");
                    _credits += 1000;
                }
                else if (_slotReel1.value == _slotReel2.value)
                {
                    _slotReel1.hold = true;
                    _slotReel2.hold = true;
                }
                else if (_slotReel1.value == _slotReel3.value)
                {
                    _slotReel1.hold = true;
                    _slotReel3.hold = true;
                }   
                else if (_slotReel2.value == _slotReel3.value)
                {
                    _slotReel2.hold = true;
                    _slotReel3.hold = true;
                }
                
                trace(_slotReel1.value + " " + _slotReel2.value + " " + _slotReel3.value+" credits left: "+_credits);
            } else {
                trace("out of credits!");
            }
            
        }
        
    }   
}

import flash.display.MovieClip;

class SlotReel extends MovieClip {

    private var _numberOfSlotFrames:uint = 12;
    private var _currentSlotFrame:uint;
    public var hold:Boolean;
    
    public function SlotReel(){ super(); }

    public function spin():void
    {
        if (!hold)
        {
            _currentSlotFrame = Math.round(Math.random() * (_numberOfSlotFrames- 1) + 1);
            gotoAndStop(_currentSlotFrame);
        }
    }
    
    public function get value():uint { return _currentSlotFrame; }
}

/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}