/**
 * Copyright plankton ( http://wonderfl.net/user/plankton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ANy
 */

// forked from natehorstmann's RecursiveSpiral
package 
{
	import flash.display.Shape;	
	import flash.display.Graphics;
    import flash.display.Sprite;
    public class RecursiveSpiral extends Sprite {
		
		// getting stack overflow if this is too high
		private const MAX_RECURSIONS :int = 1000;
		
		public function RecursiveSpiral() {
            
            var spiral : Shape = new Shape();
			spiral.x = stage.stageWidth * 0.5;
            spiral.y = stage.stageHeight * 0.5;
            spiral.graphics.lineStyle(1);
            addChild(spiral);
            
            var numRevolutions : Number = 10;
            var radius : Number = 200;
           	
            drawSpiral(spiral.graphics, int(360 * numRevolutions), radius);
            
        }
        
        private function drawSpiral(g:Graphics, degrees : int, radius : Number, rate :Number = 0, resolution : int = 0) : void
        {
			if (degrees > 0) 
    		{
    			var rad : Number = degrees * Math.PI/180;
    			radius -= resolution*rate;
	        	
	        	if (rate == 0 )
	        	{ 	
	        		rate = radius/degrees;
	        		resolution = int(degrees/MAX_RECURSIONS);
	        		g.moveTo(radius*Math.cos(rad), radius*Math.sin(rad));
	        	}
	        	
				g.lineTo(radius*Math.cos(rad), radius*Math.sin(rad));
				
				degrees -= resolution;
				drawSpiral(g, degrees, radius, rate, resolution);
    		}
        }
    }
}