/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/58aB
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var prev:Point = new Point();
		private var preview:Sprite;
 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			addChild(new Bitmap(bd));
 
			preview = new Sprite();
			addChild(preview);
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			preview.graphics.clear();
			preview.graphics.lineStyle(1.0, 0x9F9F9F);
			preview.graphics.moveTo(prev.x, prev.y);
			preview.graphics.lineTo(mouseX, mouseY);
 
			preview.graphics.lineStyle(1.0, 0x7F7F7F);
			preview.graphics.beginFill(0xFFFFFF);
			preview.graphics.drawCircle(prev.x, prev.y, 3);
			preview.graphics.drawCircle(mouseX, mouseY, 3);
			preview.graphics.endFill();
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			preview.graphics.clear();
			preview.graphics.lineStyle(8.0, 0x0);
			preview.graphics.moveTo(prev.x, prev.y);
			preview.graphics.lineTo(mouseX, mouseY);
 
			bd.draw(preview);
 
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
