/**
 * Copyright chomo ( http://wonderfl.net/user/chomo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/58R3
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {

import mx.core.UIComponent;
import com.jumpeye.Events.FLASHEFFEvents;
import com.jumpeye.flashEff2.text.glow.FETGlow;
import com.jumpeye.flashEff2.text.bubbles.FETBubbles;

//フォントの埋め込み
[Embed(source = "BAUHS93.TTF",fontName = "Bauhaus 93",mimeType = 'application/x-font')]
private var Font_Bauhaus:Class;

//初期化関数
private function init():void{
	
	//textの作成。TextFieldでないとエフェクトが動作しない。
	var ctxt:String = "hogeho\ngeho asdlfjaslkdjfalksdjf jaslkdjfalksjaslkdjfalksjaslkdjfalks jaslkdjfalks jaslkdjfalks alskjdfalksjd http://d.hatena.ne.jp/haru-komugi/";
	var txt:TextField = new TextField();
	var tf:TextFormat = new TextFormat();
	tf.font = "Bauhaus 93";
	tf.size = 30;
	tf.color = 0xffffff;
	tf.align = "center";
	txt.defaultTextFormat = tf;
	txt.mouseEnabled = false;
	txt.antiAliasType = "advanced"
	txt.type = "dynamic";
	txt.multiline = true;
	txt.wordWrap = true;
	txt.width = 300;
	txt.height = 8000;
	txt.embedFonts = true;  
	txt.autoSize = TextFieldAutoSize.CENTER;
	//txt.border = true;           // デバック時確認用
	txt.text = ctxt;
	txt.x = 200;
	txt.y = 100;

	//ステージにtextを追加
	var ui:UIComponent = new UIComponent();
	ui.addChild(txt);
	addChild(ui);
	
	//エフェクト処理
	var fe:FlashEff2Flex = new FlashEff2Flex();
	fe.addEventListener(FLASHEFFEvents.TRANSITION_END , restargShowEffect);
	this.addChild(fe);
	fe.target =txt;

	//hideEffect
	var pattern0:FETGlow = new FETGlow();
	pattern0.preset=27;
	pattern0.color=3381759;
	pattern0.maxGlow=2;
	pattern0.maxBlurX=3;
	pattern0.maxBlurY=15;
	pattern0.alphaPercentage=10;
	pattern0.groupDuration=0.5;
	pattern0.partialGroup='letters';
	pattern0.partialPercent=100;
	pattern0.partialBlurAmount=0;
	pattern0.partialStart=50;
	pattern0.tweenDuration=1;
	pattern0.tweenType='Quadratic';
	pattern0.easeType='easeOut';
	fe.hideTransition=pattern0

	//showEffect	
	var pattern1:FETBubbles = new FETBubbles();
	pattern1.preset=9;
	pattern1.distance=50;
	pattern1.sinusSize=6;
	pattern1.numberOfSinusoids=3;
	pattern1.speedBlurAmount=2;
	pattern1.alphaPercentage=32;
	pattern1.blurQuality=2;
	pattern1.groupDuration=1;
	pattern1.partialGroup='letters';
	pattern1.partialPercent=100;
	pattern1.partialBlurAmount=0;
	pattern1.partialStart=50;
	pattern1.tweenDuration=1.5;
	pattern1.tweenType='Back';
	pattern1.easeType='easeInOut';
	fe.showTransition=pattern1;
}

//エフェクト終了イベント
private function restargShowEffect(evt:FLASHEFFEvents):void{
	var effectInstance:FlashEff2Flex = evt.target as FlashEff2Flex;
	if( effectInstance.currentTransitionType == "hide" ){
		effectInstance.show();
	}
}

        
    }
}