/**
 * Copyright toyoshim ( http://wonderfl.net/user/toyoshim )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/56ij
 */

//
// PV3DのPrimitiveを使ってシューティングの自機っぽい物を作ってみた
//
package {
    import flash.events.Event;
    import flash.events.KeyboardEvent;

    import org.papervision3d.view.BasicView;
    import com.flashdynamix.utils.SWFProfiler;

    public class Ship1 extends BasicView
    {
        private var key:int = 0;
        private var ship:MyShip;
        private var bullets:Bullets;

        public function Ship1()
        {
            //Wonderfl.disable_capture();
            SWFProfiler.init(this);
            
            stage.frameRate = 60;

            bullets = new Bullets(scene);

            ship = new MyShip(bullets, scene);

            startRendering();

            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP  , keyUp  );
        }

        override protected function onRenderTick(e:Event=null):void
        {
            ship.move(key);
            bullets.move();
            super.onRenderTick();
            key = (key << 16) | (key & 0xffff);
        }

        private function keyDown(e:KeyboardEvent):void
        {
            switch (e.keyCode) {
            case 0x20: key |= 0x10; break; // S
            case 0x25: key |= 0x08; break; // L
            case 0x26: key |= 0x04; break; // U
            case 0x27: key |= 0x02; break; // R
            case 0x28: key |= 0x01; break; // D
            }
        }

        private function keyUp(e:KeyboardEvent):void
        {
            switch (e.keyCode) {
            case 0x20: key &= ~0x10; break; // S
            case 0x25: key &= ~0x08; break; // L
            case 0x26: key &= ~0x04; break; // U
            case 0x27: key &= ~0x02; break; // R
            case 0x28: key &= ~0x01; break; // D
            }
        }
    }
}

import org.papervision3d.scenes.Scene3D;
import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.objects.primitives.PaperPlane;
import org.papervision3d.objects.primitives.Sphere;

class MyShip
{
    private var do3d:PaperPlane;
    private var bullets:Bullets;
    private var scene:Scene3D;
    private var lopt:PaperPlane;
    private var ropt:PaperPlane;
    private var optv:int = 30;
    private var tick:int = 0;

    public function MyShip(_bullets:Bullets, _scene:Scene3D)
    {
        bullets = _bullets;
        scene = _scene;

        do3d = new PaperPlane();
        do3d.localRotationX = 90;
        do3d.y = -400;
        do3d.scale = 0.8;
        scene.addChild(do3d);

        lopt = new PaperPlane();
        lopt.localRotationX = 90;
        lopt.y = -480;
        lopt.x = do3d.x - 100;
        lopt.scale = 0.3;
        scene.addChild(lopt);

        ropt = new PaperPlane();
        ropt.localRotationX = 90;
        ropt.y = -480;
        ropt.x = do3d.x + 100;
        ropt.scale = 0.3;
        scene.addChild(ropt);
    }

    public function move(key:int):void
    {
        var key_edge: int = (key >> 16) ^ key;
        tick++;
        if (0x08 & key) {
            do3d.x -= 3;
            if (-20 < do3d.localRotationZ) do3d.localRotationZ--;
        }
        if (0x02 & key) {
            do3d.x += 3;
            if (do3d.localRotationZ < +20) do3d.localRotationZ++;
        }
        if ((0x00 == (0x0a & key)) || (0x0a == (0x0a & key))) {
            if (do3d.localRotationZ > 0) do3d.localRotationZ--;
            if (do3d.localRotationZ < 0) do3d.localRotationZ++;
        }
        if (0x10 & key) {
            var s:Number = 2.0 * Math.PI * lopt.localRotationY / 1200;
            var sy:Number = Math.cos(s) * 2048;
            var sx:Number = Math.sin(s) * 2048;
            bullets.generate(lopt.x, lopt.y, -sx, sy);
            bullets.generate(ropt.x, ropt.y,  sx, sy);
            if (0 == (tick & 3)) {
                var y:int = Math.cos(Math.PI / 32.0) * 2048;
                var x:int = Math.sin(Math.PI / 32.0) * 2048;
                bullets.generate(do3d.x -  20, do3d.y, -x,    y);
                bullets.generate(do3d.x +  20, do3d.y, +x,    y);
                bullets.generate(do3d.x -  20, do3d.y,  0, 2048);
                bullets.generate(do3d.x +  20, do3d.y,  0, 2048);
            }
        }
        lopt.x += (do3d.x - 100 - lopt.x) / 8;
        ropt.x += (do3d.x + 100 - ropt.x) / 8;
        if ((optv > 0) && (lopt.localRotationY > 200)) optv = -50;
        if ((optv < 0) && (lopt.localRotationY <   0)) optv =  50;
        lopt.localRotationY += optv;
        ropt.localRotationY -= optv;
    }
}

class Bullet
{
    private var x:int;
    private var y:int;
    private var ax:int;
    private var ay:int;
    private var obj:Sphere;

    protected var next:Bullet;
    protected var prev:Bullet;

    public function Bullet(_ax:int, _ay:int, _obj:Sphere)
    {
        ax = _ax;
        ay = _ay;
        obj = _obj;
        x = obj.x << 8;
        y = obj.y << 8;
        next = null;
        prev = null;
    }

    public function move():void
    {
        x += ax;
        y += ay;
        obj.x = (x >> 8);
        obj.y = (y >> 8);
        obj.localRotationX += (ay >> 8);
        obj.localRotationY += (ax >> 8);
    }

    public function isOnScreen():Boolean
    {
        return (obj.y < 600) && (obj.x > -600) && (obj.x < 600);
    }

    public function getDO3D():Sphere
    {
        return obj;
    }

    public function remove():void
    {
        if (null != prev) prev.next = next;
        if (null != next) next.prev = prev;
    }

    public function appendItem(item:Bullet):void
    {
        next = item;
        if (null != item) item.prev = this;
    }

    public function nextItem():Bullet
    {
        return next;
    }
}

class Bullets
{
    private var scene:Scene3D;
    private var top_bullet:Bullet;

    public function Bullets(_scene:Scene3D)
    {
        scene = _scene;
    }

    public function generate(x:int, y:int, ax:int, ay:int):void
    {
        var sphere:Sphere = new Sphere(null, 10, 2, 2);
        sphere.x = x;
        sphere.y = y;
        scene.addChild(sphere);
        var bullet:Bullet = new Bullet(ax, ay, sphere);
        bullet.appendItem(top_bullet);
        top_bullet = bullet;
    }

    public function move():void
    {
        var bullet:Bullet;

        for (bullet = top_bullet; null != bullet; bullet = bullet.nextItem()) {
            bullet.move();
            if (!bullet.isOnScreen()) {
                if (top_bullet == bullet) top_bullet = bullet.nextItem();
                bullet.remove();
                scene.removeChild(bullet.getDO3D());
            }
        }
    }
}
