/**
 * Copyright soh1106c ( http://wonderfl.net/user/soh1106c )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/56i3
 */

package {
    import flash.events.*;
    import flash.events.MouseEvent;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.utils.*;
    
    public class Main extends BasicView{
        public function Main(){
            var material:WireframeMaterial=new WireframeMaterial(0x0000ff);
            var cylinder:Cylinder=new Cylinder(material,200,400);
            scene.addChild(cylinder);
            
            var normal:Number3D=new Number3D(0,0.5,0);
            var point:Number3D=new Number3D(0,0,0);
            var cutPlane:Plane3D=Plane3D.fromNormalAndPoint(normal,point);
            
            var meshes:Array=MeshUtil.cutTriangleMesh(cylinder,cutPlane);
            
            var mesh0:TriangleMesh3D=meshes[0];
            scene.addChild(mesh0);
            mesh0.x=-500;
            
            var mesh1:TriangleMesh3D=meshes[1];
            scene.addChild(mesh1);
            mesh1.x=0;
    
            startRendering();
            
            addEventListener(Event.ENTER_FRAME,loop);
            }
            
       private function loop(e:Event):void {
            var rot:Number=(mouseX/stage.stageWidth)*720;
            camera.x=1000*Math.sin(rot*Math.PI/180);
            camera.z=1000*Math.cos(rot*Math.PI/180);
            camera.y=1000*(mouseY/stage.stageHeight);
        }
        }
}