/**
 * Copyright yurij.shaulov ( http://wonderfl.net/user/yurij.shaulov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/56Vv
 */

// forked from kataribe's flash on 2015-1-26
//WASDで移動
//左クリックでカーソルの位置に発砲
package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(width="465", height="465", backgroundColor="#000000", frameRate="60")]
    public class FlashTest extends Sprite {
        public var mouse:Boolean = false;
        public var key:Vector.<Boolean> = new Vector.<Boolean>(512, false);
        public var hito:Hito = new Hito(stage.stageWidth/2, stage.stageHeight-stage.stageHeight/3);
        public var tama:Node;
        //public var debug:TextField = new TextField();
        
        /* コンストラクタ */
        public function FlashTest() {
            //addChild(debug);
            addChild(hito);
            addEventListener(Event.ENTER_FRAME, main);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, on_keydown);
            stage.addEventListener(KeyboardEvent.KEY_UP, on_keyup);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, on_mouse);
        }
        
        /* メインループ */
        public function main(e:Event):void{
            //弾の処理
            if(tama){
                tama.x+=tama.vx;
                tama.y+=tama.vy;
                if(tama.x<0 || stage.stageWidth<tama.x || tama.y<0 || stage.stageHeight<tama.y){
                    removeChild(tama);
                    tama = null;
                }
            }
            
            //加速
            if(key[65]){                     //左:A
                if(-5 < hito.vx)hito.vx-=0.5;
            }if(key[68]){                    //右:D
                if(hito.vx < 5)hito.vx+=0.5;
            }if(key[87]){                    //上:W:
                if(-5 < hito.vy)hito.vy-=0.5;
            }if(key[83]){                    //下:S:
                if(hito.vy < 5)hito.vy+=0.5;
            }
            hito.x += hito.vx;
            hito.y += hito.vy;
            
            //減速
            if(hito.vx){
                hito.vx *= 0.9;
                if(Math.abs(hito.vx)<0.01)hito.vx = 0;
            }if(hito.vy){
                hito.vy *= 0.9;
                if(Math.abs(hito.vy)<0.01)hito.vy = 0;
            }
            
            /* カーソルの方向を向く */
            var angle:Number = Math.atan2(stage.mouseY-hito.y, stage.mouseX-hito.x);
            hito.rotation = angle*180/Math.PI+90;
        }
        
        /* キーダウン */
        public function on_keydown(e:KeyboardEvent):void{
            key[e.keyCode] = true;
        }
        
        /* キーアップ */
        public function on_keyup(e:KeyboardEvent):void{
            key[e.keyCode] = false;
        }
        
        /* マウスダウン */
        public function on_mouse(e:MouseEvent):void{
            if(!tama){
                tama = new Node(hito.x, hito.y, 4, 0x880000);
                addChild(tama);
                var angle:Number = Math.atan2(e.stageY-hito.y, e.stageX-hito.x);
                tama.vx = Math.cos(angle)*5;
                tama.vy = Math.sin(angle)*5;
            }
        }
    }
}

import flash.display.Shape;

/* 物 */
internal class Node extends Shape{
    public var vx:Number = .0;
    public var vy:Number = .0;
    
    /* コンストラクタ */
    public function Node(x:Number, y:Number, size:uint, color:uint){
        this.x = x;
        this.y = y;
        graphics.beginFill(color);
        graphics.lineStyle(2);
        graphics.drawCircle(0, 0, size);
        graphics.endFill();
    }
    
}

/* 人 */
class Hito extends Node{
    /* コンストラクタ */
    public function Hito(x:Number, y:Number){
        super(x, y, 16, 0xFF0000);
        graphics.beginFill(0xFF0000);
        graphics.moveTo(0, -30);
        graphics.lineTo(-7, -23);
        graphics.lineTo(7, -23);
        graphics.endFill();
    }
}
