/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/56Nw
 */

// forked from chutaicho's Grid Motion
/**
グリッド分割うねうね
*/
package 
{
    import __AS3__.vec.Vector;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    [SWF(frameRate = "40", backgroundColor = "#000000")]
    public class GridMotion extends Sprite 
    {
        private const IMAGE_URL:String = "http://www.chutaicho.com/image/003.jpg";
        
		private const SW:int = 465;
		private const SH:int = 465;
                private const SPEED:int = 2;
		private const OCTAVES:int = 2;
		private const GRID:int = 31;
		private const RECT:Rectangle = new Rectangle(0, 0, 15, 15);
        
		private var _canvas:BitmapData;
		private var _drawImage:BitmapData; 
        private var _shapes:Vector.<Sprite>;
        private var _seed:Number;
        private var _offset:Array;
		
        public function GridMotion()
        {
            init();
        }
       	
        private function init():void
        {
            var req:URLRequest = new URLRequest(IMAGE_URL);
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);    
            loader.load( req, new LoaderContext(true));
        }
        private function loadComplete(e:Event = null):void
        {
            e.target.removeEventListener(Event.COMPLETE, loadComplete);
            var sp:Sprite = new Sprite();
            var bm:Bitmap = e.target.loader.content as Bitmap;
            bm.width = SW;
            bm.height = SH;
            sp.addChild(bm);
            
            _drawImage = new BitmapData(SW,SH,true,0);
            _drawImage.draw(sp);
            
            _seed = Math.floor( Math.random() * 0xFFFF );
            _offset = [new Point(), new Point()];
            
            _shapes = new Vector.<Sprite>();
            
            var j:int = GRID;
            while(j--) 
            {
                var i:int = GRID;
                while (i--) 
                {
                    var shape:Sprite = new Sprite();
                    shape.x = j * 15;
                    shape.y = i * 15;
                    drawShape(shape);          
                    addChild( shape );
                    _shapes.push(shape);
                } 
            
            }
            
            _canvas = new BitmapData(233,233,false,0x000000);
            createNoise();
            addEventListener(Event.ENTER_FRAME, createNoise);
            
        }
        private function drawShape(shape:Sprite):void
        {
            var drawPart:BitmapData = new BitmapData(12,12,false);// ちょっと小さく
            var colors:uint = _drawImage.getPixel(shape.x,shape.y);
            for(var i:int = 0; i < GRID; i++)
            {
                var px:int = shape.x + i;                                 
                for(var j:int = 0; j < GRID; j++)
                {
                    var py:int = shape.y + j;
                    var color:uint = _drawImage.getPixel(px,py);
                    drawPart.setPixel( i, j, color);
                } 
            }
            var bm:Bitmap = new Bitmap(drawPart,"auto",true);
            bm.x = -7.5;
            bm.y = -7.5;
            shape.addChild( bm );
        }
        
        
		private function createNoise(e:Event = null):void
		{
            _offset[0].x += SPEED;
            _offset[0].y += SPEED;
            _offset[1].x -= SPEED;
            _offset[1].y -= SPEED;
            
		    _canvas.perlinNoise(117, 117, 1, _seed, false, true, 2, false, _offset);
		    
		    var shape:Sprite;
		    var l:int = _shapes.length;
		    for (var i:Number = 0; i < l; i++)
		    {
		        shape = _shapes[i];		        
		        var status:uint = _canvas.getPixel(shape.x >> 1, shape.y >> 1);
		        var num:Number = ((status >> 8 & 0xff) - 0x00);
                shape.z = num;
                
		    }
		}
		
    }
}