/**
 * Copyright sk310 ( http://wonderfl.net/user/sk310 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/56Bw
 */

package {
        import flash.text.*;
        import flash.display.*;
        import flash.events.Event;
        
        public class Analog_Clock extends Sprite 
        {
            private var hh:Sprite = new Sprite();        //時針
            private var mi:Sprite = new Sprite();        //分針
            private var ss:Sprite = new Sprite();        //秒針
            private var center:Sprite = new Sprite();    //中心点
                
            public function Analog_Clock() 
            {
                //時計の縁描写
                graphics.lineStyle(5, 0xABABAB);
                graphics.drawCircle(180, 180, 140);
                
                //時計盤
                // x軸方向移動量 = Math.cos( 角度 * Math.PI / 180 ) * 距離
                // y軸方向移動量 = Math.sin( 角度 * Math.PI / 180 ) * 距離
                for (var degree:int = 0; degree < 360; degree += 360 / 60)
                {
                    var time:Sprite = new Sprite();
                    time.graphics.beginFill(0xAD0012);
    
                    if (degree % 30 == 0)
                    {
                        time.graphics.drawRect(0, 0, 20, 3);
                        time.graphics.endFill();
                        
                        time.x = 180 + Math.cos(degree * Math.PI / 180) * 118;
                        time.y = 180 + Math.sin(degree * Math.PI / 180) * 118;
                        time.rotation = degree;
                        addChild(time);
                    }
                    else
                    {
                        time.graphics.drawRect(0, 0, 8, 1);
                        time.graphics.endFill();
                        
                        time.x = 180 + Math.cos(degree * Math.PI / 180) * 130;
                        time.y = 180 + Math.sin(degree * Math.PI / 180) * 130;
                        time.rotation = degree;
                        addChild(time);
                    }
                }
    
                //時針
                hh.graphics.lineStyle(5, 0x0);
                hh.graphics.drawRect(0, 0, 80, 1);
                hh.x = hh.y = 180;
                addChild(hh);
                
                //分針
                mi.graphics.lineStyle(3, 0x0);
                mi.graphics.drawRect(0, 0, 120, 1);
                mi.x = mi.y = 180;
                addChild(mi);
                
                //秒針
                ss.graphics.lineStyle(1, 0x0);
                ss.graphics.drawRect(0, 0, 130, 1);
                ss.x = ss.y = 180;
                addChild(ss);
                
                //中心点
                center.graphics.beginFill(0x0);
                center.graphics.drawCircle(180, 180, 6);
                center.graphics.endFill();
                addChild(center);
                
                addEventListener(Event.ENTER_FRAME, now);
                
                function now(e:Event):void 
                {
                    var n_date:Date = new Date();
                    //90度スタートなので、-90する。
                    hh.rotation = (n_date.hours + n_date.minutes / 60) * 360 / 12 - 90;
                    mi.rotation = (n_date.minutes + n_date.seconds / 60) * 360 / 60 - 90;
                    ss.rotation = n_date.seconds * 360 / 60 - 90;
                }
            }
        }
}