/**
 * Copyright keyman ( http://wonderfl.net/user/keyman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/568t
 */

// forked from tkinjo's TextViewer
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite 
    {
        private const FONT_FAMILY:String = '"ヒラギノ角ゴ Pro W3","Hiragino Kaku Gothic Pro","メイリオ",Meiryo,Osaka,"ＭＳ Ｐゴシック","MS PGothic",sans-serif';
        
        private var SAMPLE_TEXT:String = <![CDATA[　吾輩（わがはい）は猫である。名前はまだ無い。
　どこで生れたかとんと見当（けんとう）がつかぬ。何でも薄暗いじめじめした所でニャーニャー泣いていた事だけは記憶している。吾輩はここで始めて人間というものを見た。しかもあとで聞くとそれは書生という人間中で一番獰悪（どうあく）な種族であったそうだ。この書生というのは時々我々を捕（つかま）えて煮（に）て食うという話である。しかしその当時は何という考もなかったから別段恐しいとも思わなかった。ただ彼の掌（てのひら）に載せられてスーと持ち上げられた時何だかフワフワした感じがあったばかりである。掌の上で少し落ちついて書生の顔を見たのがいわゆる人間というものの見始（みはじめ）であろう。この時妙なものだと思った感じが今でも残っている。第一毛をもって装飾されべきはずの顔がつるつるしてまるで薬缶（やかん）だ。その後（ご）猫にもだいぶ逢（あ）ったがこんな片輪（かたわ）には一度も出会（でく）わした事がない。のみならず顔の真中があまりに突起している。そうしてその穴の中から時々ぷうぷうと煙（けむり）を吹く。どうも咽（む）せぽくて実に弱った。これが人間の飲む煙草（たばこ）というものである事はようやくこの頃知った。
　この書生の掌の裏（うち）でしばらくはよい心持に坐っておったが、しばらくすると非常な速力で運転し始めた。書生が動くのか自分だけが動くのか分らないが無暗（むやみ）に眼が廻る。胸が悪くなる。到底（とうてい）助からないと思っていると、どさりと音がして眼から火が出た。それまでは記憶しているがあとは何の事やらいくら考え出そうとしても分らない。
　ふと気が付いて見ると書生はいない。たくさんおった兄弟が一疋（ぴき）も見えぬ。肝心（かんじん）の母親さえ姿を隠してしまった。その上今（いま）までの所とは違って無暗（むやみ）に明るい。眼を明いていられぬくらいだ。はてな何でも容子（ようす）がおかしいと、のそのそ這（は）い出して見ると非常に痛い。吾輩は藁（わら）の上から急に笹原の中へ棄てられたのである。
　ようやくの思いで笹原を這い出すと向うに大きな池がある。吾輩は池の前に坐ってどうしたらよかろうと考えて見た。別にこれという分別（ふんべつ）も出ない。しばらくして泣いたら書生がまた迎に来てくれるかと考え付いた。ニャー、ニャーと試みにやって見たが誰も来ない。そのうち池の上をさらさらと風が渡って日が暮れかかる。腹が非常に減って来た。泣きたくても声が出ない。仕方がない、何でもよいから食物（くいもの）のある所まであるこうと決心をしてそろりそろりと池を左（ひだ）りに廻り始めた。どうも非常に苦しい。そこを我慢して無理やりに這（は）って行くとようやくの事で何となく人間臭い所へ出た。ここへ這入（はい）ったら、どうにかなると思って竹垣の崩（くず）れた穴から、とある邸内にもぐり込んだ。縁は不思議なもので、もしこの竹垣が破れていなかったなら、吾輩はついに路傍（ろぼう）に餓死（がし）したかも知れんのである。一樹の蔭とはよく云（い）ったものだ。この垣根の穴は今日（こんにち）に至るまで吾輩が隣家（となり）の三毛を訪問する時の通路になっている。さて邸（やしき）へは忍び込んだもののこれから先どうして善（い）いか分らない。そのうちに暗くなる、腹は減る、寒さは寒し、雨が降って来るという始末でもう一刻の猶予（ゆうよ）が出来なくなった。仕方がないからとにかく明るくて暖かそうな方へ方へとあるいて行く。今から考えるとその時はすでに家の内に這入っておったのだ。ここで吾輩は彼（か）の書生以外の人間を再び見るべき機会に遭遇（そうぐう）したのである。第一に逢ったのがおさんである。これは前の書生より一層乱暴な方で吾輩を見るや否やいきなり頸筋（くびすじ）をつかんで表へ抛（ほう）り出した。いやこれは駄目だと思ったから眼をねぶって運を天に任せていた。しかしひもじいのと寒いのにはどうしても我慢が出来ん。吾輩は再びおさんの隙（すき）を見て台所へ這（は）い上（あが）った。すると間もなくまた投げ出された。吾輩は投げ出されては這い上り、這い上っては投げ出され、何でも同じ事を四五遍繰り返したのを記憶している。その時におさんと云う者はつくづくいやになった。この間おさんの三馬（さんま）を偸（ぬす）んでこの返報をしてやってから、やっと胸の痞（つかえ）が下りた。吾輩が最後につまみ出されようとしたときに、この家（うち）の主人が騒々しい何だといいながら出て来た。下女は吾輩をぶら下げて主人の方へ向けてこの宿（やど）なしの小猫がいくら出しても出しても御台所（おだいどころ）へ上（あが）って来て困りますという。主人は鼻の下の黒い毛を撚（ひね）りながら吾輩の顔をしばらく眺（なが）めておったが、やがてそんなら内へ置いてやれといったまま奥へ這入（はい）ってしまった。主人はあまり口を聞かぬ人と見えた。下女は口惜（くや）しそうに吾輩を台所へ抛（ほう）り出した。かくして吾輩はついにこの家（うち）を自分の住家（すみか）と極（き）める事にしたのである。]]>;
        
        private var textViewer:TextViewer;
        
        public function Main():void 
        {
            textViewer = new TextViewer();
            textViewer.width = stage.stageWidth - 20;
            textViewer.height = stage.stageHeight - 20;
            textViewer.x = 10;
            textViewer.y = 10;
            textViewer.text = SAMPLE_TEXT;
            addChild( textViewer );
        }
        
    }
    
}

import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.*;
import flash.display.*;

class TextViewer extends Sprite {
    
    private const FONT_FAMILY:String = '"ヒラギノ角ゴ Pro W3","Hiragino Kaku Gothic Pro","メイリオ",Meiryo,Osaka,"ＭＳ Ｐゴシック","MS PGothic",sans-serif';
    
    private var _textField:TextField;
    public function get textField():TextField { return _textField; }
    
    public function get text():String { return textField.text; }
    public function set text(value:String):void 
    {
        textField.text = value;
        textField.height = textField.textHeight + 4;
        scrollBar.contentHeight = textField.height;
    }
    
    private var scrollBar:ScrollBar;
    
    private var textFieldMask:Sprite;
    
    
    
    private var _width:Number = 0;
    override public function set width(value:Number):void {
        
        _width = value;
        textField.width = width - scrollBar.width;
        scrollBar.x = textField.width;
        repaintTextFieldMask();
    }
    override public function get width():Number { return _width; }
    
    
    
    private var _height:Number = 0;
    override public function set height(value:Number):void {
        
        _height = value;
        scrollBar.height = height;
        
        repaintTextFieldMask();
    }
    override public function get height():Number { return _height; }
    
    
    
    public function TextViewer():void 
    {
        _textField = new TextField();
        textField.wordWrap = true;
        textField.defaultTextFormat = new TextFormat( getFont( FONT_FAMILY ) );
        addChild( textField );
        
        scrollBar = new ScrollBar();
        scrollBar.width = 10;
        addChild( scrollBar );
        
        textFieldMask = new Sprite();
        addChild( textFieldMask );
        textField.mask = textFieldMask;
        
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    private function repaintTextFieldMask():void {
        
        textFieldMask.graphics.clear();
        textFieldMask.graphics.beginFill( 0 );
        textFieldMask.graphics.drawRect( 0, 0, textField.width, height );
        textFieldMask.graphics.endFill();
    }
    
    private function enterFrameHandler( event:Event ):void {
        
        textField.y = scrollBar.contentPosition;
    }
}

class ScrollBar extends Sprite {
    
    private var _contentHeight:Number = 0;    
    public function get contentHeight():Number { return _contentHeight; }
    public function set contentHeight(value:Number):void 
    {
        _contentHeight = value;
        repaint();
    }
    
    private var _width:Number = 0;
    override public function set width(value:Number):void {
        _width = value;
        repaint();
    }
    override public function get width():Number { return _width; }
    
    private var _height:Number = 0;
    override public function set height(value:Number):void {
        _height = value;
        repaint();
    }
    override public function get height():Number { return _height; }
    
    public function get contentPosition():Number { 
        
        return - scrollHandle.y / ( scrollFrame.height - scrollHandle.height ) * ( contentHeight - scrollFrame.height );
    }
    
    
    private var scrollHandle:Sprite;
    private var scrollHandleMouseDownY:Number;
    private var scrollFrame:Sprite;
    
    
    public function ScrollBar():void {
        
        scrollFrame = new Sprite();
        scrollFrame.visible = false;
        
        scrollHandle = new Sprite();
        
        addChild( scrollFrame );
        addChild( scrollHandle );
        
        scrollHandle.addEventListener(MouseEvent.MOUSE_DOWN, scrollHandleMouseDownHandler);
        
        repaint();
    }
    
    private function repaint():void {
        
        repaintScrollFrame();
        repaintScrollHandle();
    }
    
    protected function repaintScrollHandle():void {
        
        scrollHandle.graphics.clear();
        
        if ( height >= contentHeight  )
            return;
        
        scrollHandle.graphics.beginFill( 0, 0.5 );
        scrollHandle.graphics.drawRect( 0, 0, width, height / contentHeight * height );
        scrollHandle.graphics.endFill();
    }
    
    protected function repaintScrollFrame():void {
        
        scrollFrame.graphics.clear();
        
        if ( height >= contentHeight )
            return;
        
        scrollFrame.graphics.beginFill( 0, 0.5 );
        scrollFrame.graphics.drawRect( 0, 0, width, height );
        scrollFrame.graphics.endFill();
    }
    
    private function scrollHandleMouseDownHandler( event:MouseEvent ):void {
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, stageMouseMoveHandler);
        stage.addEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler);
        scrollHandleMouseDownY = stage.mouseY - scrollHandle.y;
    }
    
    private function stageMouseMoveHandler( event:MouseEvent ):void {
        
        scrollHandle.y = stage.mouseY - scrollHandleMouseDownY;
        
        if ( scrollHandle.y + scrollHandle.height > scrollFrame.height )
            scrollHandle.y = scrollFrame.height - scrollHandle.height;
        
        if ( scrollHandle.y < 0 )
            scrollHandle.y = 0;
    }
    
    private function stageMouseUpHandler( event:MouseEvent ):void {
        
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, stageMouseMoveHandler);
        stage.removeEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler);
    }
}

function getFont( fontFamily:String ):String {
    
    var enumerateFonts:Array = Font.enumerateFonts( true );
    var fonts:Array = fontFamily.replace( /"/g, "" ).split( "," );
    for each ( var fontName:String in fonts ) {
        
        for each( var font:Font in enumerateFonts ) {
            
            if ( fontName == font.fontName )
                return fontName;
        }
    }
    
    return "";
}