/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/55z5
 */






package  //// forked from christian's forked from: Collapsing World
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.utils.*;
    import com.risonhuang.pixas.math.Coord3D;
    import com.risonhuang.pixas.colors.CubeColor;
    import com.risonhuang.pixas.dimensions.CubeDms;
    import com.risonhuang.pixas.objects.PixelObject;
    import com.risonhuang.pixas.objects.primitives.Cube;
    import a24.tween.Tween24;
    import com.greensock.*;
    import com.greensock.easing.*;
    
    
    public class Main extends Sprite
    {
        private var po:PixelObject;
        private var bmd:BitmapData;
        private var timer:Timer;
        private var vec:Vector.<PixelObject>;
        private static const CONSTRAIN_SIZE:uint = 50;
        private static const X_DMS:uint = 6;
        private static const Y_DMS:uint = 6;
        private static const Z_DMS:uint = 10;
        private var proxy : String = 'http://p.jsapp.us/proxy/';
        private var t : TextField;
        private var n : Number;
        
        
        public function Main () 
        {
            stage.scaleMode = 'noScale'; stage.align = 'TL';
            Wonderfl.disable_capture ();
            // ENTRY POINT:
            
            with (addChild (t = new TextField ())) 
            { 
                autoSize = 'left'; y = 450; text = 'LOADING | BUILDING'; 
            } 
            
            var loader:Loader = new Loader();
            loader.load(
                new URLRequest(proxy + loaderInfo.parameters['viewer.iconURL']), 
                new LoaderContext(true)
            );
                loader.contentLoaderInfo.addEventListener( Event.COMPLETE,__onPicLoad );                    
        }
        
        
        private function __onPicLoad(e:Event):void
        {
            var img:Bitmap = e.target.loader.content as Bitmap;
            bmd = new BitmapData(CONSTRAIN_SIZE, CONSTRAIN_SIZE, false, 0);
            bmd.draw(img, new Matrix(CONSTRAIN_SIZE / img.width, 0, 0, CONSTRAIN_SIZE / img.height));
            addChild(new Bitmap(bmd));

            po = new PixelObject();
            po.x = 280;
            po.y = Z_DMS + 5;
            addChild(po);

            vec = new Vector.<PixelObject>;

            buildIso();
        }
        
        
        private function buildIso():void
        {
            n = getTimer ();

            var p_y:uint = 0, p_x:uint = 0;
            
            for (p_y=0; p_y < CONSTRAIN_SIZE; p_y++) for (p_x =0; p_x < CONSTRAIN_SIZE; p_x++)
            {
                var c3d:Coord3D = new Coord3D(X_DMS * p_x, Y_DMS * p_y, 0);
                var cubeDms:CubeDms = new CubeDms(X_DMS,Y_DMS,Z_DMS);
                var cubeColor:CubeColor = CubeColor.getByHorizontalColor(bmd.getPixel(p_x,p_y));
                var cube:Cube = new Cube(cubeDms,cubeColor,false);
                var po_cube:PixelObject = new PixelObject(cube,c3d);

                po.addChild(po_cube);
                vec.push(po_cube);
            }
            
            t.text = 'BUILD -> ' + (getTimer () - n) + ' MS | STACK -> ' + po.numChildren;
            
            timer = new Timer (30);
            timer.addEventListener(TimerEvent.TIMER, __onTimer);
            timer.start();
        }


        private function __onTimer(e:TimerEvent):void
        {
            if (vec.length == 0) { timer.stop(); return; }
            var po_pop:PixelObject = vec.pop();

            // Let's see how Greensock TweenMax (Jack Doyles engine) performs:
            TweenMax.to( po_pop, 0.5, {   
              //x:( 000 ),
                y:( y+350 ),
              //z:( 000 ),
                blurFilter:{ blurX:05,blurY:05,quality:2},
                ease:Quad.easeOut
            });
             
/*          Tween24.serial
            (
                Tween24.tween (po_pop, 0.5).$y (150).glow (0x00, 1, 10, 10, 1, 2).blurY(50),
                Tween24.tween (po_pop, 0.5).glow (0x00, 0, 12, 12, 2, 2).blurY(0)
                // Tween24.onComplete(callback, 'fin')
  
            ).play();
*/            
        }
    }
}