/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/55xZ
 */

// forked from clockmaker's [Alternativa3D] Basic Template
package
{
	import alternativ5.engine3d.materials.FillMaterial;
	import alternativ5.types.Point3D;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.utils.*

	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.display.Sprite;
	import flash.utils.Dictionary;
	import flash.geom.Point;
	import flash.display.GraphicsPathCommand;

	import frocessing.shape.*; 
		
	/*------------------------------------------------------------------------------
	Alternativa3D　illustrator > svg > Mesh
		
	illustratorで作成したパスデータをsvgで受け取って、Mesｈに押し出したものです。

	Alternativa3Dのfaceは、いくつものVertexを放り込んでも、勝手にPolygonを形成してくれるのですが
	複雑な形は、正しく裏表を設定してくれない場合もあります。
	その他、
	・wonderfl用で、読み込み部分を省略してますので、扱えるのは一筆書き状態の、複合Path、直線のみです。
	・同一座標で、2点が続けて重なっていると、正しく面を形成しません。
	・窓が切り抜かれた状態でも正しく面を形成しないので、一筆書きの要領でくり抜いた状態にしてください。
	
	2010/01/19 XMLパースをfrocessing利用に変更

	------------------------------------------------------------------------------*/

	[SWF(backgroundColor=0x000000,width = 465, height = 465, frameRate = 24)]
	public class SimpleDemo extends Sprite
	{
		private var dic:Dictionary;
		private var template:BasicTemplate;
		private var loader:URLLoader;
		public function SimpleDemo():void
		{
			// テンプレートを作成します
			template = new BasicTemplate();
			addChild(template);
			template.camera.z = -1000;

			FPS.init(stage)

			//テキスト用パスのSVGファイルをLoadする。
			loader = new URLLoader();
			loader.addEventListener( Event.COMPLETE, onload );

			loader.load( new URLRequest("http://marubayashi.net/archive/sample/images/star.svg") );
			//loader.load( new URLRequest("test.svg") );

		}


		public function onload( e:Event ):void
		{
			//XML取得
			var sp:FShape
			var temp:Array = [];
			for each( var child:XML in XML(loader.data).children() ) {
				sp = FShapeSVG.parsePath(child); 
				sp.styleEnabled = false; 
				temp.push({command:sp.commands.concat(), vertices:sp.vertices.concat(),roll:0});
			}


			var base:Object3D=new Object3D()
			template.scene.root.addChild(base);
			var temp3D:path3D=new path3D(temp[0],200)
			//temp3D.cloneMaterialToAllSurfaces(new FillMaterial(0xFF0000));
			temp3D.setMaterialToSurface(new FillMaterial(0x666600),'bottom');
			temp3D.setMaterialToSurface(new FillMaterial(0xFFFF00),'top');
			temp3D.setMaterialToSurface(new FillMaterial(0xCCCC00),'side');

			base.addChild(temp3D);
			temp3D.x=-temp3D.width/2
			temp3D.y=-temp3D.length/2
			trace(temp3D.length)


			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			template.onPreRender = function():void {

				// 立方体を回転させます (角度はラジアン)
				base.rotationY += 3 * Math.PI / 180;
			
				// マウスがステージの高さ何%の位置にあるか算出
				var rateY:Number = mouseY / stage.stageHeight;
				
				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				
				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());

			}


		}




	}


}



import alternativ5.types.Point3D;
import alternativ5.engine3d.core.Mesh;
import flash.utils.Dictionary;
import flash.geom.Point;
import flash.display.GraphicsPathCommand;


//---------------------------------------------------------------------------
//与えられたArrayのPoint(2D)情報で面を作成し、3Dに押し出すクラス
//---------------------------------------------------------------------------

class pressMesh extends Mesh{

	private　var _width:Number			//x
	private　var _length:Number		//y
	private　var _height:Number		//z
	private　var roll:uint

	public function pressMesh(pt:Array,h:Number,_roll:uint=0,separate:Boolean=false) {
		//pt[faceId:uint][verticesId:uint]:Pointの構造を持つArray
		//separate:Boolean =表面(top || bottom)のface仕様、trueでfaceIdで分割、falseは一枚のfaceにまとめる
		//roll:uint 			 =Pointの右回り、左回りを指定

		_height=h;
		roll=_roll;

		if (separate) {
			drawPathToPlane(pt,0,'top',false,true)
			drawPathToPlane(pt,height,'bottom',true,true)
		} else {
			drawPathToPlane(pt,0,'top',false,false)
			drawPathToPlane(pt,height,'bottom',true,false)
		}

		drawPathToSide(pt,'side')

		var wMax:Number=0
		var wMin:Number=0
		var hMax:Number=0
		var hMin:Number=0

		for (var n:uint=0; n<pt.length; n++) {
			for (var i:uint=0; i<pt[n].length; i++) {
				if (wMax<pt[n][i].x){
					wMax=pt[n][i].x;
				} else if (wMin>pt[n][i].x){
					wMin=pt[n][i].x;
				}
				if (hMax<pt[n][i].y) {
					hMax=pt[n][i].y;
				} else if (hMin>pt[n][i].y){
					hMin=pt[n][i].y;
				}
			}
		}

		_width=wMax-wMin
		_length=hMax-hMin

		//出来たMeshの中心を0,0,0にする
		for each(var item:* in this.vertices) {
		//	item.x-=width/2
			item.y-=300/2
			item.z-=height/2
		}
		
	}


	//-----------------------------------------------------------
	//sideの形成
	//-----------------------------------------------------------
	private function drawPathToSide(va:Array,id:String):void {
		var delimiter:String='_';
		var i:int;
		var n:int;

		var tId:String;
		var faceArray:Array;
		var surfaceArray:Array;
		surfaceArray=[];
		for (n=va.length-1;n>=0;n--) {
			for (i=1;i< va[n].length;i++) {
				faceArray=[]

				tId=id+delimiter+String(n)+delimiter+String(i)

				if (roll) {
					faceArray.push('bottom'+delimiter+String(n)+delimiter+String(i));

					if (i==va[n].length-1) {
						faceArray.push('bottom'+delimiter+String(n)+delimiter+String(1));
						faceArray.push('top'+delimiter+String(n)+delimiter+String(1));
					} else {
						faceArray.push('bottom'+delimiter+String(n)+delimiter+String(i+1));
						faceArray.push('top'+delimiter+String(n)+delimiter+String(i+1));
					}

					faceArray.push('top'+delimiter+String(n)+delimiter+String(i));
				
				} else {

					faceArray.push('top'+delimiter+String(n)+delimiter+String(i));

					if (i==va[n].length-1) {
						faceArray.push('top'+delimiter+String(n)+delimiter+String(1));
						faceArray.push('bottom'+delimiter+String(n)+delimiter+String(1));
					} else {
						faceArray.push('top'+delimiter+String(n)+delimiter+String(i+1));
						faceArray.push('bottom'+delimiter+String(n)+delimiter+String(i+1));
					}

					faceArray.push('bottom'+delimiter+String(n)+delimiter+String(i));
				
				}

				this.createFace(faceArray, tId);
				this.setUVsToFace(new Point(0, 0), new Point(1, 0), new Point(1,1), tId);
				surfaceArray.push(tId)

			}



		}
		this.createSurface(surfaceArray,id)



		
	}


	//-----------------------------------------------------------
	//上、下面の形成
	//-----------------------------------------------------------
	private function drawPathToPlane(va:Array,_h:Number,id:String,reverse:Boolean=false,separate:Boolean=false):void {

		var delimiter:String='_';
		var faceArray:Array=[];
		var i:int;
		var n:int;
		var tId:String;

		if (roll==1 && reverse) {
			reverse=false
		} else if (roll==1 && !reverse) {
			reverse=true
		}

		if (separate) {
			//すべて、Faceを分割
			if (reverse) {
				for (n=va.length-1;n>=0;n--) {
					faceArray[n]=[]
					for (i=1;i< va[n].length;i++) {

						tId=id+delimiter+String(n)+delimiter+String(i)
						this.createVertex(va[n][i].x, va[n][i].y, _h, tId);
						faceArray[n].push(tId)
					}
				}
			} else {
				for (n=0;n< va.length;n++) {
					faceArray[n]=[]
					for (i=va[n].length-1;i>0 ;i--) {

						tId=id+delimiter+String(n)+delimiter+String(i)
						this.createVertex(va[n][i].x, va[n][i].y, _h, tId);
						faceArray[n].push(tId)
					}
				}
			}
		} else {
			//すべて、一枚のFaceに
			faceArray[0]=[]
			if (reverse) {
				for (n=va.length-1;n>=0;n--) {
					for (i=1;i< va[n].length;i++) {
						tId=id+delimiter+String(n)+delimiter+String(i)
						this.createVertex(va[n][i].x, va[n][i].y, _h, tId);
						faceArray[0].push(tId)
						//trace(va[n][i].x, va[n][i].y, _h, tId)
					}

				}
			} else {
				for (n=0;n< va.length;n++) {
					for (i=va[n].length-1;i>0 ;i--) {
						tId=id+delimiter+String(n)+delimiter+String(i)
						this.createVertex(va[n][i].x, va[n][i].y, _h, tId);
						faceArray[0].push(tId)
						//trace(va[n][i].x, va[n][i].y, _h, tId)
					}
				}
			}
		}


		var surfaceArray:Array=[]

		for (i=0;i< faceArray.length;i++) {
			this.createFace(faceArray[i], id+delimiter+String(i));
			surfaceArray.push(id+delimiter+String(i))
			if (reverse) {
				this.setUVsToFace(new Point(1, -1), new Point(0, -1), new Point(0,0), id+delimiter+String(i));
			} else {
				this.setUVsToFace(new Point(0, 0), new Point(1, 0), new Point(1,1), id+delimiter+String(i));
			}
		}
		this.createSurface(surfaceArray,id)

	}



	public function get width():Number {
		return _width
	}

	public function get height():Number {
		return _height
	}

	public function get length():Number {
		return _length

	}


}



//3Dテキストを形成するクラス。
class text3D extends pressMesh{

	public function text3D(str:String,_h:Number,fontSet:Dictionary) {

		var n:uint=0;
		var m:int=-1;

		var varArray:Array=[]

		for (var i:uint=0; i<fontSet[str].command.length; i++) {
			if (fontSet[str].command[i]!=GraphicsPathCommand.NO_OP) {
				if (fontSet[str].command[i]==GraphicsPathCommand.MOVE_TO) {
					//moveTo
					m++;
					varArray[m]=[];
				}
				varArray[m].push(new Point(fontSet[str].vertices[n],fontSet[str].vertices[n+1]));
				n+=2;
			} else {
				//End
			}
		}

		var separat:Boolean
		if (str=='i' || str=='j' || str=='?' || str=='!') {
			//ij?!は、特殊 2枚faceを作る
			separat=true
		} else {
			separat=false
		}

		super(varArray,_h,fontSet[str].roll,separat)


	}

}


//イラレパスを押し出すクラス
class path3D extends pressMesh{

	public function path3D(pathSet:Object,_h:Number=100) {

		var n:uint=0;
		var m:int=-1;

		var varArray:Array=[]

		for (var i:uint=0; i<pathSet.command.length; i++) {
			if (pathSet.command[i]!=GraphicsPathCommand.NO_OP) {
				if (pathSet.command[i]==GraphicsPathCommand.MOVE_TO) {
					//moveTo
					m++;
					varArray[m]=[];
				}
				varArray[m].push(new Point(pathSet.vertices[n],pathSet.vertices[n+1]));
				n+=2;
			} else {
				//End
			}
		}

		super(varArray,_h,pathSet.roll,false)

	}

}








import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;


/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}
