/**
 * Copyright AtuyL ( http://wonderfl.net/user/AtuyL )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/55te
 */

/**
 * Question：正六面体のはずなのに・・・？
 * 
 * あ…ありのまま ここで　起こっている事を話すぜ！
 * 
 * 『おれは正六面体の側面を眺めようと
 * 　思ったらいつのまにか直方体を眺めていた』
 * 
 * 催眠術だとか超スピードだとか
 * 　そんなチャチなもんじゃあ　断じてねえ
 *
 * もっと恐ろしいものの片鱗を味わったぜ…
 */
package {
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.primitives.Box;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // consts
            const PI:Number = Math.PI;
            const toRADIAN:Number = 1 / 180 * PI;
            const toDEGREE:Number = 1 / PI * 180;
            const distance:Number = 200;
            
            // create camera
            var camera:Camera3D = new Camera3D;
            camera.fov = 90 * toRADIAN;// ここを変えると直方体の縦横比が変わる。
            camera.z = -distance;
            
            // create scene
            var scene:ConflictContainer = new ConflictContainer;
            scene.addChild(camera);
            
            // create view
            var stage:Stage = this.stage;
            var stageWidth:Number = stage.stageWidth;
            var stageHeight:Number = stage.stageHeight;
            this.addChild(camera.view = new View(stageWidth,stageHeight));
            
            // create box
            // 各軸対面に色つけただけの正六面体（立方体）を作成
            var xmtl:FillMaterial = new FillMaterial(0xFF0000,1.0,1,0x0);
            var ymtl:FillMaterial = new FillMaterial(0x00FF00,1.0,1,0x0);
            var zmtl:FillMaterial = new FillMaterial(0x0000FF,1.0,1,0x0);
            var box:Box = new Box;
            box.faces[0].material = box.faces[1].material = xmtl;
            box.faces[2].material = box.faces[3].material = ymtl;
            box.faces[4].material = box.faces[5].material = zmtl;
            scene.addChild(box);
            
            // enterframe action
            // マウスでぐりぐりまわす。
            // ここでは直接カメラのmatrix（姿勢）を書き換えている。
            // カメラを何らかの子にして、その入れ物を回すと正しく表示されるが…
            // それじゃカメラそのものの姿勢を変えたらダメということに…
            var orbitMatrix:Matrix3D = new Matrix3D();
            this.stage.addEventListener(Event.ENTER_FRAME,function(event:Event):void{
                var pitch:Number = -(stage.mouseY / stageHeight - 0.5) * 2.0 * PI;
                var yaw:Number = (stage.mouseX / stageWidth - 0.5) * 2.0 * PI;
                orbitMatrix.identity();
                orbitMatrix.appendTranslation(0.0,0.0,-distance);
                orbitMatrix.appendRotation(pitch * toDEGREE,Vector3D.X_AXIS);
                orbitMatrix.appendRotation(yaw * toDEGREE,Vector3D.Y_AXIS);
                camera.matrix = orbitMatrix;
                camera.render();
            });
        }
    }
}