/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/55W5
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
           myDraw = new xVertDraw();  
            
           stage.addEventListener(Event.ENTER_FRAME, onEnter); 
        }//ctor
        
        public var myDraw:xVertDraw;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);

            myDraw.addVert(0,0,-340, 32);
            
            var cw:Number; var w:Number;
            var i:int; var k:int; var kz:Number;
            var ax:Number;  var ay:Number;   var az:Number;
            cw = 32; 
             w= cw*0.5;
             az = -320;
             ax = stage.mouseX-480; ay = -stage.mouseY;
            for (k = 0; k < 4; k++)
            { kz = k*16;
            for (i = 0; i < 16; i++)
            {
                
               myDraw.addVert(ax+i*cw,ay+ 0, az+kz, w);
               myDraw.addVert(ax+i*cw,ay+ 480, az+kz, w);
               myDraw.addVert(ax+0, ay+i*cw,  az+kz, w);
               myDraw.addVert(ax+480,ay+ i*cw,  az+kz, w);               
            }}


            myDraw.renderVert(graphics);
                        
        }//onenter
        
        
    }
}

internal class xVert
{
  
  public var sx:Number = 0;  public var sy:Number = 0;
  public var sr:Number = 0;
  public var sw:Number = 1;
  public var sortCode:int = 0;
  
}//xvert 

import flash.display.Graphics;

internal class xVertDraw 
{
  public var vecVert:Vector.<xVert>;
  public var it:int = 0;
  
  public var projMat:Vector.<Number> = Vector.<Number>([1, 0, 0, 0, 0, 1, 0, 0,  0, 0, 1, 0, 0, 0, 0, 1]); 
  public var rendw:Number = 465 * 0.5;
  public var rendh:Number = 465 * 0.5;
  
  
  public function xVertDraw()
  {
    init(1024);
    setProjMat(projMat, 90, 1, 1, 1000);
  }//ctor  
  
  public function init(num:int):void
  {
    vecVert = new Vector.<xVert>(num, false);
    var i:int;   for (i = 0; i < num; i++) { vecVert[i] = new xVert(); }
  }//init
  
  public function addVert(ax:Number, ay:Number, az:Number, rad:Number):void
  {
    var a:xVert;  var mat:Vector.<Number>;    var m:Number;
    var sx:Number;        var sy:Number;      var sz:Number;
    var w:Number; 
    mat = projMat;
   
    w = ax * mat[3] + ay * mat[7] + az * mat[11] + mat[15];
    if (w <= 0) { return; }
    
    sx = ax * mat[0] + ay * mat[4] + az * mat[8] + mat[12];
    sy = ax * mat[1] + ay * mat[5] + az * mat[9] + mat[13];
    sz = ax * mat[2] + ay * mat[6] + az * mat[10] + mat[14];
   
    sx /= w; sy /= w;
    sx *= rendw;            sy *= -rendh;
    sx += rendw;            sy += rendh;
        
    m = (1 / w) * rendh * rad; 
        
    a = vecVert[it]; it += 1; if (it >= vecVert.length) { it = vecVert.length - 1; }
    a.sx = sx;   a.sy = sy;   a.sw = w;    a.sr = m;
    a.sortCode = 0x0FffFFff - int(sz);    
  }//addvert
    
  public function renderVert(g:Graphics):void
  {
    //g.lineStyle(2, 0);
    var i:int; var num:int; var a:xVert;
    num = it;    sortVert(vecVert, num);
    for (i = 0; i < num; i++)
    { a = vecVert[i];
      g.beginFill(0x808080, 1);
        g.drawCircle(a.sx, a.sy, a.sr);
      g.endFill();
    }//nexti 
    it = 0;
  }//rendervert
    
    
    public function sortVert(vec:Vector.<xVert>, num:int):void
    {  radixSortVert(vec, num);    }//sortvert 
     
    public var tempVec:Vector.<xVert> = new Vector.<xVert>(8192, false);
    public var tempBuck:Vector.<int> = new Vector.<int>(256, false);
    public function radixSortVert(vec:Vector.<xVert>, num:int):void
    {
      var a:xVert;          var temp:Vector.<xVert>;          var buck:Vector.<int>;
      var i:int;          var k:uint;          var shift:int;          var g:int;
      if (vec.length < num) { num = vec.length; }
      temp = tempVec;    if (temp.length < num) { return; }
      buck = tempBuck;    shift = 0;       
      while (shift < 32)  {   
        for (k = 0; k < 256; k++) { buck[k] = 0; }      //reset bucket
        for (i = 0; i < num; i++)  {  g = (vec[i].sortCode >> shift) &0xFF;  buck[g]++; }              
        for (i = 1; i < 256; i++)   {  buck[i] += buck[i - 1];  }               
        for (i = num - 1; i >= 0; i--)  { g = (vec[i].sortCode >> shift) &0xFF;  temp[--buck[g] ] = vec[i];  }        
        for (i = 0; i < num; i++) { vec[i] = temp[i];   }
        shift += 8; 
      }//wend
    }//radixsort  
  
    public static function setProjMat(vec:Vector.<Number>,
     fovdeg:Number = 60.0, aspect:Number=1.0, nearp:Number = 1.0, farp:Number=1000.0):void
    {   var f:Number;   var i:int;
        for (i = 0; i < 16; i++) { vec[i] = 0.0;  } 
        f = 1.0 / Math.tan( (fovdeg * (3.1415 / 180.0)) * 0.5 );
        if (nearp == 0) { nearp = 0.0001; }
        if (farp == 0) { farp = 0.0001; }
        vec[0] = f / aspect;          vec[5] = f;
        vec[10] = (farp + nearp) / (nearp - farp);
        vec[14] = (2.0 * farp * nearp) / (nearp - farp);
        vec[11] = -1.0;          vec[15] = 0.0;
    }//projmatrix
      
}//vertdraw