/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/54NS
 */

// A very simple example to show how to use servos
// NOTE: Arduino 0017 is requred to use servos
// in StandardFirmata
// 
// Output:
// * A servo connected the D9 pin
// 
// How to:
// http://funnel.cc/Main/GettingStarted
// 
// Reference:
// http://funnel.cc/Software/ActionScript3
// http://funnel.cc/reference/actionscript3/

package {
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    
    import funnel.*;
    import funnel.ui.*;
    import funnel.gui.*;

    public class ArduinoServoTest extends Sprite {
        private const SERVO_PIN:int = 9;

        private var arduino:Arduino;
        private var servo:Servo;
        private var pulseGenerator:Timer;

        public function ArduinoServoTest() {
            var config:Configuration = Arduino.FIRMATA;
            config.setDigitalPinMode(SERVO_PIN, SERVO);
            arduino = new Arduino(config);
            servo = new Servo(arduino.digitalPin(SERVO_PIN));

            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            arduino.gui = gui;

            pulseGenerator = new Timer(1000);
            pulseGenerator.addEventListener(TimerEvent.TIMER, onPulse);
            pulseGenerator.start();
        }

        private function onPulse(e:TimerEvent):void {
            var angle:Number = Math.random() * 180;
            servo.angle = angle;
        }
    }
}