/**
 * Copyright psyark ( http://wonderfl.net/user/psyark )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5458
 */

package {
	import flash.display.*;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0x000000)]
	/**
	 * このクラスでは、Graphics#drawTrianglesを使って三角形を描画する方法を示します。
	 * Vector.<Number>にX,Y座標を交互に格納して、描画する三角形を指定します。
	 */
	public class Test00 extends Sprite {
		private var viewport:Shape;
		
		public function Test00() {
			// 描画対象となるShapeを作成し、表示リストに追加します。
			viewport = new Shape();
			addChild(viewport);
			// 描画を行います。
			render();
		}
		
		/**
		 * 描画
		 */
		private function render():void {
			// このVectorにX,Y座標を交互に格納することで、描画する三角形を指定します。
			var screenVertices:Vector.<Number> = new Vector.<Number>();
			
			// 1つめの三角形の3点の座標を格納します。
			// X座標とY座標が交互に並ぶようにします。
			screenVertices.push(150, 70);
			screenVertices.push(250, 250);
			screenVertices.push(50, 250);
			
			// 2つめの三角形の座標を格納します。
			// Vector#pushには任意の数の値を渡すことができるので、
			// 以下のように一度に追加することも可能です。
			screenVertices.push(380, 220, 410, 390, 50, 350);
			
			// 描画方法の指定を行います。
			// #FFFFFFの極細線と#000066の塗りで描画します。
			viewport.graphics.lineStyle(-1, 0xFFFFFF);
			viewport.graphics.beginFill(0x000066);
			
			// Graphics#drawTrianglesは複数の三角形を描画します。
			// 第一引数には三角形の頂点のVectorを渡します。
			viewport.graphics.drawTriangles(screenVertices);
			
			// 塗りを終了します。
			viewport.graphics.endFill();
		}
	}
}