/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/53so
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
       
       //another iso experiment, now with sprite/wall sorting
       //sorting between walls and sprites is not good yet 
       //(probably would work better without using the z, or if the walls werent tall)
       //(or by using more trickery/hacks)
       //(so far i just try to keep the actors away from walls)
       
        public function FlashTest() {
       
       
           var num:int;
           var i:int;
           
           mwidth = 32;
           mheight = 32;
           
           num = mwidth * mheight;
           
           vecGrid = new Vector.<int>(num, false);
           
           bd = new BitmapData(mwidth, mheight, false, 0);
              vecCol = Vector.<uint>([0, 0x808080, 0x880000, 0x000088, 0x008800, 0x441288, 0x112233 ]);
           
           for (i = 0; i < 32; i++)
           {
               //mapRect(0,0,4,4,2);
               if (Math.random() < 0.5)
               {
                mapRect(Math.random()*mwidth,Math.random()*mheight, 1, Math.random()*16,2);
               }
               else
               {
                mapRect(Math.random()*mwidth,Math.random()*mheight,Math.random()*16,1,2);    
               }
           }//nexti
           
         
           
           pic = new Bitmap(bd);
           pic.x = 250;
           pic.scaleX = 2;
           pic.scaleY = 2;
           addChild(pic);
           
           
           deb = new TextField();
           deb.width = 320;
           deb.height = 240;
           deb.mouseEnabled = false;
           addChild(deb);
           
           
          // var a:xFrame;
           
           vecFrame = new Vector.<xFrame>(maxFrame, false);
           
           num = vecFrame.length;
           for (i = 0; i < num; i++)
           {
               vecFrame[i] = new xFrame();  
           }
           
           
           vecAct = new Vector.<xActor>(0, false);
           
           var a:xActor;
           
           var ww:Number;
           var wh:Number;
           
           ww = mwidth * cw;
           wh = mheight * ch;
           
           for (i = 0; i < 64; i++)
           {
               a = new xActor();
               a.cx = Math.random() * ww;
               a.cy = Math.random() * wh;
               a.cz = 32;
               
               
               //making sure to not start in wall
               mapRect(a.cx/cw -1,a.cy/ch-1,3,3,0);
               
               vecAct.push(a);
               
           }//nexti
          
           bd.lock();
             for (i = 0; i < num; i++)
           {
               //vecGrid[i] = 1; //Math.random() * 2;
               bd.setPixel(i%mwidth,i/mwidth,vecCol[vecGrid[i]]);
           }//nexti
           bd.unlock();
           
          stage.addEventListener(Event.ENTER_FRAME,onEnter);     
        }//ctor
        
        public function mapRect(sx:int, sy:int, w:int, h:int, c:int):void
        {
            var ex:int;
            var ey:int;
            
            var i:int;
            var k:int;
            var yt:int;
            
            ex = sx + w;
            ey = sy + h;
             
            if (sy < 0) { sy = 0;}
            if (sy >= mheight) { return; }
            if (sx < 0) { sx = 0;}
            if (sx >= mwidth) { return;}
            
            if (ex < 0) { return; }
            if (ex > mwidth) { ex = mwidth;}
            if (ey < 0) { return; }
            if (ey > mheight) { ey = mheight; } 
            
            
            for ( i = sy; i < ey; i++)
            {
                yt = i * mwidth;
                
                for (k = sx; k < ex; k++)
                {
                    vecGrid[yt+k] = c;
                }//nextk
            }//nexti
        }//fillmap
        
        public var deb:TextField;
            
        public var bd:BitmapData;
        public var pic:Bitmap;


        public var vecCol:Vector.<uint>;
        public var vecGrid:Vector.<int>;
        public var mwidth:int = 0;
        public var mheight:int = 0;
        public var cw:Number = 32;
        public var ch:Number = 32;
        public var cd:Number = 64;
        
        
        public var camx:Number = 0;
        public var camy:Number = 0;
        
        
        public var vecAct:Vector.<xActor>;
        
        
        public var vecFrame:Vector.<xFrame>;
        public var maxFrame:int = 1024;
        public var it:int = 0;
        
        public function addFrame(sx:Number, sy:Number, shape:int, sortCode:int):void
        {
             if (it >= maxFrame) { return;}   
            
            var a:xFrame;
            
            a = vecFrame[it];
            
            a.sx = sx;
            a.sy = sy;
            a.shape = shape;
            a.sortCode = sortCode;
            
            
            it += 1;
        }//addframe
        
        
        public function isWall(wx:Number, wy:Number):Boolean
        {
            var tx:int;
            var ty:int;
            
            tx = Math.floor(wx / cw);
            ty = Math.floor(wy / ch);
            
            if (tx < 0) { return true; }
            if (ty < 0) { return true; }
            if (tx >= mwidth) { return true; }
            if (ty >= mheight) { return true; }
            
            return ( vecGrid[ty*mwidth + tx] == 2 ); 
            
        }//iswall
        
    
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(1, 0);
            
            if (pic.mouseX >= 0 && pic.mouseY >= 0
            && pic.mouseX < pic.width && pic.mouseY < pic.height)
            { camx= pic.mouseX*cw - 128; camy = pic.mouseY*ch - 128; }
           
           
           
           
            //drawing tilemap
            
            
                it = 0; //reset frame(drawable sprite) count
                
            var offx:Number;
            var offy:Number;
            

            var i:int;
            var k:int;
            var num:int;
            var m:xActor;
            
            var sx:int;
            var sy:int;
            var ex:int;
            var ey:int;
            var yt:int;
            var t:int;
            
            var c:int;
            
            var rx:Number; var ry:Number; var rz:Number;
            var dx:Number; var dy:Number;
            
            var kw:Number; var kh:Number;
            
            
            var ax:Number;
            var ay:Number;
            var bx:Number;
            var by:Number;
            
            //screen rectangle [ax,ay]-[bx,by]
            ax = 0;
            ay = 0;
            bx = 465;
            by = 465;
            
            //ax = 100; ay = 100; bx = 300; by =300; //debug
            
            //camx += 1;
            
            kw = cw * 0.5; kh = ch * 0.5;
           
           //these should be actually dependent on tile size and calculated somehow
           //but i'm just guessing instead because whatever 
            sx = Math.floor(camx / cw);
            sy = Math.floor(camy / ch);
            ex = sx + 16 + 4;
            ey = sy + 16 + 4;
            sx -= 4;
            sy -= 4;
            
            //deb.text = " sx " + sx + " sy " + sy + " ex " + ex + " ey " + ey;
            deb.text = " pmx " + pic.mouseX + " pmy " + pic.mouseY;
            
            if (sy < 0) { sy = 0;}
            if (sy >= mheight) { return; }
            if (sx < 0) { sx = 0;}
            if (sx >= mwidth) { return;}
            
            if (ex < 0) { return; }
            if (ex > mwidth) { ex = mwidth;}
            if (ey < 0) { return; }
            if (ey > mheight) { ey = mheight; } 

            
            for ( i = sy; i < ey; i++)
            {
                yt = i * mwidth;
                
                for (k = sx; k < ex; k++)
                {
                     t = vecGrid[yt+k];
                     if (t < 0) { continue; }
            
                     rx = k * cw- camx;
                     ry = i * ch- camy;            
                     rz = 0;
                     
                    if (t == 2) { rz = cd;}
                    
                     //if (t == 1) { rz = 16; } 
                    // rz = t;
                     
                    dx = rx - ry;
                    dy = (rx*0.5)+(ry*0.5) - rz;
                    
                    dx += 200;
                  //  dy += 100;
                  
                      if (t == 2)
                      {
                        
                         if (dx < ax-128) { continue; }
                         if (dy < ay-128) { continue; }
                         if (dx > bx+128) { continue;  }
                         if (dy > by+128) { continue; }
                    
                       // addFrame(dx, dy, 1, rx+ry+rz);                         
                        //addFrame(dx, dy, 1, rx+ry+(rz/2));   
                        //addFrame(dx, dy, 1, rx+ry+16);   
                        addFrame(dx,dy,1,(rx+kw)+(ry+kh)+(cd*0.5));
                          
                        continue;   
                      }//endif
                  
   
                    if (dx+cw < ax-cw) { continue; }
                    if (dy+ch < ay-ch) { continue; }
                    if (dx-cw > bx+cw) { continue;  }
                    if (dy-ch > by) { continue; }
                    
            
                    c = vecCol[t];
                    
                   // if (t != 2)
                    {
                        graphics.beginFill(c, 0.5);
                         graphics.moveTo(dx, dy);
                         graphics.lineTo(dx+cw,dy+kh);  
                         graphics.lineTo(dx+cw-cw,dy+kh+kh);
                         graphics.lineTo(dx-cw, dy+kh);
                         graphics.lineTo(dx,dy);
                        graphics.endFill();
                      //  continue;  
                    }//endif
                    
                    /*
                        graphics.beginFill(c, 1);
                         graphics.moveTo(dx, dy);
                         graphics.lineTo(dx+cw,dy+kh);  
                         graphics.lineTo(dx+cw-cw,dy+kh+kh);
                         graphics.lineTo(dx-cw, dy+kh);
                         graphics.lineTo(dx,dy);
                        graphics.endFill(); 
                
                   //wall
                   
                    graphics.beginFill(0x202020,1);
                    graphics.moveTo(dx+cw,dy+kh);  
                    graphics.lineTo(dx+cw,dy+cd+kh);  
                    graphics.lineTo(dx+cw-cw,dy+cd+kh+kh);
                    graphics.lineTo(dx+cw-cw,dy+kh+kh);
                    graphics.endFill();
                    
                    
                    graphics.beginFill(0x404040,1);
                    graphics.moveTo(dx-cw, dy+kh);
                    graphics.lineTo(dx-cw, dy+cd+kh);
                    graphics.lineTo(dx+cw-cw,dy+cd+kh+kh);
                    graphics.lineTo(dx+cw-cw,dy+kh+kh);
                    graphics.endFill();
            */
            
                }//nextk
                
            }//nexti
            
            
            
            //update actors
            
            num = vecAct.length;
            
            for (i = 0; i < num; i++)
            {
                m = vecAct[i];
                
                m.vz -= 0.2;
                m.vx *= 0.99;
                m.vy *= 0.99;
                
                  if (m.vz < 0 && m.cz <= 16) 
                  { m.cz = 16; 
                    
                    m.vz *= -0.5; 
                    if (m.vz <0.4) { m.vz= 0;}
                  }
                
                if (m.vx < 0 && isWall(m.cx - 16, m.cy)) { m.vx *= -0.5;}
                if (m.vx > 0 && isWall(m.cx + 16, m.cy)) { m.vx *= -0.5;}
                if (m.vy < 0 && isWall(m.cy, m.cy-16)) { m.vy *= -0.5;}
                if (m.vy > 0 && isWall(m.cy, m.cy+16)) { m.vy *= -0.5;}
                
                
                m.cx += m.vx;
                m.cy += m.vy;
                m.cz += m.vz;
                
              
                  if (isWall(m.cx-15,m.cy) && !isWall(m.cx+16,m.cy)) { m.cx+=1;}
                  else if (isWall(m.cx+15,m.cy) && !isWall(m.cx-16,m.cy)) { m.cx-=1;}
                  if (isWall(m.cx, m.cy-15) && !isWall(m.cx,m.cy+16)) {m.cy +=1;}
                  else if (isWall(m.cx, m.cy+15) && !isWall(m.cx,m.cy-16)) {m.cy -=1;}
                  
               
                
                if (m.cz<=17) {m.w += 1 + Math.random()*3; }
                if (m.w >= 40)
                {
                    m.w = 0;
                    m.vx += (Math.random()-Math.random())*3;
                    m.vy += (Math.random()-Math.random())*3;
                    
                    if (Math.random() <= 0.3 && m.cz <= 17 ) { m.vz = 4+ Math.random()*4; }
                }
                
                
                rx = m.cx - camx;
                ry = m.cy - camy;            
                rz = m.cz;
                    
                dx = rx - ry;
                dy = (rx*0.5)+(ry*0.5) - rz;
                dx += 200;
                
                //check if on screen
                //todo -- shadow should be tested separately
                if (dx < ax - 16) { continue;}
                if (dx > bx + 16) { continue; }
                if (dy < ay -16) { continue;}
                if (dy > by + 16) {continue;}
                
            
                
                addFrame(dx, dy, isWall(m.cx,m.cy) ? 4: 2, rx+ry+rz);
                
                
               
               //shadow
               
                rx = m.cx - camx;
                ry = m.cy - camy;            
                rz = 0;
                    
                dx = rx - ry;
                dy = (rx*0.5)+(ry*0.5) - rz;
                dx += 200;
                
                 addFrame(dx, dy, 3, rx+ry+rz);
               
                
            }//nexti
            
            
            
            

            //graphics.drawRect(ax,ay,bx,by);
           
           
           radixSort(vecFrame,it);
           
           //draw frames(sprites)
            
            var a:xFrame;
            for (i = 0; i < it; i++)
            {
                a = vecFrame[i];
                
                dx = a.sx;
                dy = a.sy;
                
                
                if (a.shape == 1) //wall
                {
                                              
                    graphics.beginFill(0x802080, 1);
                         graphics.moveTo(dx, dy);
                         graphics.lineTo(dx+cw,dy+kh);  
                         graphics.lineTo(dx+cw-cw,dy+kh+kh);
                         graphics.lineTo(dx-cw, dy+kh);
                         graphics.lineTo(dx,dy);
                      graphics.endFill(); 
                
                    graphics.beginFill(0x202020,1);
                    graphics.moveTo(dx+cw,dy+kh);  
                    graphics.lineTo(dx+cw,dy+cd+kh);  
                    graphics.lineTo(dx+cw-cw,dy+cd+kh+kh);
                    graphics.lineTo(dx+cw-cw,dy+kh+kh);
                    graphics.endFill();
                    
                    
                    graphics.beginFill(0x404040,1);
                    graphics.moveTo(dx-cw, dy+kh);
                    graphics.lineTo(dx-cw, dy+cd+kh);
                    graphics.lineTo(dx+cw-cw,dy+cd+kh+kh);
                    graphics.lineTo(dx+cw-cw,dy+kh+kh);
                    graphics.endFill();
      
                  continue;
                }//endif
                
                if (a.shape == 2)
                {
                    
                    graphics.beginFill(0x440000, 1);
                     graphics.drawCircle(dx, dy, 16);
                    graphics.endFill();
                    
                    graphics.beginFill(0xFFaaaa,1);
                     graphics.drawCircle(dx-4, dy-4, 4);
                    graphics.endFill();
                    
                    continue;
                }//endif
                
                if (a.shape == 3)
                {
                    graphics.beginFill(0, 1);
                     graphics.drawEllipse(dx-8,dy-4,16,8);
                    graphics.endFill();
                    continue;
                }//endif
                
                 if (a.shape == 4)
                {
                    
                    graphics.beginFill(0x004400, 1);
                     graphics.drawCircle(dx, dy, 16);
                    graphics.endFill();
                    
                    graphics.beginFill(0xaaFFaa,1);
                     graphics.drawCircle(dx-4, dy-4, 4);
                    graphics.endFill();
                    
                }//endif
            }//nexti
            
            
            
        }//onenter
        
        
        
        //update:
        //radix sorting fixed
        
        public var tempVec:Vector.<xFrame> = new Vector.<xFrame>(4096, false);
        public var tempBuck:Vector.<int> = new Vector.<int>(256, false);

        public function radixSort(vec:Vector.<xFrame>, num:int):void
        {
          var a:xFrame;
          var temp:Vector.<xFrame>;
          var buck:Vector.<int>;
          var i:int;
          var k:uint;
          var shift:int;
          var g:int;

            //todo -- in the prototype it was set in the wrong way
            if (vec.length < num) { num = vec.length; }
          
            
            temp = tempVec;
            
            //todo -- resize when vec is larger than max
            if (temp.length < num) { return; }

         
            buck = tempBuck;
            shift = 0;
            

          while (shift < 32)
            {
              
                //reset bucket
                for (k = 0; k < 256; k++)
                { buck[k] = 0; }
              
                
                for (i = 0; i < num; i++)
                {
               
                  g = (vec[i].sortCode >> shift) &0xFF; //% 256;
                  //if (g < 0) { g = -g; }
                  buck[g]++;
                }
               
                for (i = 1; i < 256; i++) 
                {
                  buck[i] += buck[i - 1];
                }
               
                for (i = num - 1; i >= 0; i--)
                {
                  g = (vec[i].sortCode >> shift) &0xFF; // % 256;
                  //if (g < 0) { g = -g; }
                  temp[--buck[g] ] = vec[i];
                }
               
                for (i = 0; i < num; i++)
                {
                  vec[i] = temp[i];
                }
               
                shift +=  8; 
              
            }//wend
          
        }//radixsort  

        
        
        
        
        
    }//classend
}

internal class xActor
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    
    public var cz:Number = 0;
    
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    
    
    public var w:int = 0;
    
}//xactor



internal class xFrame
{
    
    public var sx:Number = 0;
    public var sy:Number = 0;
    
    public var sortCode:int = 0;
    
    public var shape:int = 0;
    
    
}//frame