/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/52eO
 */

package  
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const RADIUS:Number = 100;
        private const INNER_RADIUS:Number = 80;
        
        private var ring:Ring;
        
        public function Main() 
        {
            ring = new Ring( RADIUS, INNER_RADIUS );
            ring.x = uint( stage.stageWidth / 2 );
            ring.y = uint( stage.stageHeight / 2 );
            ring.degree = 0;
            addChild( ring );
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            ring.degree += 5;
            
            if ( ring.degree >= 360 ) {
                
                ring.reverse = !ring.reverse;
                ring.degree = 0;
            }
        }
    }
}



import flash.display.*;
import flash.geom.*;

class Ring extends Sprite {
    
    private var _degree:Number = 360;
    public function set degree(value:Number):void 
    {
        _degree = value;
        
        var degree:Number = value % 360;
        
        if ( !reverse ) {
            
            if ( 0 <= degree && degree <= 180 ) {
                
                circleLeftMask.rotation = 180;
                circleRightMask.rotation = 180 * degree / 180 - 180;
                
            } else {
                
                circleLeftMask.rotation = 180 * degree / 180;
                circleRightMask.rotation = 0;
            }
            
        } else {
            
            if ( 0 <= degree && degree <= 180 ) {
                
                circleLeftMask.rotation = 0;
                circleRightMask.rotation = 180 * degree / 180;
                
            } else {
                
                circleLeftMask.rotation = 180 * degree / 180 - 180;
                circleRightMask.rotation = 180;
            }
        }
    }
    public function get degree():Number { return _degree; }
    
    
    public var reverse:Boolean = false;
    
    
    private var circleRight:Sprite = new Sprite();
    private var circleLeft:Sprite = new Sprite();
    
    private var circleRightMask:Sprite = new Sprite();
    private var circleLeftMask:Sprite = new Sprite();
    
    public function Ring( radius:Number, innerRadius:Number, color:uint = 0 ) 
    {
        var matrix:Matrix = new Matrix();
        
        
        
        // circleRight
        circleRight.graphics.beginFill( color );
        circleRight.graphics.drawCircle( radius, radius, radius );
        circleRight.graphics.drawCircle( radius, radius, innerRadius );
        circleRight.graphics.endFill();
        addChild( circleRight );
        
        var bitmapData:BitmapData = new BitmapData( radius, radius * 2, true, 0 );
        matrix.translate( -radius, 0 );
        bitmapData.draw( circleRight, matrix );
        
        var circleRightBitmap:Bitmap = new Bitmap( bitmapData );
        circleRightBitmap.y = -100;
        circleRight.addChild( circleRightBitmap );
        circleRight.graphics.clear();
        
        
        
        // circleLeft
        circleLeft.graphics.beginFill( color );
        circleLeft.graphics.drawCircle( radius, radius, radius );
        circleLeft.graphics.drawCircle( radius, radius, innerRadius );
        circleLeft.graphics.endFill();
        addChild( circleLeft );
        
        bitmapData = new BitmapData( radius, radius * 2, true, 0 );
        matrix.identity();
        bitmapData.draw( circleLeft );
        
        var circleLeftBitmap:Bitmap = new Bitmap( bitmapData );
        circleLeftBitmap.x = -radius;
        circleLeftBitmap.y = -radius;
        circleLeft.addChild( circleLeftBitmap );
        circleLeft.graphics.clear();
        
        
        
        // circleRightMask
        circleRightMask.graphics.beginFill( 0 );
        circleRightMask.graphics.drawRect( 0, -radius, radius, radius * 2 );
        circleRightMask.graphics.endFill();
        addChild( circleRightMask );
        circleRight.mask = circleRightMask;
        
        // circleLeftMask
        circleLeftMask.graphics.beginFill( 0 );
        circleLeftMask.graphics.drawRect( -radius, -radius, radius, radius * 2 );
        circleLeftMask.graphics.endFill();
        addChild( circleLeftMask );
        circleLeft.mask = circleLeftMask;
    }
}