/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/51pK
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.*;
	
	public class Main extends Sprite {
		private var canvas:BitmapData;
		private var canvasRect:Rectangle;
		private var brush:Bitmap;
		private var cx:Number,cy:Number;
		private var verts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var pmtx:Matrix3D;
		private var pers:PerspectiveProjection;
		private var xr:Number = 0, yr:Number = 0;
		
		
		public function Main() {
			cx = stage.stageWidth / 2;
			cy = stage.stageWidth / 2;
			verts = new Vector.<Number>();
			pVerts = new Vector.<Number>();
			pmtx = new Matrix3D();
			pers = new PerspectiveProjection();
			uvts = new Vector.<Number>();
			
			addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000)));
			canvasRect = canvas.rect;
			for (var i:uint = 0; i < 25; i ++) {
				for (var j:uint = 0; j < 25; j ++) {
					for (var k:uint = 0; k < 25; k ++) {
						verts.push((i - 12) * 8);
						verts.push((j - 12) * 8);
						verts.push((k - 12) * 8);
					}
				}
			}
			addEventListener(Event.ENTER_FRAME, h_enterframe);
		}
		
		private function h_enterframe(evt:Event):void {
			yr += (cx - mouseX) / 100;
			xr += (cy - mouseY) / 100;
			render();
		}
		
		private function render():void {
			pers.fieldOfView = 100;
			pmtx.identity();
			pmtx.appendRotation(yr, Vector3D.Y_AXIS);
			pmtx.appendRotation(xr, Vector3D.X_AXIS);
			pmtx.appendTranslation(0, 0, pers.focalLength);
			pmtx.append(pers.toMatrix3D());
			bugfix(pmtx);
			Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
			canvas.fillRect(canvasRect, 0x000000);
			
			var fl:Number = pers.focalLength;
			for (var i:uint = 0; i < pVerts.length / 2; i ++) {
				var lev:uint = uvts[i * 3 + 2] * fl * 100;
				/*
				if (i % 100 == 0) {
					trace(lev);
				}
				*/
				lev = (lev > 255) ? 255 : lev;
				canvas.setPixel(pVerts[i * 2] + cx, pVerts[i * 2 + 1] + cy, 0xff0000  | lev << 8 | lev);
			}
		}
		
		
		private function bugfix(matrix:Matrix3D):void {
			var m1:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0 ]));
			var m2:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0 ]));
			m1.append(m2);
			if (m1.rawData[15] == 20) {
				var rawData:Vector.<Number> = matrix.rawData;
				rawData[15] /= 20;
				matrix.rawData = rawData;
			}
		}
		
	}
}