/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/51QM
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=213
    public class Euler213 extends Sprite {
        private var _tf : TextField;
  
        // 各ノミの50ring後の存在確率をシミュレート、そのあと
        // 各セルについてどのノミも存在しない確率を計算して合計する。
        public function Euler213() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            tr(solve());
            var g : int = getTimer();
            tr((g - s) + " ms");
        }

        private function solve() : Number
        {
            var M : int = 30;
            var N : int = 30;
            var R : int = 50;
            var i : int, j : int, k : int, l : int;
            
            var d : Array = new Array(M * N);
            for(i = 0;i < M;i++){
                for(j = 0;j < N;j++){
                    var cells : Array = [];
                    if(i - 1 >= 0)cells.push((i - 1) * N + j);
                    if(i + 1 < M)cells.push((i + 1) * N + j);
                    if(j - 1 >= 0)cells.push(i * N + j - 1);
                    if(j + 1 < N)cells.push(i * N + j + 1);
                    d[i * N + j] = cells;
                }
            }
            
            var e : Array = new Array(M * N);
            for(i = 0;i < M * N;i++)e[i] = 1.0;
            
            var f : Array = new Array(M * N);
            for(i = 0;i < M;i++){
                for(j = 0;j < N;j++){
                    for(k = 0;k < M * N;k++)f[k] = 0.0;
                    f[i * N + j] = 1.0;
                    
                    for(var r : int = 0;r < R;r++){
                        var nf : Array = new Array(M * N);
                        for(k = 0;k < M * N;k++)nf[k] = 0.0;
            
                        for(k = 0;k < M * N;k++){
                            if(f[k] == 0.0)continue;
                            var p : Number = f[k] / d[k].length;
                            for each(var cell : int in d[k]){
                                nf[cell] += p;
                            }
                        }
                        f = nf;
                    }
                    
                    for(k = 0;k < M * N;k++){
                        e[k] *= 1.0 - f[k];
                    }
                }
            }
            
            var ret : Number = 0.0;
            for(k = 0;k < M * N;k++){
                ret += e[k];
            }
            return ret;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}